/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import tigase.conf.ConfigurationException;
import tigase.conf.ConfiguratorAbstract;
import tigase.server.AbstractMessageReceiver;
import tigase.server.ComponentInfo;
import tigase.server.MessageReceiver;
import tigase.server.MessageRouterIfc;
import tigase.server.ThreadExceptionHandler;
import tigase.util.ClassUtil;
import tigase.xml.XMLUtils;

public final class XMPPServer {
    public static final String CONFIGURATOR_PROP_KEY = "tigase-configurator";
    private static final String DEF_CONFIGURATOR = "tigase.conf.Configurator";
    public static final String HARDENED_MODE_KEY = "hardened-mode";
    public static final String NAME = "Tigase";
    private static String serverName = "message-router";
    private static MessageRouterIfc router = null;
    private static ConfiguratorAbstract config = null;
    private static boolean inOSGi = false;

    public static boolean isHardenedModeEnabled() {
        return System.getProperty(HARDENED_MODE_KEY) == null ? false : Boolean.getBoolean(HARDENED_MODE_KEY);
    }

    private XMPPServer() {
    }

    public static String getImplementationVersion() {
        String version = ComponentInfo.getImplementationVersion(XMPPServer.class);
        return version.isEmpty() ? "0.0.0-0" : version;
    }

    public static String help() {
        return "\nParameters:\n -h               this help message\n -v               prints server version info\n -n server-name    sets server name\n";
    }

    public static void main(String[] args) {
        XMPPServer.parseParams(args);
        System.out.println(new ComponentInfo(XMLUtils.class).toString());
        System.out.println(new ComponentInfo(ClassUtil.class).toString());
        System.out.println(new ComponentInfo(XMPPServer.class).toString());
        XMPPServer.start(args);
    }

    public static void start(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new ThreadExceptionHandler());
        if (!XMPPServer.isOSGi()) {
            String initial_config = "tigase.level=ALL\ntigase.xml.level=INFO\nhandlers=java.util.logging.ConsoleHandler\njava.util.logging.ConsoleHandler.level=ALL\njava.util.logging.ConsoleHandler.formatter=tigase.util.LogFormatter\n";
            ConfiguratorAbstract.loadLogManagerConfig(initial_config);
        }
        try {
            String config_class_name = System.getProperty(CONFIGURATOR_PROP_KEY, DEF_CONFIGURATOR);
            config = (ConfiguratorAbstract)Class.forName(config_class_name).newInstance();
            config.init(args);
            config.setName("basic-conf");
            String mr_class_name = config.getMessageRouterClassName();
            router = (MessageRouterIfc)Class.forName(mr_class_name).newInstance();
            router.setName(serverName);
            router.setConfig(config);
            router.start();
        }
        catch (ConfigurationException e) {
            System.err.println("");
            System.err.println("  --------------------------------------");
            System.err.println("  ERROR! Terminating the server process.");
            System.err.println("  Invalid configuration data: " + e);
            System.err.println("  Please fix the problem and start the server again.");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("");
            System.err.println("  --------------------------------------");
            System.err.println("  ERROR! Terminating the server process.");
            System.err.println("  Problem initializing the server: " + e);
            System.err.println("  Please fix the problem and start the server again.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void setOSGi(boolean val) {
        inOSGi = val;
    }

    public static boolean isOSGi() {
        return inOSGi;
    }

    public static void stop() {
        ((AbstractMessageReceiver)((Object)router)).stop();
    }

    public static ConfiguratorAbstract getConfigurator() {
        return config;
    }

    public static MessageReceiver getComponent(String name) {
        return (MessageReceiver)config.getComponent(name);
    }

    public static void parseParams(String[] args) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    System.out.print(XMPPServer.help());
                    System.exit(0);
                }
                if (args[i].equals("-v")) {
                    System.out.print(XMPPServer.version());
                    System.exit(0);
                }
                if (!args[i].equals("-n")) continue;
                if (i + 1 == args.length) {
                    System.out.print(XMPPServer.help());
                    System.exit(1);
                    continue;
                }
                serverName = args[++i];
            }
        }
    }

    public static String version() {
        return "\n-- \nTigase XMPP Server, version: " + XMPPServer.getImplementationVersion() + "\n" + "Author:  Artur Hefczyc <artur.hefczyc@tigase.org>\n" + "-- \n";
    }
}

