/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.UserRepository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

public class PubSubDAOPool
extends PubSubDAO {
    private static final Logger log = Logger.getLogger(PubSubDAOPool.class.getName());
    private final Map<BareJID, LinkedBlockingQueue<PubSubDAO>> pools = new HashMap<BareJID, LinkedBlockingQueue<PubSubDAO>>();

    public PubSubDAOPool(UserRepository userRepository) {
        super(userRepository);
    }

    public void addDao(BareJID domain, PubSubDAO dao) {
        LinkedBlockingQueue<PubSubDAO> ee = this.pools.get(domain);
        if (ee == null) {
            ee = new LinkedBlockingQueue();
            this.pools.put(domain, ee);
        }
        ee.offer(dao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.addToRootCollection(serviceJid, nodeName);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, Long collectionId) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                long l = dao.createNode(serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collectionId);
                return l;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(BareJID serviceJid, long nodeId, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.deleteItem(serviceJid, nodeId, id);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(BareJID serviceJid, long nodeId) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.deleteNode(serviceJid, nodeId);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllNodesList(BareJID serviceJid) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getAllNodesList(serviceJid);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getItem(BareJID serviceJid, long nodeId, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Element element = dao.getItem(serviceJid, nodeId, id);
                return element;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getItemCreationDate(BareJID serviceJid, long nodeId, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Date date = dao.getItemCreationDate(serviceJid, nodeId, id);
                return date;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(BareJID serviceJid, long nodeId) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getItemsIds(serviceJid, nodeId);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIdsSince(BareJID serviceJid, long nodeId, Date since) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getItemsIdsSince(serviceJid, nodeId, since);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IItems.ItemMeta> getItemsMeta(BareJID serviceJid, long nodeId, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                List<IItems.ItemMeta> list = dao.getItemsMeta(serviceJid, nodeId, nodeName);
                return list;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getItemUpdateDate(BareJID serviceJid, long nodeId, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Date date = dao.getItemUpdateDate(serviceJid, nodeId, id);
                return date;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeAffiliations getNodeAffiliations(BareJID serviceJid, long nodeId) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                NodeAffiliations nodeAffiliations = dao.getNodeAffiliations(serviceJid, nodeId);
                return nodeAffiliations;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeConfig(BareJID serviceJid, long nodeId) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String string = dao.getNodeConfig(serviceJid, nodeId);
                return string;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodeId(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                long l = dao.getNodeId(serviceJid, nodeName);
                return l;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNodesList(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getNodesList(serviceJid, nodeName);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSubscriptions getNodeSubscriptions(BareJID serviceJid, long nodeId) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                NodeSubscriptions nodeSubscriptions = dao.getNodeSubscriptions(serviceJid, nodeId);
                return nodeSubscriptions;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    protected String getPoolDetails(BareJID serviceJid) {
        LinkedBlockingQueue<PubSubDAO> ee;
        String result = "";
        if (this.pools.containsKey(serviceJid)) {
            result = result + serviceJid + " pool ";
            ee = this.pools.get(serviceJid);
        } else {
            result = result + "default pool ";
            ee = this.pools.get(null);
        }
        result = result + "has " + ee.size() + " element(s).";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getChildNodes(serviceJid, nodeName);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Map<String, UsersAffiliation> map = dao.getUserAffiliations(serviceJid, jid);
                return map;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID jid) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Map<String, UsersSubscription> map = dao.getUserSubscriptions(serviceJid, jid);
                return map;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    @Override
    public void init() throws RepositoryException {
    }

    protected void offerDao(BareJID serviceJid, PubSubDAO dao) {
        LinkedBlockingQueue<PubSubDAO> ee = this.pools.containsKey(serviceJid) ? this.pools.get(serviceJid) : this.pools.get(null);
        ee.offer(dao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFromRootCollection(BareJID serviceJid) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.removeAllFromRootCollection(serviceJid);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromRootCollection(BareJID serviceJid, long nodeId) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.removeFromRootCollection(serviceJid, nodeId);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeSubscription(BareJID serviceJid, long nodeId, BareJID jid) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.removeNodeSubscription(serviceJid, nodeId, jid);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    public PubSubDAO takeDao(BareJID serviceJid) {
        try {
            LinkedBlockingQueue<PubSubDAO> ee = this.pools.containsKey(serviceJid) ? this.pools.get(serviceJid) : this.pools.get(null);
            return ee.take();
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Couldn't obtain PubSub DAO from the pool", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeAffiliation(BareJID serviceJid, long nodeId, UsersAffiliation affiliation) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateNodeAffiliation(serviceJid, nodeId, affiliation);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeConfig(BareJID serviceJid, long nodeId, String serializedData, Long collectionId) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateNodeConfig(serviceJid, nodeId, serializedData, collectionId);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeSubscription(BareJID serviceJid, long nodeId, UsersSubscription subscription) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateNodeSubscription(serviceJid, nodeId, subscription);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItem(BareJID serviceJid, long nodeId, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.writeItem(serviceJid, nodeId, timeInMilis, id, publisher, item);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }
}

