/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.action;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.server.amp.ActionAbstract;
import tigase.server.amp.ActionResultsHandlerIfc;
import tigase.server.amp.MsgRepository;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;

public class Store
extends ActionAbstract {
    private static final Logger log = Logger.getLogger(Store.class.getName());
    private static final String name = "store";
    private Thread expiredProcessor = null;
    private MsgRepository repo = null;
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public Store() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Packet packet, Element rule) {
        if (this.repo != null) {
            Date expired = null;
            String stamp = null;
            if (packet.getAttributeStaticStr("expired") == null) {
                if (rule == null) {
                    rule = this.getExpireAtRule(packet);
                }
            } else {
                this.removeExpireAtRule(packet);
                rule = null;
            }
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                if (rule != null) {
                    try {
                        expired = this.formatter.parse(rule.getAttributeStaticStr("value"));
                    }
                    catch (Exception e) {
                        log.log(Level.INFO, "Incorrect expire-at value: " + rule.getAttributeStaticStr("value"), e);
                        expired = null;
                    }
                }
                stamp = this.formatter.format(new Date());
            }
            this.removeTigasePayload(packet);
            try {
                Element elem = packet.getElement();
                if (elem.getChild("delay", "urn:xmpp:delay") == null) {
                    Element x = new Element("delay", "Offline Storage", new String[]{"from", "stamp", "xmlns"}, new String[]{packet.getStanzaTo().getDomain(), stamp, "urn:xmpp:delay"});
                    elem.addChild(x);
                }
                this.repo.storeMessage(packet.getStanzaFrom(), packet.getStanzaTo(), expired, elem);
            }
            catch (UserNotFoundException ex) {
                log.info("User not found for offline message: " + packet);
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String db_uri = (String)params.get("--amp-repo-uri");
        if (db_uri == null) {
            db_uri = (String)params.get("user-repo-url");
        }
        if (db_uri != null) {
            defs.put("amp-repo-uri", db_uri);
        }
        return defs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setProperties(Map<String, Object> props, ActionResultsHandlerIfc handler) {
        super.setProperties(props, handler);
        String db_uri = (String)props.get("amp-repo-uri");
        if (db_uri != null) {
            this.repo = MsgRepository.getInstance(db_uri);
            try {
                HashMap<String, String> db_props = new HashMap<String, String>(4);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (entry.getValue() == null) continue;
                    log.log(Level.WARNING, "Reading properties: (" + entry.getKey() + ", " + entry.getValue() + ")");
                    db_props.put(entry.getKey(), entry.getValue().toString());
                }
                this.repo.initRepository(db_uri, db_props);
            }
            catch (SQLException ex) {
                this.repo = null;
                log.log(Level.WARNING, "Problem initializing connection to DB: ", ex);
            }
        }
        if (this.repo != null && this.expiredProcessor == null) {
            this.expiredProcessor = new Thread("expired-processor"){

                @Override
                public void run() {
                    while (true) {
                        Element elem;
                        if ((elem = Store.this.repo.getMessageExpired(0L, true)) == null) {
                            continue;
                        }
                        elem.addAttribute("offline", "1");
                        elem.addAttribute("expired", "1");
                        try {
                            Store.this.resultsHandler.addOutPacket(Packet.packetInstance(elem));
                            continue;
                        }
                        catch (TigaseStringprepException ex) {
                            log.info("Stringprep error for offline message loaded from DB: " + elem);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.expiredProcessor.setDaemon(true);
            this.expiredProcessor.start();
        }
    }

    private Element getExpireAtRule(Packet packet) {
        Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
        List<Element> rules = amp.getChildren();
        Element rule = null;
        if (rules != null && rules.size() > 0) {
            for (Element r : rules) {
                String cond = r.getAttributeStaticStr("condition");
                if (cond == null || !cond.equals("expire-at")) continue;
                rule = r;
                break;
            }
        }
        return rule;
    }

    private void removeExpireAtRule(Packet packet) {
        Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
        List<Element> rules = amp.getChildren();
        if (rules != null && rules.size() > 0) {
            for (Element r : rules) {
                String cond = r.getAttributeStaticStr("condition");
                if (cond == null || !cond.equals("expire-at")) continue;
                amp.removeChild(r);
                break;
            }
        }
        if ((rules = amp.getChildren()) == null || rules.size() == 0) {
            packet.getElement().removeChild(amp);
        }
    }
}

