/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.jdmk.UnsignedLong;
import com.sun.management.snmp.SnmpCounter;
import com.sun.management.snmp.SnmpCounter64;
import com.sun.management.snmp.SnmpDataTypeEnums;
import com.sun.management.snmp.SnmpGauge;
import com.sun.management.snmp.SnmpInt;
import com.sun.management.snmp.SnmpIpAddress;
import com.sun.management.snmp.SnmpNull;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpOidRecord;
import com.sun.management.snmp.SnmpOidTable;
import com.sun.management.snmp.SnmpOpaque;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;
import com.sun.management.snmp.SnmpStringFixed;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpValue;
import java.io.Serializable;

public class SnmpVarBind
implements SnmpDataTypeEnums,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5059006593897949375L;
    public static final String[] statusLegend = new String[]{"Status Mapper", "Value not initialized", "Valid Value", "No such object", "No such Instance", "End of Mib View"};
    public static final int stValueUnspecified = 1;
    public static final int stValueOk = 2;
    public static final int stValueNoSuchObject = 3;
    public static final int stValueNoSuchInstance = 4;
    public static final int stValueEndOfMibView = 5;
    public static final SnmpNull noSuchObject = new SnmpNull(128);
    public static final SnmpNull noSuchInstance = new SnmpNull(129);
    public static final SnmpNull endOfMibView = new SnmpNull(130);
    private SnmpOid oid = null;
    private SnmpValue value = null;
    public int status = 1;

    public SnmpVarBind() {
    }

    public SnmpVarBind(SnmpOid oid) {
        this.oid = oid;
    }

    public SnmpVarBind(SnmpOid oid, SnmpValue val) {
        this.oid = oid;
        this.setSnmpValue(val);
    }

    public SnmpVarBind(String name) throws SnmpStatusException {
        if (name.startsWith(".")) {
            this.oid = new SnmpOid(name);
        } else {
            SnmpOidRecord record = null;
            try {
                int index = name.indexOf(46);
                this.handleLong(name, index);
                this.oid = new SnmpOid(name);
            }
            catch (NumberFormatException e) {
                int index = name.indexOf(46);
                if (index <= 0) {
                    record = this.resolveVarName(name);
                    this.oid = new SnmpOid(record.getName());
                }
                record = this.resolveVarName(name.substring(0, index));
                this.oid = new SnmpOid(record.getName() + name.substring(index));
            }
        }
    }

    public final SnmpOid getOid() {
        return this.oid;
    }

    public final void setOid(SnmpOid oid) {
        this.setOid(oid, true);
    }

    public final void setOid(SnmpOid oid, boolean clearValue) {
        this.oid = oid;
        if (clearValue) {
            this.clearValue();
        }
    }

    public final synchronized SnmpValue getSnmpValue() {
        return this.value;
    }

    public final void setSnmpValue(SnmpValue val) {
        this.value = val;
        this.setValueValid();
    }

    public final SnmpCounter64 getSnmpCounter64Value() throws ClassCastException {
        return (SnmpCounter64)this.value;
    }

    public final void setSnmpCounter64Value(long val) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpCounter64(val);
        this.setValueValid();
    }

    public final void setSnmpCounter64Value(UnsignedLong val) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpCounter64(val);
        this.setValueValid();
    }

    public final SnmpInt getSnmpIntValue() throws ClassCastException {
        return (SnmpInt)this.value;
    }

    public final void setSnmpIntValue(long val) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpInt(val);
        this.setValueValid();
    }

    public final SnmpCounter getSnmpCounterValue() throws ClassCastException {
        return (SnmpCounter)this.value;
    }

    public final void setSnmpCounterValue(long val) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpCounter(val);
        this.setValueValid();
    }

    public final SnmpGauge getSnmpGaugeValue() throws ClassCastException {
        return (SnmpGauge)this.value;
    }

    public final void setSnmpGaugeValue(long val) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpGauge(val);
        this.setValueValid();
    }

    public final SnmpTimeticks getSnmpTimeticksValue() throws ClassCastException {
        return (SnmpTimeticks)this.value;
    }

    public final void setSnmpTimeticksValue(long val) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpTimeticks(val);
        this.setValueValid();
    }

    public final SnmpOid getSnmpOidValue() throws ClassCastException {
        return (SnmpOid)this.value;
    }

    public final void setSnmpOidValue(String val) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpOid(val);
        this.setValueValid();
    }

    public final SnmpIpAddress getSnmpIpAddressValue() throws ClassCastException {
        return (SnmpIpAddress)this.value;
    }

    public final void setSnmpIpAddressValue(String val) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpIpAddress(val);
        this.setValueValid();
    }

    public final SnmpString getSnmpStringValue() throws ClassCastException {
        return (SnmpString)this.value;
    }

    public final void setSnmpStringValue(String val) {
        this.clearValue();
        this.value = new SnmpString(val);
        this.setValueValid();
    }

    public final SnmpOpaque getSnmpOpaqueValue() throws ClassCastException {
        return (SnmpOpaque)this.value;
    }

    public final void setSnmpOpaqueValue(byte[] val) {
        this.clearValue();
        this.value = new SnmpOpaque(val);
        this.setValueValid();
    }

    public final SnmpStringFixed getSnmpStringFixedValue() throws ClassCastException {
        return (SnmpStringFixed)this.value;
    }

    public final void setSnmpStringFixedValue(String val) {
        this.clearValue();
        this.value = new SnmpStringFixed(val);
        this.setValueValid();
    }

    public SnmpOidRecord resolveVarName(String name) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = this;
        SnmpOidTable mibTable = snmpVarBind.oid.getSnmpOidTable();
        if (mibTable == null) {
            throw new SnmpStatusException(2);
        }
        int index = name.indexOf(46);
        if (index < 0) {
            return mibTable.resolveVarName(name);
        }
        return mibTable.resolveVarOid(name);
    }

    public final int getValueStatus() {
        return this.status;
    }

    public final String getValueStatusLegend() {
        return statusLegend[this.status];
    }

    public final boolean isValidValue() {
        return this.status == 2;
    }

    public final boolean isUnspecifiedValue() {
        return this.status == 1;
    }

    public final void clearValue() {
        this.value = null;
        this.status = 1;
    }

    public final boolean isOidEqual(SnmpVarBind var) {
        return this.oid.equals(var.oid);
    }

    public final void addInstance(long inst) {
        this.oid.append(inst);
    }

    public final void addInstance(long[] inst) throws SnmpStatusException {
        this.oid.addToOid(inst);
    }

    public final void addInstance(String inst) throws SnmpStatusException {
        if (inst != null) {
            this.oid.addToOid(inst);
        }
    }

    public void insertInOid(int oid) {
        this.oid.insert(oid);
    }

    public void appendInOid(SnmpOid oid) {
        this.oid.append(oid);
    }

    public final synchronized boolean hasVarBindException() {
        switch (this.status) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void copyValueAndOid(SnmpVarBind var) {
        this.setOid((SnmpOid)var.oid.clone());
        this.copyValue(var);
    }

    public void copyValue(SnmpVarBind var) {
        if (var.isValidValue()) {
            this.value = var.getSnmpValue().duplicate();
            this.setValueValid();
        } else {
            this.status = var.getValueStatus();
            this.value = this.status == 5 ? endOfMibView : (this.status == 3 ? noSuchObject : (this.status == 4 ? noSuchInstance : null));
        }
    }

    public Object cloneWithoutValue() {
        SnmpOid noid = (SnmpOid)this.oid.clone();
        return new SnmpVarBind(noid);
    }

    public Object clone() {
        SnmpVarBind v = new SnmpVarBind();
        v.copyValueAndOid(this);
        return v;
    }

    public final String getStringValue() {
        return this.value.toString();
    }

    public final void setNoSuchObject() {
        this.value = noSuchObject;
        this.status = 3;
    }

    public final void setNoSuchInstance() {
        this.value = noSuchInstance;
        this.status = 4;
    }

    public final void setEndOfMibView() {
        this.value = endOfMibView;
        this.status = 5;
    }

    public final String toString() {
        StringBuffer s = new StringBuffer(400);
        s.append("Object ID : " + this.oid.toString());
        if (this.isValidValue()) {
            s.append("  (Syntax : " + this.value.getTypeName() + ")\n");
            s.append("Value : " + this.value.toString());
        } else {
            s.append("\nValue Exception : " + this.getValueStatusLegend());
        }
        return s.toString();
    }

    private void setValueValid() {
        this.status = this.value == endOfMibView ? 5 : (this.value == noSuchObject ? 3 : (this.value == noSuchInstance ? 4 : 2));
    }

    private void handleLong(String oid, int index) throws NumberFormatException, SnmpStatusException {
        String str = index > 0 ? oid.substring(0, index) : oid;
        Long.parseLong(str);
    }
}

