/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class OfflineMessages
extends XMPPProcessor
implements XMPPPostprocessorIfc,
XMPPProcessorIfc {
    protected static final String XMLNS = "jabber:client";
    private static final String ID = "msgoffline";
    private static final Logger log = Logger.getLogger(OfflineMessages.class.getName());
    private static final String[][] ELEMENTS = new String[][]{{"presence"}};
    private static final String[] XMLNSS = new String[]{"jabber:client"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"msgoffline"})};
    private static final String defHost = DNSResolver.getDefaultHostname();
    public static final String[] MESSAGE_EVENT_PATH = new String[]{"message", "event"};
    public static final String[] MESSAGE_HEADER_PATH = new String[]{"message", "header"};
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public OfflineMessages() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void postProcess(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> queue, Map<String, Object> settings) {
        block3: {
            if (conn == null) {
                try {
                    MsgRepositoryIfc msg_repo = this.getMsgRepoImpl(repo, conn);
                    this.savePacketForOffLineUser(packet, msg_repo);
                }
                catch (UserNotFoundException e) {
                    if (!log.isLoggable(Level.FINEST)) break block3;
                    log.finest("UserNotFoundException at trying to save packet for off-line user." + packet);
                }
            }
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException {
        if (this.loadOfflineMessages(packet, conn)) {
            try {
                MsgRepositoryIfc msg_repo = this.getMsgRepoImpl(repo, conn);
                Queue<Packet> packets = this.restorePacketForOffLineUser(conn, msg_repo);
                if (packets != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Sending off-line messages: " + packets.size());
                    }
                    results.addAll(packets);
                }
            }
            catch (UserNotFoundException e) {
                log.info("Something wrong, DB problem, cannot load offline messages. " + e);
            }
        }
    }

    public Queue<Packet> restorePacketForOffLineUser(XMPPResourceConnection conn, MsgRepositoryIfc repo) throws UserNotFoundException, NotAuthorizedException {
        Queue<Element> elems = repo.loadMessagesToJID(conn.getJID(), true);
        if (elems != null) {
            LinkedList<Packet> pacs = new LinkedList<Packet>();
            Element elem = null;
            while ((elem = elems.poll()) != null) {
                try {
                    pacs.offer(Packet.packetInstance(elem));
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Packet addressing problem, stringprep failed: " + elem);
                }
            }
            try {
                Collections.sort(pacs, new StampComparator());
            }
            catch (NullPointerException e) {
                try {
                    log.warning("Can not sort off line messages: " + pacs + ",\n" + e);
                }
                catch (Exception exc) {
                    log.log(Level.WARNING, "Can not print log message.", exc);
                }
            }
            return pacs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePacketForOffLineUser(Packet pac, MsgRepositoryIfc repo) throws UserNotFoundException {
        StanzaType type = pac.getType();
        if (pac.getElemName().equals("message") && (pac.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH) != null || pac.getElemChildrenStaticStr(MESSAGE_EVENT_PATH) != null || pac.getElemChildrenStaticStr(MESSAGE_HEADER_PATH) != null) && (type == null || type == StanzaType.normal || type == StanzaType.chat) || pac.getElemName().equals("presence") && (type == StanzaType.subscribe || type == StanzaType.subscribed || type == StanzaType.unsubscribe || type == StanzaType.unsubscribed)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Storing packet for offline user: {0}", pac);
            }
            Element elem = pac.getElement().clone();
            String stamp = null;
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                stamp = this.formatter.format(new Date());
            }
            String from = pac.getStanzaTo().getDomain();
            Element x = new Element("delay", "Offline Storage - " + defHost, new String[]{"from", "stamp", "xmlns"}, new String[]{from, stamp, "urn:xmpp:delay"});
            elem.addChild(x);
            repo.storeMessage(pac.getStanzaFrom(), pac.getStanzaTo(), null, elem);
            pac.processedBy(ID);
            return true;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Packet for offline user not suitable for storing: {0}", pac);
        }
        return false;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    protected MsgRepositoryIfc getMsgRepoImpl(NonAuthUserRepository repo, XMPPResourceConnection conn) {
        return new MsgRepositoryImpl(repo, conn);
    }

    protected boolean loadOfflineMessages(Packet packet, XMPPResourceConnection conn) {
        if (conn == null || conn.isAnonymous()) {
            return false;
        }
        if (conn.getSessionData(ID) != null) {
            return false;
        }
        StanzaType type = packet.getType();
        if (type == null || type == StanzaType.available) {
            String priority_str = packet.getElemCDataStaticStr(Presence.PRESENCE_PRIORITY_PATH);
            int priority = 0;
            if (priority_str != null) {
                try {
                    priority = Integer.decode(priority_str);
                }
                catch (NumberFormatException e) {
                    priority = 0;
                }
            }
            if (priority >= 0) {
                conn.putSessionData(ID, ID);
                return true;
            }
        }
        return false;
    }

    private class StampComparator
    implements Comparator<Packet> {
        private StampComparator() {
        }

        @Override
        public int compare(Packet p1, Packet p2) {
            String stamp1 = "";
            String stamp2 = "";
            Element stamp_el1 = p1.getElement().getChild("delay", "urn:xmpp:delay");
            if (stamp_el1 == null) {
                stamp_el1 = p1.getElement().getChild("x", "jabber:x:delay");
            }
            stamp1 = stamp_el1.getAttributeStaticStr("stamp");
            Element stamp_el2 = p2.getElement().getChild("delay", "urn:xmpp:delay");
            if (stamp_el2 == null) {
                stamp_el2 = p2.getElement().getChild("x", "jabber:x:delay");
            }
            stamp2 = stamp_el2.getAttributeStaticStr("stamp");
            return stamp1.compareTo(stamp2);
        }
    }

    private class MsgRepositoryImpl
    implements MsgRepositoryIfc {
        private XMPPResourceConnection conn = null;
        private SimpleParser parser = SingletonFactory.getParserInstance();
        private NonAuthUserRepository repo = null;

        private MsgRepositoryImpl(NonAuthUserRepository repo, XMPPResourceConnection conn) {
            this.repo = repo;
            this.conn = conn;
        }

        @Override
        public Element getMessageExpired(long time, boolean delete) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Queue<Element> loadMessagesToJID(JID to, boolean delete) throws UserNotFoundException {
            try {
                DomBuilderHandler domHandler = new DomBuilderHandler();
                String[] msgs = this.conn.getOfflineDataList(OfflineMessages.ID, "messages");
                if (msgs != null && msgs.length > 0) {
                    this.conn.removeOfflineData(OfflineMessages.ID, "messages");
                    StringBuilder sb = new StringBuilder();
                    for (String msg : msgs) {
                        sb.append(msg);
                    }
                    char[] data = sb.toString().toCharArray();
                    this.parser.parse(domHandler, data, 0, data.length);
                    return domHandler.getParsedElements();
                }
            }
            catch (NotAuthorizedException ex) {
                log.info("User not authrized to retrieve offline messages, this happens quite often on some installations where there are a very short living client connections. They can disconnect at any time. " + ex);
            }
            catch (TigaseDBException ex) {
                log.warning("Error accessing database for offline message: " + ex);
            }
            return null;
        }

        @Override
        public void storeMessage(JID from, JID to, Date expired, Element msg) throws UserNotFoundException {
            this.repo.addOfflineDataList(to.getBareJID(), OfflineMessages.ID, "messages", new String[]{msg.toString()});
        }
    }
}

