/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

public class FloatHistoryCache {
    private float[] buffer = null;
    private int start = 0;
    private int count = 0;

    public FloatHistoryCache(int limit) {
        this.buffer = new float[limit];
    }

    public synchronized void addItem(float item) {
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = item;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
    }

    public synchronized float[] getCurrentHistory() {
        float[] result = new float[this.count];
        for (int i = 0; i < this.count; ++i) {
            int ix = (this.start + i) % this.buffer.length;
            result[i] = this.buffer[ix];
        }
        return result;
    }
}

