/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.filters;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.PacketFilterIfc;
import tigase.server.QueueType;
import tigase.stats.StatisticsList;

public class PacketCounter
implements PacketFilterIfc {
    private long clusterCounter = 0L;
    private long[] iqCounters = new long[1];
    private int lastNodeNo = -1;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private long msgCounter = 0L;
    private String name = null;
    private long otherCounter = 0L;
    private long presCounter = 0L;
    private QueueType qType = null;
    private ConcurrentHashMap<String, Integer> iqCounterIdx = new ConcurrentHashMap();

    @Override
    public Packet filter(Packet packet) {
        if (packet.getElemName() == "message") {
            ++this.msgCounter;
            return packet;
        }
        if (packet.getElemName() == "presence") {
            ++this.presCounter;
            return packet;
        }
        if (packet.getElemName() == "cluster") {
            ++this.clusterCounter;
            return packet;
        }
        ++this.otherCounter;
        if (packet.getElemName() == "iq") {
            String xmlns = ((Iq)packet).getIQXMLNS();
            this.incIQCounter(xmlns != null ? xmlns : ((Iq)packet).getIQChildName());
        }
        return packet;
    }

    @Override
    public void init(String name, QueueType qType) {
        this.name = name;
        this.qType = qType;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.name, this.qType.name() + "processed messages", this.msgCounter, Level.FINER);
        list.add(this.name, this.qType.name() + "processed presences", this.presCounter, Level.FINER);
        list.add(this.name, this.qType.name() + "processed cluster", this.clusterCounter, Level.FINER);
        list.add(this.name, this.qType.name() + "processed other", this.otherCounter, Level.FINER);
        list.add(this.name, this.qType.name() + "processed IQ no XMLNS", this.iqCounters[0], Level.FINER);
        long iqs = this.iqCounters[0];
        for (Map.Entry<String, Integer> iqCounter : this.iqCounterIdx.entrySet()) {
            list.add(this.name, this.qType.name() + "processed IQ " + iqCounter.getKey(), this.iqCounters[iqCounter.getValue()], Level.FINER);
            iqs += this.iqCounters[iqCounter.getValue()];
        }
        list.add(this.name, this.qType.name() + "processed total IQ", iqs, Level.FINER);
    }

    private synchronized void incIQCounter(String xmlns) {
        if (xmlns == null) {
            this.iqCounters[0] = this.iqCounters[0] + 1L;
        } else {
            Integer idx = this.iqCounterIdx.get(xmlns);
            if (idx == null) {
                this.iqCounters = Arrays.copyOf(this.iqCounters, this.iqCounters.length + 1);
                idx = this.iqCounters.length - 1;
                this.iqCounterIdx.put(xmlns, idx);
            }
            int n = idx;
            this.iqCounters[n] = this.iqCounters[n] + 1L;
        }
    }
}

