/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.xmpp.BareJID;

public class Node {
    private boolean conNeedsWriting = false;
    private long creationTime = System.currentTimeMillis();
    private boolean deleted = false;
    private String name;
    private long nodeId;
    private NodeAffiliations nodeAffiliations;
    private AbstractNodeConfig nodeConfig;
    private NodeSubscriptions nodeSubscriptions;
    private BareJID serviceJid;

    public Node(long nodeId, BareJID serviceJid, AbstractNodeConfig nodeConfig, NodeAffiliations nodeAffiliations, NodeSubscriptions nodeSubscriptions) {
        this.nodeId = nodeId;
        this.serviceJid = serviceJid;
        this.nodeConfig = nodeConfig;
        this.nodeAffiliations = nodeAffiliations;
        this.nodeSubscriptions = nodeSubscriptions;
        this.name = nodeConfig.getNodeName();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void affiliationsMerge() {
        this.nodeAffiliations.merge();
    }

    public boolean affiliationsNeedsWriting() {
        return this.nodeAffiliations.isChanged();
    }

    public void affiliationsSaved() {
        this.affiliationsMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configCopyFrom(AbstractNodeConfig nodeConfig) {
        Node node = this;
        synchronized (node) {
            this.nodeConfig.copyFrom(nodeConfig);
            this.conNeedsWriting = true;
        }
    }

    public boolean configNeedsWriting() {
        return this.conNeedsWriting;
    }

    public void configSaved() {
        this.conNeedsWriting = false;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getName() {
        return this.name;
    }

    public NodeAffiliations getNodeAffiliations() {
        return this.nodeAffiliations;
    }

    public AbstractNodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    public NodeSubscriptions getNodeSubscriptions() {
        return this.nodeSubscriptions;
    }

    public BareJID getServiceJid() {
        return this.serviceJid;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean needsWriting() {
        return this.affiliationsNeedsWriting() || this.subscriptionsNeedsWriting() || this.conNeedsWriting;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void subscriptionsMerge() {
        this.nodeSubscriptions.merge();
    }

    public boolean subscriptionsNeedsWriting() {
        return this.nodeSubscriptions.isChanged();
    }

    public void subscriptionsSaved() {
        this.subscriptionsMerge();
    }

    public void resetChanges() {
        this.nodeAffiliations.resetChangedFlag();
        this.nodeSubscriptions.resetChangedFlag();
    }
}

