/*
 * Decompiled with CFR 0.152.
 */
package tigase.component2.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component2.PacketWriter;
import tigase.component2.exceptions.ComponentException;
import tigase.component2.modules.InitializingModule;
import tigase.component2.modules.Module;
import tigase.criteria.Criteria;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;

public class ModulesManager {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private final ArrayList<Module> modules = new ArrayList();
    private final PacketWriter writer;

    public ModulesManager() {
        this.writer = null;
    }

    public ModulesManager(PacketWriter writer) {
        this.writer = writer;
    }

    protected <T extends Module> T getByClass(Class<T> moduleClass) {
        for (Module m : this.modules) {
            if (!moduleClass.isInstance(m)) continue;
            return (T)m;
        }
        return null;
    }

    public Collection<String> getFeatures() {
        ArrayList<String> features = new ArrayList<String>();
        for (Module m : this.modules) {
            String[] fs = m.getFeatures();
            if (fs == null) continue;
            for (String string : fs) {
                features.add(string);
            }
        }
        return features;
    }

    public boolean isRegistered(Class<? extends Module> moduleClass) {
        for (Module m : this.modules) {
            if (!moduleClass.isInstance(m)) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Module module) {
        return this.modules.contains(module);
    }

    public boolean process(Packet packet) throws ComponentException, TigaseStringprepException {
        return this.process(packet, this.writer);
    }

    public boolean process(Packet packet, PacketWriter writer) throws ComponentException, TigaseStringprepException {
        if (writer == null) {
            throw new Error("ElementWriter is null");
        }
        boolean handled = false;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finest("Processing packet: " + packet.toString());
        }
        for (Module module : this.modules) {
            Criteria criteria = module.getModuleCriteria();
            if (criteria == null || !criteria.match(packet.getElement())) continue;
            handled = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Handled by module " + module.getClass());
            }
            module.process(packet);
            if (!this.log.isLoggable(Level.FINEST)) break;
            this.log.finest("Finished " + module.getClass());
            break;
        }
        return handled;
    }

    public <T extends Module> T register(T module, boolean skipIfExists) {
        Object old;
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Register Component module: " + module.getClass().getCanonicalName());
        }
        if (skipIfExists && (old = this.getByClass(module.getClass())) != null) {
            return (T)old;
        }
        this.modules.add(module);
        if (module instanceof InitializingModule) {
            ((InitializingModule)((Object)module)).onRegisterModule();
        }
        return module;
    }

    public void reset() {
        this.modules.clear();
    }

    public void unregister(Class<? extends Module> moduleClass) {
        HashSet<Module> toRemove = new HashSet<Module>();
        for (Module m : this.modules) {
            if (!moduleClass.isInstance(m)) continue;
            toRemove.add(m);
        }
        for (Module module : toRemove) {
            this.unregister(module);
        }
    }

    public void unregister(Module module) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Unregister Component module: " + module.getClass().getCanonicalName());
        }
        this.modules.remove(module);
        if (module instanceof InitializingModule) {
            ((InitializingModule)((Object)module)).onUnegisterModule();
        }
    }
}

