/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.MessageArchiveDB;
import tigase.archive.RSM;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;

public class MessageArchiveComponent
extends AbstractMessageReceiver {
    private static final Logger log = Logger.getLogger(MessageArchiveComponent.class.getCanonicalName());
    private static final String MSG_ARCHIVE_REPO_URI_PROP_KEY = "archive-repo-uri";
    private static final SimpleDateFormat formatter3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private MessageArchiveDB msg_repo = new MessageArchiveDB();

    public MessageArchiveComponent() {
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setName("message-archive");
    }

    public void processPacket(Packet packet) {
        block6: {
            if (packet.getStanzaTo() != null && !this.getComponentId().equals((Object)packet.getStanzaTo())) {
                this.storeMessage(packet);
                return;
            }
            try {
                try {
                    this.processActionPacket(packet);
                }
                catch (XMPPException ex) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "internal server while processing packet = " + packet.toString(), ex);
                    }
                    this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, (String)null, true));
                }
            }
            catch (PacketErrorTypeException ex) {
                if (!log.isLoggable(Level.FINEST)) break block6;
                log.log(Level.FINEST, "error with packet in error state - ignoring packet = {0}", packet);
            }
        }
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map defs = super.getDefaults(params);
        String db_uri = (String)params.get("user-repo-url");
        if (db_uri == null) {
            db_uri = (String)params.get("--user-db-uri");
        }
        if (db_uri != null) {
            defs.put(MSG_ARCHIVE_REPO_URI_PROP_KEY, db_uri);
        }
        return defs;
    }

    public String getDiscoDescription() {
        return "Message Archiving (XEP-0136) Support";
    }

    public void setProperties(Map<String, Object> props) {
        try {
            super.setProperties(props);
            if (props.size() == 1) {
                return;
            }
            HashMap<String, String> repoProps = new HashMap<String, String>(4);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                repoProps.put(entry.getKey(), entry.getValue().toString());
            }
            String uri = (String)props.get(MSG_ARCHIVE_REPO_URI_PROP_KEY);
            if (uri != null) {
                this.msg_repo.initRepository(uri, repoProps);
            } else {
                log.log(Level.SEVERE, "repository uri is NULL!");
            }
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "error initializing repository", ex);
        }
    }

    protected void processActionPacket(Packet packet) throws PacketErrorTypeException, XMPPException {
        block9: for (Element child : packet.getElement().getChildren()) {
            if (child.getName() == "list") {
                switch (packet.getType()) {
                    case get: {
                        this.listCollections(packet, child);
                        continue block9;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() == "retrieve") {
                switch (packet.getType()) {
                    case get: {
                        this.getMessages(packet, child);
                        continue block9;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() != "remove") continue;
            switch (packet.getType()) {
                case set: {
                    this.removeMessages(packet, child);
                    continue block9;
                }
            }
            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listCollections(Packet packet, Element list) throws XMPPException {
        try {
            SimpleDateFormat simpleDateFormat;
            Date tmp;
            Calendar cal;
            RSM rsm = RSM.parseRootElement(list);
            String with = list.getAttributeStaticStr("with");
            String startStr = list.getAttributeStaticStr("start");
            String stopStr = list.getAttributeStaticStr("end");
            if (rsm.getAfter() != null) {
                cal = Calendar.getInstance();
                tmp = this.parseTimestamp(rsm.getAfter());
                cal.setTime(tmp);
                cal.add(5, 1);
                simpleDateFormat = formatter2;
                synchronized (simpleDateFormat) {
                    startStr = formatter2.format(cal.getTime());
                }
            }
            if (rsm.getBefore() != null) {
                cal = Calendar.getInstance();
                tmp = this.parseTimestamp(rsm.getBefore());
                cal.setTime(tmp);
                cal.add(5, -1);
                simpleDateFormat = formatter2;
                synchronized (simpleDateFormat) {
                    stopStr = formatter2.format(cal.getTime());
                }
            }
            Date start = startStr != null ? this.parseTimestamp(startStr) : null;
            Date stop = stopStr != null ? this.parseTimestamp(stopStr) : null;
            List<Element> chats = this.msg_repo.getCollections(packet.getStanzaFrom().getBareJID(), with, start, stop, rsm);
            Element retList = new Element("list");
            retList.setXMLNS("urn:xmpp:archive");
            if (chats == null) {
                this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "No such collection", true));
                return;
            }
            if (!chats.isEmpty()) {
                retList.addChildren(chats);
                rsm.setFirst(chats.get(0).getAttributeStaticStr("start"));
                rsm.setLast(chats.get(chats.size() - 1).getAttributeStaticStr("start"));
                retList.addChild((XMLNodeIfc)rsm.toElement());
                this.addOutPacket(packet.okResult(retList, 0));
            } else {
                this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "No items in specified period", true));
            }
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error listing collections", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseTimestamp(String tmp) throws ParseException {
        Date date = null;
        if (tmp.endsWith("Z")) {
            SimpleDateFormat simpleDateFormat = formatter;
            synchronized (simpleDateFormat) {
                date = formatter.parse(tmp);
            }
        }
        if (tmp.contains(".")) {
            SimpleDateFormat simpleDateFormat = formatter3;
            synchronized (simpleDateFormat) {
                date = formatter3.parse(tmp);
            }
        }
        SimpleDateFormat simpleDateFormat = formatter2;
        synchronized (simpleDateFormat) {
            date = formatter2.parse(tmp);
        }
        return date;
    }

    private void removeMessages(Packet packet, Element remove) throws XMPPException {
        if (remove.getAttributeStaticStr("with") == null || remove.getAttributeStaticStr("start") == null || remove.getAttributeStaticStr("end") == null) {
            this.addOutPacket(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Parameters with, start, end cannot be null", true));
            return;
        }
        try {
            String startStr = remove.getAttributeStaticStr("start");
            String stopStr = remove.getAttributeStaticStr("end");
            Date start = this.parseTimestamp(startStr);
            Date stop = this.parseTimestamp(stopStr);
            this.msg_repo.removeItems(packet.getStanzaFrom().getBareJID(), remove.getAttributeStaticStr("with"), start, stop);
            this.addOutPacket(packet.okResult((Element)null, 0));
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error removing messages", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    private void storeMessage(Packet packet) {
        String ownerStr = packet.getAttributeStaticStr("owner");
        if (ownerStr != null) {
            packet.getElement().removeAttribute("owner");
            BareJID owner = BareJID.bareJIDInstanceNS((String)ownerStr);
            boolean outgoing = owner.equals((Object)packet.getStanzaFrom().getBareJID());
            BareJID buddy = outgoing ? packet.getStanzaTo().getBareJID() : packet.getStanzaFrom().getBareJID();
            this.msg_repo.archiveMessage(owner, buddy, (short)(!outgoing ? 1 : 0), packet.getElement());
        } else {
            log.log(Level.INFO, "Owner attribute missing from packet: {0}", packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMessages(Packet packet, Element retrieve) throws XMPPException {
        try {
            RSM rsm = RSM.parseRootElement(retrieve);
            if (rsm.getAfter() != null) {
                int offset = Integer.parseInt(rsm.getAfter());
                if (rsm.getIndex() != null) {
                    rsm.setIndex(offset);
                }
            }
            Date start = this.parseTimestamp(retrieve.getAttributeStaticStr("start"));
            Date end = null;
            if (retrieve.getAttributeStaticStr("end") != null) {
                end = this.parseTimestamp(retrieve.getAttributeStaticStr("end"));
            }
            List<Element> items = this.msg_repo.getItems(packet.getStanzaFrom().getBareJID(), retrieve.getAttributeStaticStr("with"), start, end, rsm);
            String startStr = null;
            SimpleDateFormat simpleDateFormat = formatter2;
            synchronized (simpleDateFormat) {
                startStr = formatter2.format(start);
            }
            Element retList = new Element("chat", new String[]{"with", "start"}, new String[]{retrieve.getAttributeStaticStr("with"), startStr});
            retList.setXMLNS("urn:xmpp:archive");
            if (!items.isEmpty()) {
                rsm.setFirst(items.get(0).getAttributeStaticStr("secs"));
                rsm.setLast(items.get(items.size() - 1).getAttributeStaticStr("secs"));
                retList.addChildren(items);
                retList.addChild((XMLNodeIfc)rsm.toElement());
            }
            this.addOutPacket(packet.okResult(retList, 0));
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Error retrieving messages", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter3.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

