/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import java.util.Map;
import tigase.component.ElementWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.MUCComponent;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.script.CommandIfc;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class DiscoItemsModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#items"));
    private final MUCComponent mucComponent;

    public DiscoItemsModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository, Map<String, CommandIfc> scriptCommands, MUCComponent mucComponent) {
        super(config, writer, mucRepository);
        this.mucComponent = mucComponent;
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet element) throws MUCException {
        try {
            JID requestedJID = JID.jidInstance((String)element.getAttributeStaticStr("to"));
            String node = element.getAttributeStaticStr(Iq.IQ_QUERY_PATH, "node");
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
            Packet result = element.okResult(resultQuery, 0);
            if (node != null && node.equals("http://jabber.org/protocol/commands")) {
                List items = this.mucComponent.getScriptItems(node, element.getStanzaTo(), element.getStanzaFrom());
                resultQuery.addChildren(items);
            } else if (node == null && requestedJID.getLocalpart() == null && requestedJID.getResource() == null) {
                BareJID[] roomsId;
                for (BareJID jid : roomsId = this.repository.getPublicVisibleRoomsIdList()) {
                    if (!jid.getDomain().equals(requestedJID.getDomain())) continue;
                    String name = this.repository.getRoomName(jid.toString());
                    resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{jid.toString(), name != null ? name : jid.getLocalpart()}));
                }
            } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() == null) {
                Room room = this.repository.getRoom(requestedJID.getBareJID());
                if (room == null) {
                    throw new MUCException(Authorization.ITEM_NOT_FOUND);
                }
                String nickname = room.getOccupantsNickname(element.getStanzaFrom());
                if (nickname == null) {
                    throw new MUCException(Authorization.FORBIDDEN);
                }
                for (String nick : room.getOccupantsNicknames()) {
                    resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{room.getRoomJID() + "/" + nick, nick}));
                }
            } else {
                if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() != null) {
                    throw new MUCException(Authorization.BAD_REQUEST);
                }
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            this.writer.write(result);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

