/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ConstraintDefinitionNode
extends TableElementNode {
    private TableName constraintName;
    protected int constraintType;
    protected Properties properties;
    ProviderList apl;
    UUIDFactory uuidFactory;
    String backingIndexName;
    UUID backingIndexUUID;
    int[] checkColumnReferences;
    ResultColumnList columnList;
    String constraintText;
    ValueNode checkCondition;
    private int behavior;
    private int verifyType = 5;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.constraintName = (TableName)object;
        super.init(null);
        if (this.constraintName != null) {
            this.name = this.constraintName.getTableName();
        }
        this.constraintType = (Integer)object2;
        this.properties = (Properties)object4;
        this.columnList = (ResultColumnList)object3;
        this.checkCondition = (ValueNode)object5;
        this.constraintText = (String)object6;
        this.behavior = (Integer)object7;
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.init(object, object2, object3, object4, object5, object6, ReuseFactory.getInteger(2));
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        this.init(object, object2, object3, object4, object5, object6, object7);
        this.verifyType = (Integer)object8;
    }

    public String toString() {
        return "";
    }

    protected void bind(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary) throws StandardException {
        if (this.constraintType == 5) {
            return;
        }
        if (this.constraintName != null) {
            String string = this.constraintName.getSchemaName();
            if (string != null) {
                TableName tableName = dDLStatementNode.getObjectName();
                String string2 = tableName.getSchemaName();
                if (string2 == null) {
                    string2 = this.getSchemaDescriptor(null).getSchemaName();
                    tableName.setSchemaName(string2);
                }
                if (!string.equals(string2)) {
                    throw StandardException.newException("42X85", (Object)this.constraintName, (Object)tableName);
                }
            }
        } else {
            this.name = this.getBackingIndexName(dataDictionary);
        }
    }

    String getConstraintMoniker() {
        return this.name;
    }

    String getDropSchemaName() {
        if (this.constraintName != null) {
            return this.constraintName.getSchemaName();
        }
        return null;
    }

    UUID getBackingIndexUUID() {
        if (this.backingIndexUUID == null) {
            this.backingIndexUUID = this.getUUIDFactory().createUUID();
        }
        return this.backingIndexUUID;
    }

    String getBackingIndexName(DataDictionary dataDictionary) {
        if (this.backingIndexName == null) {
            this.backingIndexName = dataDictionary.getSystemSQLName();
        }
        return this.backingIndexName;
    }

    void setAuxiliaryProviderList(ProviderList providerList) {
        this.apl = providerList;
    }

    public ProviderList getAuxiliaryProviderList() {
        return this.apl;
    }

    boolean hasPrimaryKeyConstraint() {
        return this.constraintType == 2;
    }

    boolean hasUniqueKeyConstraint() {
        return this.constraintType == 3;
    }

    boolean hasForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    boolean hasCheckConstraint() {
        return this.constraintType == 4;
    }

    boolean hasConstraint() {
        return true;
    }

    boolean requiresBackingIndex() {
        switch (this.constraintType) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    boolean requiresUniqueIndex() {
        switch (this.constraintType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    int getConstraintType() {
        return this.constraintType;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isReferenced() {
        return false;
    }

    public int getReferenceCount() {
        return 0;
    }

    public boolean isEnabled() {
        return true;
    }

    public ResultColumnList getColumnList() {
        return this.columnList;
    }

    public void setColumnList(ResultColumnList resultColumnList) {
        this.columnList = resultColumnList;
    }

    public ValueNode getCheckCondition() {
        return this.checkCondition;
    }

    public void setCheckCondition(ValueNode valueNode) {
        this.checkCondition = valueNode;
    }

    public String getConstraintText() {
        return this.constraintText;
    }

    public int[] getCheckColumnReferences() {
        return this.checkColumnReferences;
    }

    public void setCheckColumnReferences(int[] nArray) {
        this.checkColumnReferences = nArray;
    }

    int getDropBehavior() {
        return this.behavior;
    }

    int getVerifyType() {
        return this.verifyType;
    }

    private UUIDFactory getUUIDFactory() {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory;
    }
}

