/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Trigger {
    public static void doTriggers(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT TRIGGERNAME, SCHEMAID, EVENT, FIRINGTIME, TYPE, TABLEID, REFERENCEDCOLUMNS, TRIGGERDEFINITION, REFERENCINGOLD, REFERENCINGNEW, OLDREFERENCINGNAME, NEWREFERENCINGNAME FROM SYS.SYSTRIGGERS WHERE STATE != 'D'");
        boolean bl = true;
        while (resultSet.next()) {
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            String string2 = dblook.lookupSchemaId(resultSet.getString(2));
            if (dblook.isIgnorableSchema(string2)) continue;
            string = string2 + "." + string;
            String string3 = dblook.lookupTableId(resultSet.getString(6));
            if (!dblook.stringContainsTargetTable(resultSet.getString(8)) && dblook.isExcludedTable(string3)) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_TriggersHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String string4 = DB_Trigger.createTrigger(string, string3, resultSet);
            Logs.writeToNewDDL(string4);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
        resultSet.close();
        statement.close();
    }

    private static String createTrigger(String string, String string2, ResultSet resultSet) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("CREATE TRIGGER ");
        stringBuffer.append(string);
        if (resultSet.getString(4).charAt(0) == 'A') {
            stringBuffer.append(" AFTER ");
        } else {
            stringBuffer.append(" NO CASCADE BEFORE ");
        }
        switch (resultSet.getString(3).charAt(0)) {
            case 'I': {
                stringBuffer.append("INSERT");
                break;
            }
            case 'D': {
                stringBuffer.append("DELETE");
                break;
            }
            case 'U': {
                stringBuffer.append("UPDATE");
                String string3 = resultSet.getString(7);
                if (resultSet.wasNull()) break;
                stringBuffer.append(" OF ");
                stringBuffer.append(dblook.getColumnListFromDescription(resultSet.getString(6), string3));
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected trigger event: " + resultSet.getString(3), (String)null);
            }
        }
        stringBuffer.append(" ON ");
        stringBuffer.append(string2);
        char c = resultSet.getString(5).charAt(0);
        String string4 = resultSet.getString(11);
        String string5 = resultSet.getString(12);
        if (string4 != null || string5 != null) {
            stringBuffer.append(" REFERENCING");
            if (resultSet.getBoolean(9)) {
                stringBuffer.append(" OLD");
                if (c == 'S') {
                    stringBuffer.append("_TABLE AS ");
                } else {
                    stringBuffer.append(" AS ");
                }
                stringBuffer.append(string4);
            }
            if (resultSet.getBoolean(10)) {
                stringBuffer.append(" NEW");
                if (c == 'S') {
                    stringBuffer.append("_TABLE AS ");
                } else {
                    stringBuffer.append(" AS ");
                }
                stringBuffer.append(string5);
            }
        }
        stringBuffer.append(" FOR EACH ");
        if (c == 'S') {
            stringBuffer.append("STATEMENT ");
        } else {
            stringBuffer.append("ROW ");
        }
        stringBuffer.append(dblook.removeNewlines(resultSet.getString(8)));
        return stringBuffer.toString();
    }
}

