/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.muc.Room;
import tigase.muc.cluster.InMemoryMucRepositoryClustered;
import tigase.muc.cluster.MUCComponentClustered;
import tigase.muc.cluster.StrategyIfc;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class DefaultStrategy
implements Room.RoomOccupantListener,
InMemoryMucRepositoryClustered.RoomListener,
StrategyIfc {
    private static final Logger a = Logger.getLogger(DefaultStrategy.class.getCanonicalName());
    private static final String b = "muc-node-shutdown-cmd";
    private static final String c = "muc-occupant-added-cmd";
    private static final String d = "muc-occupant-removed-cmd";
    private static final String e = "muc-packet-forward-cmd";
    private static final String f = "muc-sync-request";
    private static final String g = "muc-sync-response";
    private static final String h = "muc-room-created-cmd";
    private static final String i = "muc-room-destroyed-cmd";
    private static final int j = 1000;
    private CopyOnWriteArrayList<JID> k = new CopyOnWriteArrayList();
    private ClusterControllerIfc l;
    private JID m;
    private MUCComponentClustered n;
    private b o = new b();
    private c p = new c();
    private a q = new a();
    private d r = new d();
    private e s = new e();
    private f t = new f();
    private g u = new g();
    private h v = new h();
    private ConcurrentMap<BareJID, JID> w = new ConcurrentHashMap<BareJID, JID>();
    private ConcurrentMap<BareJID, Set<JID>> x = new ConcurrentHashMap<BareJID, Set<JID>>();
    private InMemoryMucRepositoryClustered y = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(BareJID bareJID, JID jID) {
        Set<Object> set;
        HashSet<JID> hashSet = (HashSet<JID>)this.x.get(bareJID);
        if (hashSet == null && (set = (Set)this.x.putIfAbsent(bareJID, hashSet = new HashSet<JID>())) != null) {
            hashSet = set;
        }
        set = hashSet;
        synchronized (set) {
            return hashSet.add(jID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b(BareJID bareJID, JID jID) {
        Set set = (Set)this.x.get(bareJID);
        if (set == null) {
            return false;
        }
        Set set2 = set;
        synchronized (set2) {
            return set.remove(jID);
        }
    }

    @Override
    public List<JID> getAllNodes() {
        return this.k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeConnected(JID nodeJid) {
        boolean bl = false;
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.k;
        synchronized (copyOnWriteArrayList) {
            if (this.k.addIfAbsent(nodeJid)) {
                bl = true;
                this.a(this.k);
            }
        }
        if (bl && !this.m.equals((Object)nodeJid)) {
            this.a(nodeJid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDisconnected(JID nodeJid) {
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.k;
        synchronized (copyOnWriteArrayList) {
            this.k.remove(nodeJid);
        }
        int n = this.k.indexOf(this.m);
        Iterator iterator = this.w.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!nodeJid.equals(entry.getValue())) continue;
            iterator.remove();
            BareJID bareJID = (BareJID)entry.getKey();
            Set set = (Set)this.x.remove(bareJID);
            if (bareJID.hashCode() % this.k.size() != n || set == null) continue;
            Set set2 = set;
            synchronized (set2) {
                for (JID jID : set) {
                    this.c(bareJID, jID);
                }
            }
        }
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.l != null) {
            this.l.removeCommandListener((CommandListener)this.u);
            this.l.removeCommandListener((CommandListener)this.v);
            this.l.removeCommandListener((CommandListener)this.o);
            this.l.removeCommandListener((CommandListener)this.p);
            this.l.removeCommandListener((CommandListener)this.r);
            this.l.removeCommandListener((CommandListener)this.s);
            this.l.removeCommandListener((CommandListener)this.t);
            this.l.removeCommandListener((CommandListener)this.q);
        }
        this.l = cl_controller;
        this.l.setCommandListener((CommandListener)this.u);
        this.l.setCommandListener((CommandListener)this.v);
        this.l.setCommandListener((CommandListener)this.o);
        this.l.setCommandListener((CommandListener)this.p);
        this.l.setCommandListener((CommandListener)this.r);
        this.l.setCommandListener((CommandListener)this.s);
        this.l.setCommandListener((CommandListener)this.t);
        this.l.setCommandListener((CommandListener)this.q);
    }

    @Override
    public void setMucComponentClustered(MUCComponentClustered mucComponent) {
        this.setLocalNodeJid(JID.jidInstance((BareJID)mucComponent.getDefHostName()));
        this.n = mucComponent;
    }

    @Override
    public boolean processPacket(Packet packet) {
        BareJID bareJID = packet.getStanzaTo().getBareJID();
        JID jID = this.getNodeForRoom(bareJID);
        if (this.m.equals((Object)jID)) {
            return false;
        }
        if (a.isLoggable(Level.FINER)) {
            a.log(Level.FINER, "room = {0}, forwarding packet to node = {1}", new Object[]{bareJID, jID});
        }
        this.l.sendToNodes(e, packet.getElement(), this.m, null, new JID[]{jID});
        return true;
    }

    @Override
    public JID getNodeForRoom(BareJID roomJid) {
        JID jID = (JID)this.w.get(roomJid);
        if (jID == null) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, not created on any node", roomJid);
            }
            int n = roomJid.hashCode();
            jID = this.k.get(Math.abs(n) % this.k.size());
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "room = {0}, selected node = {1} to handle this room", new Object[]{roomJid, jID});
        }
        return jID;
    }

    @Override
    public void setMucRepository(InMemoryMucRepositoryClustered mucRepository) {
        this.y = mucRepository;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        List<JID> list = this.getAllNodes();
        list.remove(this.m);
        this.l.sendToNodes(b, this.m, list.toArray(new JID[list.size()]));
    }

    protected void setLocalNodeJid(JID jid) {
        this.m = jid;
        this.nodeConnected(this.m);
    }

    private void c(BareJID bareJID, JID jID) {
        try {
            Element element = new Element("presence", new String[]{"xmlns", "from", "to", "type"}, new String[]{"jabber:client", bareJID.toString(), jID.toString(), "unavailable"});
            Element element2 = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            element.addChild((XMLNodeIfc)element2);
            Element element3 = new Element("item", new String[]{"role"}, new String[]{"none"});
            element2.addChild((XMLNodeIfc)element3);
            element3.addChild((XMLNodeIfc)new Element("reason", "MUC component is disconnected."));
            element2.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{"307"}));
            this.n.addOutPacket(Packet.packetInstance((Element)element));
        }
        catch (TigaseStringprepException tigaseStringprepException) {
            a.log(Level.FINE, "Problem on throwing out occupant {0} on node disconnection", new Object[]{jID});
        }
    }

    private void a(List<JID> list) {
        Object[] objectArray = list.toArray(new JID[list.size()]);
        Arrays.sort(objectArray);
        list.clear();
        list.addAll(Arrays.asList(objectArray));
    }

    @Override
    public void onRoomCreated(Room room) {
        this.w.put(room.getRoomJID(), this.m);
        List<JID> list = this.getAllNodes();
        list.remove(this.m);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is created", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.l.sendToNodes(h, hashMap, this.m, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomDestroyed(Room room) {
        this.w.remove(room.getRoomJID());
        Set set = (Set)this.x.remove(room.getRoomJID());
        List<JID> list = this.getAllNodes();
        list.remove(this.m);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is destroyed", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.l.sendToNodes(i, hashMap, this.m, list.toArray(new JID[list.size()]));
    }

    public void onOccupantAdded(Room room, JID occupantJid) {
        if (this.a(room.getRoomJID(), occupantJid)) {
            List<JID> list = this.getAllNodes();
            list.remove(this.m);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("room", room.getRoomJID().toString());
            hashMap.put("occupant-jid", occupantJid.toString());
            if (a.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder(100);
                for (JID jID : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(jID.toString());
                }
                a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that occupant {2} joined room {3}", new Object[]{room.getRoomJID(), stringBuilder, occupantJid, room.getRoomJID()});
            }
            this.l.sendToNodes(c, hashMap, this.m, list.toArray(new JID[list.size()]));
        }
    }

    public void onOccupantRemoved(Room room, JID occupantJid) {
        if (this.b(room.getRoomJID(), occupantJid)) {
            List<JID> list = this.getAllNodes();
            list.remove(this.m);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("room", room.getRoomJID().toString());
            hashMap.put("occupant-jid", occupantJid.toString());
            if (a.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder(100);
                for (JID jID : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(jID.toString());
                }
                a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that occupant {2} left room {3}", new Object[]{room.getRoomJID(), stringBuilder, occupantJid, room.getRoomJID()});
            }
            this.l.sendToNodes(d, hashMap, this.m, list.toArray(new JID[list.size()]));
        }
    }

    private void a(JID jID) {
        this.l.sendToNodes(f, this.m, new JID[]{jID});
    }

    private class f
    extends CommandListenerAbstract {
        public f() {
            super(DefaultStrategy.g);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (packets != null && !packets.isEmpty()) {
                for (Element element : packets) {
                    List list;
                    if (element.getName() != "room") continue;
                    BareJID bareJID = BareJID.bareJIDInstanceNS((String)element.getAttributeStaticStr("jid"));
                    JID jID = DefaultStrategy.this.w.put(bareJID, fromNode);
                    if (jID != null && !fromNode.equals((Object)jID)) {
                        a.log(Level.SEVERE, "received info about a room {0} on {1} but we had info about this room on node {2}", new Object[]{bareJID, fromNode, jID});
                    }
                    if ((list = element.getChildren()) == null || list.isEmpty()) continue;
                    for (Element element2 : list) {
                        JID jID2 = JID.jidInstanceNS((String)element2.getCData());
                        DefaultStrategy.this.a(bareJID, jID2);
                    }
                }
            }
        }
    }

    private class e
    extends CommandListenerAbstract {
        public e() {
            super(DefaultStrategy.f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            LinkedList<Element> linkedList = new LinkedList<Element>();
            for (Map.Entry entry : DefaultStrategy.this.w.entrySet()) {
                if (!DefaultStrategy.this.m.equals(entry.getValue())) continue;
                Element element = new Element("room", new String[]{"jid"}, new String[]{((BareJID)entry.getKey()).toString()});
                Set set = (Set)DefaultStrategy.this.x.get(entry.getKey());
                if (set != null && !set.isEmpty()) {
                    Set set2 = set;
                    synchronized (set2) {
                        for (JID jID : set) {
                            element.addChild((XMLNodeIfc)new Element("occupant", jID.toString()));
                        }
                    }
                }
                linkedList.add(element);
                if (linkedList.size() <= 1000) continue;
                DefaultStrategy.this.l.sendToNodes(DefaultStrategy.g, packets, DefaultStrategy.this.m, null, new JID[]{fromNode});
                linkedList = new LinkedList();
            }
            if (!linkedList.isEmpty()) {
                DefaultStrategy.this.l.sendToNodes(DefaultStrategy.g, packets, DefaultStrategy.this.m, null, new JID[]{fromNode});
            }
        }
    }

    private class d
    extends CommandListenerAbstract {
        public d() {
            super(DefaultStrategy.e);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (packets != null && !packets.isEmpty()) {
                for (Element element : packets) {
                    try {
                        Packet packet = Packet.packetInstance((Element)element);
                        DefaultStrategy.this.n.processPacket(packet);
                        if (!a.isLoggable(Level.FINEST)) continue;
                        a.log(Level.FINEST, "received packet {0} forwarded from node {1}", new Object[]{packet, fromNode});
                    }
                    catch (TigaseStringprepException tigaseStringprepException) {
                        a.warning("Addressing problem, stringprep failed for packet: " + element);
                    }
                }
            }
        }
    }

    private class c
    extends CommandListenerAbstract {
        public c() {
            super(DefaultStrategy.d);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("occupant-jid"));
            DefaultStrategy.this.b(bareJID, jID);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that occupant {1} left room {2} at node {3}", new Object[]{bareJID, jID, bareJID, fromNode});
            }
        }
    }

    private class b
    extends CommandListenerAbstract {
        public b() {
            super(DefaultStrategy.c);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("occupant-jid"));
            DefaultStrategy.this.a(bareJID, jID);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that occupant {1} joined room {2} at node {3}", new Object[]{bareJID, jID, bareJID, fromNode});
            }
        }
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(DefaultStrategy.b);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            Iterator iterator = DefaultStrategy.this.w.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!fromNode.equals(entry.getValue())) continue;
                iterator.remove();
                DefaultStrategy.this.x.remove(entry.getKey());
            }
        }
    }

    private class h
    extends CommandListenerAbstract {
        public h() {
            super(DefaultStrategy.i);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            DefaultStrategy.this.w.remove(bareJID, fromNode);
            DefaultStrategy.this.x.remove(bareJID);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was destroyed at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }

    private class g
    extends CommandListenerAbstract {
        public g() {
            super(DefaultStrategy.h);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            DefaultStrategy.this.w.put(bareJID, fromNode);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was created at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }
}

