/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;

public class RebuildDatabaseCommand
implements AdHocCommand {
    private final PubSubConfig config;
    private final PubSubDAO dao;

    public RebuildDatabaseCommand(PubSubConfig config, PubSubDAO directPubSubRepository) {
        this.dao = directPubSubRepository;
        this.config = config;
    }

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (!this.config.isAdmin(request.getSender())) {
                throw new AdHocCommandException(Authorization.FORBIDDEN);
            }
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("result", "Rebuild nodes tree", "To rebuild tree of nodes please check checkbox.");
                form.addField(Field.fieldBoolean((String)"tigase-pubsub#rebuild", (Boolean)Boolean.FALSE, (String)"Rebuild nodes tree?"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    Boolean rebuild = form.getAsBoolean("tigase-pubsub#rebuild");
                    if (rebuild != null && rebuild.booleanValue()) {
                        this.startRebuild(request.getIq().getStanzaTo().getBareJID());
                        Form f = new Form("result", "Info", "Nodes tree has been rebuild");
                        response.getElements().add(f.getElement());
                    } else {
                        Form f = new Form("result", "Info", "Rebuild cancelled.");
                        response.getElements().add(f.getElement());
                    }
                }
                response.completeSession();
            }
        }
        catch (AdHocCommandException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Rebuild database";
    }

    @Override
    public String getNode() {
        return "rebuild-db";
    }

    private void startRebuild(BareJID serviceJid) throws RepositoryException {
        String nodeName2;
        String[] allNodesId = this.dao.getAllNodesList(serviceJid);
        HashSet<String> rootCollection = new HashSet<String>();
        HashMap<String, AbstractNodeConfig> nodeConfigs = new HashMap<String, AbstractNodeConfig>();
        for (String nodeName2 : allNodesId) {
            long nodeId = this.dao.getNodeId(serviceJid, nodeName2);
            String nodeConfigData = this.dao.getNodeConfig(serviceJid, nodeId);
            AbstractNodeConfig nodeConfig = this.dao.parseConfig(nodeName2, nodeConfigData);
            nodeConfigs.put(nodeName2, nodeConfig);
            if (!(nodeConfig instanceof CollectionNodeConfig)) continue;
            CollectionNodeConfig collectionNodeConfig = (CollectionNodeConfig)nodeConfig;
            collectionNodeConfig.setChildren(null);
        }
        for (Map.Entry entry : nodeConfigs.entrySet()) {
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)entry.getValue();
            nodeName2 = (String)entry.getKey();
            String collectionNodeName = nodeConfig.getCollection();
            if (collectionNodeName == null || collectionNodeName.equals("")) {
                nodeConfig.setCollection("");
                rootCollection.add(nodeName2);
                continue;
            }
            AbstractNodeConfig potentialParent = (AbstractNodeConfig)nodeConfigs.get(collectionNodeName);
            if (potentialParent != null && potentialParent instanceof CollectionNodeConfig) {
                CollectionNodeConfig collectionConfig = (CollectionNodeConfig)potentialParent;
                collectionConfig.addChildren(nodeName2);
                continue;
            }
            nodeConfig.setCollection("");
            rootCollection.add(nodeName2);
        }
        for (Map.Entry entry : nodeConfigs.entrySet()) {
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)entry.getValue();
            nodeName2 = (String)entry.getKey();
            long nodeId = this.dao.getNodeId(serviceJid, nodeName2);
            long collectionId = this.dao.getNodeId(serviceJid, nodeConfig.getCollection());
            this.dao.updateNodeConfig(serviceJid, nodeId, nodeConfig.getFormElement().toString(), collectionId == 0L ? null : Long.valueOf(collectionId));
        }
        this.dao.removeAllFromRootCollection(serviceJid);
        for (String nodeName3 : rootCollection) {
            this.dao.addToRootCollection(serviceJid, nodeName3);
        }
    }
}

