/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml.db;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.db.DBElement;
import tigase.xml.db.DBElementFactory;
import tigase.xml.db.NodeExistsException;
import tigase.xml.db.NodeNotFoundException;
import tigase.xml.db.XMLDBException;

public class XMLDB {
    private static Logger log = Logger.getLogger("tigase.xml.db.XMLDB");
    private String dbFile = "xml_db.xml";
    private String node1_name = "node";
    private DBElement root = null;
    private String root_name = "root";
    private boolean node1s_modified = true;
    private DBElement[] node1s = new DBElement[0];
    private Lock lock = new ReentrantLock();
    private final DBSaver db_saver = new DBSaver();
    private DBElementComparator comparator = new DBElementComparator();
    private DBElement tmp_node1 = null;

    private XMLDB() {
        Thread thrd = new Thread(this.db_saver);
        thrd.setName("XMLDBSaver");
        thrd.setDaemon(true);
        thrd.start();
    }

    public XMLDB(String db_file) throws IOException, XMLDBException {
        Thread thrd = new Thread(this.db_saver);
        thrd.setName("XMLDBSaver");
        thrd.setDaemon(true);
        thrd.start();
        this.dbFile = db_file;
        this.tmp_node1 = new DBElement(this.node1_name);
        this.loadDB();
    }

    public static XMLDB createDB(String db_file, String root_name, String node1_name) {
        XMLDB xmldb = new XMLDB();
        xmldb.setupNewDB(db_file, root_name, node1_name);
        return xmldb;
    }

    public String getDBFileName() {
        return this.dbFile;
    }

    protected void setupNewDB(String db_file, String root_name, String node1_name) {
        log.info("Create empty DB.");
        this.dbFile = db_file;
        if (root_name != null) {
            this.root_name = root_name;
        }
        if (node1_name != null) {
            this.node1_name = node1_name;
        }
        this.tmp_node1 = new DBElement(node1_name);
        this.root = new DBElement(this.root_name);
    }

    protected void loadDB() throws IOException, XMLDBException {
        InputStreamReader file = new InputStreamReader((InputStream)new FileInputStream(this.dbFile), "UTF-8");
        char[] buff = new char[16384];
        SimpleParser parser = new SimpleParser();
        DomBuilderHandler domHandler = new DomBuilderHandler(DBElementFactory.getFactory());
        int result = -1;
        while ((result = file.read(buff)) != -1) {
            parser.parse(domHandler, buff, 0, result);
        }
        file.close();
        this.root = (DBElement)domHandler.getParsedElements().poll();
        if (this.root == null) {
            throw new XMLDBException("Invalid XML DB File");
        }
        this.root_name = this.root.getName();
        List<Element> children = this.root.getChildren();
        if (children != null && children.size() > 0) {
            this.node1_name = children.get(0).getName();
        }
        log.finest(this.root.formatedString(0, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDB() {
        DBSaver dBSaver = this.db_saver;
        synchronized (dBSaver) {
            this.db_saver.notifyAll();
        }
    }

    public final long getAllNode1sCount() {
        return this.root.getChildren().size();
    }

    public final List<String> getAllNode1s() {
        List<Element> children = this.root.getChildren();
        if (children != null) {
            ArrayList<String> results = new ArrayList<String>(children.size());
            for (Element child : children) {
                results.add(child.getAttributeStaticStr("name"));
            }
            return results;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBElement findNode1(String node1_id) {
        DBElement result = null;
        this.lock.lock();
        try {
            this.tmp_node1.setAttribute("name", node1_id);
            int idx = Arrays.binarySearch(this.node1s, this.tmp_node1, this.comparator);
            DBElement dbel = null;
            if (idx >= 0) {
                dbel = this.node1s[idx];
            }
            if (this.node1s_modified && (idx < 0 || dbel != null && dbel.removed)) {
                List<Element> children = this.root.getChildren();
                if (children != null) {
                    this.node1s = children.toArray(new DBElement[children.size()]);
                    Arrays.sort(this.node1s, this.comparator);
                    idx = Arrays.binarySearch(this.node1s, this.tmp_node1, this.comparator);
                }
                this.node1s_modified = false;
            }
            if (idx >= 0) {
                result = this.node1s[idx];
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    protected final DBElement getNode1(String node1_id) throws NodeNotFoundException {
        DBElement result = this.findNode1(node1_id);
        if (result != null) {
            return result;
        }
        throw new NodeNotFoundException("Node1: " + node1_id + " has not been found in db.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode1(String node1_id) throws NodeExistsException {
        this.lock.lock();
        try {
            try {
                this.getNode1(node1_id);
                throw new NodeExistsException("Node1: " + node1_id + " already exists.");
            }
            catch (NodeNotFoundException e) {
                this.node1s_modified = true;
                DBElement newNode1 = new DBElement(this.node1_name, "name", node1_id);
                newNode1.addChild(new DBElement("map"));
                this.root.addChild(newNode1);
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode1(String node1_id) throws NodeNotFoundException {
        this.lock.lock();
        try {
            DBElement dbel = this.getNode1(node1_id);
            this.node1s_modified = true;
            this.root.removeChild(dbel);
            dbel.removed = true;
        }
        finally {
            this.lock.unlock();
        }
        this.saveDB();
    }

    protected final DBElement getNode(String node1_id, String subnode, boolean auto_create) throws NodeNotFoundException {
        DBElement node1 = this.getNode1(node1_id);
        if (subnode != null) {
            DBElement node = node1.getSubnodePath(subnode);
            if (node == null && auto_create) {
                node = node1.buildNodesTree(subnode);
            }
            return node;
        }
        return node1;
    }

    public void setData(String node1_id, String subnode, String key, Object value) throws NodeNotFoundException {
        this.getNode(node1_id, subnode, true).setEntry(key, value);
        this.saveDB();
    }

    public void setData(String node1_id, String key, Object value) throws NodeNotFoundException {
        this.setData(node1_id, null, key, value);
    }

    public String[] getDataList(String node1_id, String subnode, String key) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        return node != null ? node.getEntryStringArrValue(key, null) : null;
    }

    public int[] getDataIntList(String node1_id, String subnode, String key) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        return node != null ? node.getEntryIntArrValue(key, null) : null;
    }

    public double[] getDataDoubleList(String node1_id, String subnode, String key) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        return node != null ? node.getEntryDoubleArrValue(key, null) : null;
    }

    public Object getData(String node1_id, String subnode, String key, Object def) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        return node != null ? node.getEntryValue(key, def) : null;
    }

    public int getDataInt(String node1_id, String subnode, String key, int def) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        return node != null ? Integer.valueOf(node.getEntryIntValue(key, def)) : null;
    }

    public double getDataDouble(String node1_id, String subnode, String key, double def) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        return node != null ? Double.valueOf(node.getEntryDoubleValue(key, def)) : null;
    }

    public Object getData(String node1_id, String subnode, String key) throws NodeNotFoundException {
        return this.getData(node1_id, subnode, key, null);
    }

    public Object getData(String node1_id, String key) throws NodeNotFoundException {
        return this.getData(node1_id, null, key, null);
    }

    public String[] getSubnodes(String node1_id, String subnode) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        return node != null ? node.getSubnodes() : null;
    }

    public String[] getSubnodes(String node1_id) throws NodeNotFoundException {
        return this.getSubnodes(node1_id, null);
    }

    public String[] getKeys(String node1_id, String subnode) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        return node != null ? node.getEntryKeys() : null;
    }

    public String[] getKeys(String node1_id) throws NodeNotFoundException {
        return this.getKeys(node1_id, null);
    }

    public void removeData(String node1_id, String subnode, String key) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        if (node != null) {
            node.removeEntry(key);
            this.saveDB();
        }
    }

    public void removeData(String node1_id, String key) throws NodeNotFoundException {
        this.removeData(node1_id, null, key);
    }

    public void removeSubnode(String node1_id, String subnode) throws NodeNotFoundException {
        DBElement node = this.getNode(node1_id, subnode, false);
        if (node != null) {
            node.removeNode(subnode);
            this.saveDB();
        }
    }

    public void sync() throws IOException {
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws IOException {
        this.lock.lock();
        try {
            String buffer = this.root.formatedString(0, 1);
            OutputStreamWriter file = new OutputStreamWriter((OutputStream)new FileOutputStream(this.dbFile, false), "UTF-8");
            file.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            file.write(buffer + "\n");
            file.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    class DBSaver
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    DBSaver dBSaver = XMLDB.this.db_saver;
                    synchronized (dBSaver) {
                        XMLDB.this.db_saver.wait();
                    }
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    XMLDB.this.sync();
                    continue;
                }
                catch (Exception e) {
                    log.severe("Can't save repository file: " + e);
                    continue;
                }
                break;
            }
        }
    }

    private static class DBElementComparator
    implements Comparator<DBElement>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DBElementComparator() {
        }

        @Override
        public int compare(DBElement el1, DBElement el2) {
            String name1 = el1.getAttributeStaticStr("name");
            String name2 = el2.getAttributeStaticStr("name");
            return name1.compareTo(name2);
        }
    }
}

