/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository.inmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Affiliation;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.MucDAO;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class InMemoryMucRepository
implements IMucRepository {
    private final Map<BareJID, InternalRoom> allRooms = new ConcurrentHashMap<BareJID, InternalRoom>();
    private final MucDAO dao;
    private RoomConfig defaultConfig;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private MucConfig mucConfig;
    private final RoomConfig.RoomConfigListener roomConfigListener;
    private final Room.RoomListener roomListener;
    private final Map<BareJID, Room> rooms = new ConcurrentHashMap<BareJID, Room>();

    public InMemoryMucRepository(MucConfig mucConfig, final MucDAO dao) throws RepositoryException {
        this.dao = dao;
        this.mucConfig = mucConfig;
        ArrayList<BareJID> roomJids = dao.getRoomsJIDList();
        if (roomJids != null) {
            for (BareJID jid : roomJids) {
                this.allRooms.put(jid, new InternalRoom());
            }
        }
        this.roomListener = new Room.RoomListener(){

            @Override
            public void onChangeSubject(Room room, String nick, String newSubject, Date changeDate) {
                try {
                    if (room.getConfig().isPersistentRoom()) {
                        dao.setSubject(room.getRoomJID(), newSubject, nick, changeDate);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void onSetAffiliation(Room room, BareJID jid, Affiliation newAffiliation) {
                try {
                    if (room.getConfig().isPersistentRoom()) {
                        dao.setAffiliation(room.getRoomJID(), jid, newAffiliation);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.roomConfigListener = new RoomConfig.RoomConfigListener(){

            @Override
            public void onConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
                try {
                    InternalRoom ir;
                    if (modifiedVars.contains("muc#roomconfig_publicroom") && (ir = (InternalRoom)InMemoryMucRepository.this.allRooms.get(roomConfig.getRoomJID())) != null) {
                        ir.listPublic = roomConfig.isRoomconfigPublicroom();
                    }
                    if (modifiedVars.contains("muc#roomconfig_persistentroom")) {
                        if (roomConfig.isPersistentRoom()) {
                            Room room = InMemoryMucRepository.this.getRoom(roomConfig.getRoomJID());
                            dao.createRoom(room);
                        } else {
                            dao.destroyRoom(roomConfig.getRoomJID());
                        }
                    } else if (roomConfig.isPersistentRoom()) {
                        dao.updateRoomConfig(roomConfig);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public Room createNewRoom(BareJID roomJID, JID senderJid) throws RepositoryException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating new room '" + roomJID + "'");
        }
        RoomConfig rc = new RoomConfig(roomJID, this.mucConfig.isPublicLoggingEnabled());
        rc.copyFrom(this.getDefaultRoomConfig(), false);
        Room room = new Room(rc, new Date(), senderJid.getBareJID());
        room.getConfig().addListener(this.roomConfigListener);
        room.addListener(this.roomListener);
        this.rooms.put(roomJID, room);
        this.allRooms.put(roomJID, new InternalRoom());
        return room;
    }

    @Override
    public void destroyRoom(Room room) throws RepositoryException {
        BareJID roomJID = room.getRoomJID();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Destroying room '" + roomJID);
        }
        this.rooms.remove(roomJID);
        this.allRooms.remove(roomJID);
        this.dao.destroyRoom(roomJID);
    }

    @Override
    public Map<BareJID, Room> getActiveRooms() {
        return Collections.unmodifiableMap(this.rooms);
    }

    @Override
    public RoomConfig getDefaultRoomConfig() throws RepositoryException {
        if (this.defaultConfig == null) {
            this.defaultConfig = new RoomConfig(null, this.mucConfig.isPublicLoggingEnabled());
            try {
                this.defaultConfig.read(this.dao.getRepository(), this.mucConfig, "rooms/" + null + "/config");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.defaultConfig;
    }

    @Override
    public BareJID[] getPublicVisibleRoomsIdList() throws RepositoryException {
        ArrayList<BareJID> result = new ArrayList<BareJID>();
        for (Map.Entry<BareJID, InternalRoom> entry : this.allRooms.entrySet()) {
            if (!entry.getValue().listPublic) continue;
            result.add(entry.getKey());
        }
        return result.toArray(new BareJID[0]);
    }

    @Override
    public Room getRoom(BareJID roomJID) throws RepositoryException, MUCException, TigaseStringprepException {
        Room room = this.rooms.get(roomJID);
        if (room == null && (room = this.dao.readRoom(roomJID)) != null) {
            room.getConfig().addListener(this.roomConfigListener);
            room.addListener(this.roomListener);
            this.rooms.put(roomJID, room);
        }
        return room;
    }

    @Override
    public String getRoomName(String jid) throws RepositoryException {
        Room r = this.rooms.get(BareJID.bareJIDInstanceNS((String)jid));
        if (r != null) {
            return r.getConfig().getRoomName();
        }
        return this.dao.getRoomName(jid);
    }

    @Override
    public boolean isRoomIdExists(String newRoomName) {
        return this.allRooms.containsKey(newRoomName);
    }

    @Override
    public void leaveRoom(Room room) {
        BareJID roomJID = room.getRoomJID();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Removing room '" + roomJID + "' from memory");
        }
        this.rooms.remove(roomJID);
        if (!room.getConfig().isPersistentRoom()) {
            this.allRooms.remove(roomJID);
        }
    }

    @Override
    public void updateDefaultRoomConfig(RoomConfig config) throws RepositoryException {
        RoomConfig org = this.getDefaultRoomConfig();
        org.copyFrom(config);
        this.dao.updateRoomConfig(this.defaultConfig);
    }

    private class InternalRoom {
        boolean listPublic = true;

        private InternalRoom() {
        }
    }
}

