/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.HtmlAdminPage;
import com.sun.jdmk.comm.HtmlArrayPage;
import com.sun.jdmk.comm.HtmlInvokePage;
import com.sun.jdmk.comm.HtmlMasterPage;
import com.sun.jdmk.comm.HtmlObjectPage;
import com.sun.jdmk.comm.HtmlPage;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class HtmlRequestHandler
extends ClientHandler {
    private Socket sockClient = null;
    private String bgPageColor = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public HtmlRequestHandler(Socket s, HtmlAdaptorServer server, MBeanServer f, ObjectName n, int id) {
        super(server, id, f, n);
        this.sockClient = s;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doRun() {
        if (this.logger.finerOn()) {
            this.logger.finer("doRun", "Start Html request handler");
        }
        try {
            request = new HttpRequest(new HttpBody());
            loopAgain = true;
            while (loopAgain) {
                response = null;
                try {
                    request.readFrom(this.sockClient.getInputStream());
                    response = this.processRequest(request);
                }
                catch (MalformedHttpException x) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "Malformed HTTP request rejected. [Exception=" + x + "]");
                    }
                    response = this.makeErrorResponse(400);
                }
                response.writeTo(this.sockClient.getOutputStream());
                if (!request.hasKeepAliveFlag()) ** GOTO lbl-1000
                if (response.statusCode == 200 && !this.interruptCalled) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                loopAgain = v0;
            }
        }
        catch (InterruptedIOException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("doRun", "Request handler interrupted");
            }
        }
        catch (EOFException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("doRun", "Connection closed by peer");
            }
        }
        catch (SocketException x) {
            if (x.getMessage().equals("Interrupted system call")) {
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Request handler interrupted");
                }
            } else if (this.logger.finestOn()) {
                this.logger.finest("doRun", "I/O exception. [Exception=" + x + "]");
            }
        }
        catch (IOException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("doRun", "I/O exception. [Exception=" + x + "]");
            }
        }
        finally {
            block39: {
                try {
                    this.sockClient.close();
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "Socket is now closed");
                    }
                }
                catch (IOException e) {
                    if (!this.logger.finestOn()) break block39;
                    this.logger.finest("doRun", "Socket closed with [Exception=" + e + "]");
                }
            }
        }
    }

    protected HttpResponse processRequest(HttpRequest request) throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("processRequest", "Process the Html request");
        }
        HttpResponse response = null;
        if (!this.authenticateRequest(request)) {
            if (this.logger.finerOn()) {
                this.logger.finer("processRequest", "Authentication failed");
            }
            response = this.makeErrorResponse(401);
        } else if (request.method == 1) {
            response = this.processGetRequest(request);
        } else {
            if (this.logger.finerOn()) {
                this.logger.finer("processRequest", "Bad request: request not supported");
            }
            response = this.makeErrorResponse(400);
        }
        response.setHeader(3, request.getHeader(3));
        return response;
    }

    protected boolean authenticateRequest(HttpRequest request) throws IOException {
        HtmlAdaptorServer server;
        if (this.logger.finerOn()) {
            this.logger.finer("authenticateRequest", "Authenticate the HTML request, using the 'Basic Authentication Scheme'");
        }
        if (!(server = (HtmlAdaptorServer)this.adaptorServer).isAuthenticationOn()) {
            return true;
        }
        String authorization = request.getHeader(5);
        if (authorization == null || !authorization.startsWith("Basic ")) {
            return false;
        }
        String encoding = authorization.substring(6);
        byte[] decoding = new BASE64Decoder().decodeBuffer(encoding);
        String response = new String(decoding);
        return server.checkChallengeResponse(response);
    }

    protected HttpResponse processGetRequest(HttpRequest request) throws IOException {
        String resultBody;
        int resultCode;
        block45: {
            HtmlPage page;
            String objNameStr;
            HtmlAdaptorServer server;
            String URIPath;
            block44: {
                URIPath = request.getURIPath();
                resultCode = 200;
                resultBody = null;
                server = (HtmlAdaptorServer)this.adaptorServer;
                Object response = null;
                if (this.logger.finerOn()) {
                    this.logger.finer("processGetRequest", "Process a GET request = " + URIPath);
                }
                if (server.getParser() == null) break block44;
                Object[] param = new String[]{URIPath};
                String[] sign = new String[]{"java.lang.String"};
                try {
                    resultBody = (String)this.mbs.invoke(server.getParser(), "parseRequest", param, sign);
                }
                catch (InstanceNotFoundException e) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "Invalid user's parser = " + e);
                    }
                    String errMsg = "Instance Not Found<P>Invalid user's parser: " + server.getParser().toString() + " is unknown";
                    server.resetParser();
                    return this.makeErrorResponse(459, errMsg);
                }
                catch (MBeanException e) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "Parser exception = " + e.getTargetException());
                    }
                    String errMsg = "MBean Failure<P>" + server.getParser().toString() + " throws <BR>" + e.getTargetException();
                    server.resetParser();
                    return this.makeErrorResponse(472, errMsg);
                }
                catch (ReflectionException e) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "MBeanServer reflection exception = " + e.getTargetException());
                    }
                    String errMsg = "Reflection<P>MBeanServer throws:<BR>" + e.getTargetException() + "<BR> when reflecting: " + server.getParser().toString();
                    server.resetParser();
                    return this.makeErrorResponse(470, errMsg);
                }
                if (resultBody != null) break block45;
            }
            if (URIPath.startsWith("/Request/")) {
                String arg = URIPath.substring(9);
                if (arg.equals("getDomain")) {
                    resultBody = this.mbs.getDefaultDomain() + ":";
                } else {
                    resultCode = 400;
                }
            } else if (URIPath.startsWith("/ViewObjectRes")) {
                objNameStr = URIPath.substring("/ViewObjectRes".length());
                page = new HtmlObjectPage(this.mbs, true, true, server);
                ((HtmlObjectPage)page).buildPage(objNameStr);
                resultBody = page.getPage();
            } else if (URIPath.startsWith("/AutoRefresh")) {
                objNameStr = URIPath.substring("/AutoRefresh".length());
                page = new HtmlObjectPage(this.mbs, true, true, server);
                ((HtmlObjectPage)page).buildMeta(objNameStr);
                ((HtmlObjectPage)page).buildPage(objNameStr.substring(0, objNameStr.indexOf("?period=")));
                resultBody = page.getPage();
            } else if (URIPath.startsWith("/ViewProperty")) {
                objNameStr = URIPath.substring("/ViewProperty".length());
                page = new HtmlArrayPage(this.mbs, true, true, server);
                ((HtmlArrayPage)page).buildPage(objNameStr);
                resultBody = page.getPage();
            } else if (URIPath.startsWith("/SetForm")) {
                String objNameStr2 = URIPath.substring("/SetForm".length());
                int index = objNameStr2.indexOf(47, 1);
                int query = objNameStr2.indexOf(63);
                if (index < 0 || query < 0) {
                    resultCode = 400;
                } else {
                    String setReqStr = objNameStr2.substring(query);
                    objNameStr2 = objNameStr2.substring(0, query);
                    HtmlObjectPage page2 = new HtmlObjectPage(this.mbs, true, true, server);
                    if (this.logger.finerOn()) {
                        this.logger.finer("processGetRequest", "SetForm for [objName=" + objNameStr2 + " ,request=" + setReqStr + "]");
                    }
                    if (!page2.setObjectValue(objNameStr2, setReqStr)) {
                        resultBody = page2.getPage();
                    } else {
                        page2.buildPage(objNameStr2);
                        resultBody = page2.getPage();
                    }
                }
            } else if (URIPath.startsWith("/Admin")) {
                objNameStr = URIPath.substring("/Admin".length());
                objNameStr = objNameStr.trim();
                page = new HtmlAdminPage(this.mbs, true, true);
                ((HtmlAdminPage)page).buildPage(objNameStr);
                resultBody = page.getPage();
            } else if (URIPath.startsWith("/InvokeAction")) {
                objNameStr = URIPath.substring("/InvokeAction".length());
                objNameStr = objNameStr.trim();
                page = new HtmlInvokePage(this.mbs, true, true);
                ((HtmlInvokePage)page).buildPage(objNameStr);
                resultBody = page.getPage();
            } else if (URIPath.equals("/") || URIPath.startsWith("/Filter")) {
                HtmlMasterPage page3 = new HtmlMasterPage(this.mbs, true, true);
                page3.buildPage(URIPath);
                resultBody = page3.getPage();
            } else {
                resultCode = 400;
            }
            if (server.getParser() != null) {
                String errMsg;
                Object[] param = new String[]{resultBody};
                String[] sign = new String[]{"java.lang.String"};
                try {
                    resultBody = (String)this.mbs.invoke(server.getParser(), "parsePage", param, sign);
                }
                catch (InstanceNotFoundException e) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "Invalid user's parser [" + e + "]");
                    }
                    errMsg = "Instance Not Found<P>Invalid user's parser: " + server.getParser().toString() + " is unknown";
                    server.resetParser();
                    return this.makeErrorResponse(459, errMsg);
                }
                catch (MBeanException e) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "Parser exception = " + e.getTargetException());
                    }
                    errMsg = "MBean Failure<P>" + server.getParser().toString() + " throws <BR>" + e.getTargetException();
                    server.resetParser();
                    return this.makeErrorResponse(472, errMsg);
                }
                catch (ReflectionException e) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "MBeanServer reflection exception = " + e.getTargetException());
                    }
                    errMsg = "Reflection<P>MBeanServer throws:<BR>" + e.getTargetException() + "<BR> when reflecting: " + server.getParser().toString();
                    server.resetParser();
                    return this.makeErrorResponse(470, errMsg);
                }
            }
        }
        if (resultBody != null && resultCode == 200) {
            return this.makeOkResponse(resultBody);
        }
        if (this.logger.finestOn()) {
            this.logger.finest("processGetRequest", "Bad request: request not supported or HTML page empty");
        }
        return this.makeErrorResponse(400);
    }

    protected HttpResponse makeErrorResponse(int statusCode) {
        return this.makeErrorResponse(statusCode, null);
    }

    protected HttpResponse makeErrorResponse(int statusCode, String msg) {
        String body = "<HTML>\r\n<BODY>\r\n<HR><P><FONT SIZE=+3 COLOR=red><B>" + statusCode + "</B></FONT><P>" + "\r\n" + "<HR><P>" + msg + "</P>" + "\r\n" + "</BODY>" + "\r\n" + "</HTML>" + "\r\n";
        HttpResponse response = new HttpResponse(new HttpBody(body.getBytes()));
        response.statusCode = statusCode;
        response.setHeader(1, "text/html");
        response.setHeader(2, new Date().toString());
        String wwwauth = statusCode == 401 ? "Basic realm=\"JDMK\"" : null;
        response.setHeader(4, wwwauth);
        return response;
    }

    protected HttpResponse makeOkResponse(String bodyStr) {
        HttpBody body = new HttpBody(bodyStr.getBytes());
        HttpResponse response = new HttpResponse(body);
        response.statusCode = 200;
        response.setHeader(1, "text/html");
        response.setHeader(2, new Date().toString());
        return response;
    }

    protected String makeDebugTag() {
        return "HtmlRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }
}

