/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.xmpp.BareJID;

public class CachedPubSubRepositoryClustered
extends CachedPubSubRepository {
    private static final Logger a = Logger.getLogger(CachedPubSubRepositoryClustered.class.getCanonicalName());
    private ThreadLocal<Map<String, Node>> b = new ThreadLocal();
    private StrategyIfc c;

    public CachedPubSubRepositoryClustered(PubSubDAO dao, Integer maxCacheSize, StrategyIfc strategy) {
        super(dao, maxCacheSize);
        this.c = strategy;
    }

    public void refreshNodeConfig(BareJID serviceJid, String nodeName, String newCollection) {
        try {
            this.forgetConfiguration(serviceJid, nodeName);
            this.getRootCollectionSet(serviceJid).clear();
            if (newCollection != null) {
                this.forgetConfiguration(serviceJid, newCollection);
            }
            String string = null;
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry : this.nodes.entrySet()) {
                Node node = (Node)entry.getValue();
                AbstractNodeConfig abstractNodeConfig = node.getNodeConfig();
                if (!abstractNodeConfig.isCollectionSet()) continue;
                String[] stringArray = abstractNodeConfig.getChildren();
                if (stringArray != null) {
                    hashSet.addAll(Arrays.asList(stringArray));
                }
                if (!hashSet.contains(nodeName)) continue;
                string = abstractNodeConfig.getNodeName();
            }
            if (string != null && !string.equals(newCollection)) {
                this.forgetConfiguration(serviceJid, string);
            }
        }
        catch (RepositoryException repositoryException) {
            Logger.getLogger(CachedPubSubRepositoryClustered.class.getName()).log(Level.SEVERE, null, repositoryException);
        }
    }

    protected Node getNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node;
        String string = this.createKey(serviceJid, nodeName);
        if (this.isLocalNode(serviceJid, nodeName)) {
            node = super.getNode(serviceJid, nodeName);
        } else {
            Map<String, Node> map = this.b.get();
            if (map == null) {
                map = new HashMap<String, Node>();
                this.b.set(map);
            }
            if ((node = map.get(string)) == null) {
                long l = this.dao.getNodeId(serviceJid, nodeName);
                String string2 = this.dao.getNodeConfig(serviceJid, l);
                AbstractNodeConfig abstractNodeConfig = this.dao.parseConfig(nodeName, string2);
                if (abstractNodeConfig == null) {
                    return null;
                }
                NodeAffiliations nodeAffiliations = new NodeAffiliations(this.dao.getNodeAffiliations(serviceJid, l));
                NodeSubscriptions nodeSubscriptions = new NodeSubscriptions(this.dao.getNodeSubscriptions(serviceJid, l));
                node = new Node(l, serviceJid, abstractNodeConfig, nodeAffiliations, nodeSubscriptions);
                map.put(string, node);
            }
        }
        return node;
    }

    public void clearRemoteNodes() {
        Map<String, Node> map = this.b.get();
        if (map != null) {
            map.clear();
        }
    }

    protected boolean isLocalNode(BareJID serviceJid, String nodeName) {
        return this.c.isLocalNode(serviceJid, nodeName);
    }
}

