/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Collection;
import java.util.logging.Logger;
import tigase.component.ElementWriter;
import tigase.component.modules.Module;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.repository.IMucRepository;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public abstract class AbstractModule
implements Module {
    protected final MucConfig config;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected final IMucRepository repository;
    protected final ElementWriter writer;

    public static Element createResultIQ(Element iq) {
        return new Element("iq", new String[]{"type", "from", "to", "id"}, new String[]{"result", iq.getAttributeStaticStr("to"), iq.getAttributeStaticStr("from"), iq.getAttributeStaticStr("id")});
    }

    public static String getNicknameFromJid(JID jid) {
        if (jid != null) {
            return jid.getResource();
        }
        return null;
    }

    public AbstractModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository) {
        this.config = config;
        this.repository = mucRepository;
        this.writer = writer;
    }

    protected void sendMucMessage(Room room, String recipientNickame, String message) throws TigaseStringprepException {
        Collection<JID> occupantJids = room.getOccupantsJidsByNickname(recipientNickame);
        for (JID jid : occupantJids) {
            Packet msg = Message.getMessage((JID)JID.jidInstance((BareJID)room.getRoomJID()), (JID)jid, (StanzaType)StanzaType.groupchat, (String)message, null, null, null);
            this.writer.write(msg);
        }
    }
}

