/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionOpenThread;
import tigase.net.ConnectionType;
import tigase.net.IOService;
import tigase.net.IOServiceListener;
import tigase.net.SocketThread;
import tigase.net.SocketType;
import tigase.server.AbstractMessageReceiver;
import tigase.socks5.ServiceChecker;
import tigase.stats.StatisticsList;

public abstract class AbstractConnectionManager<IO extends IOService<?>>
extends AbstractMessageReceiver
implements IOServiceListener<IO> {
    protected static final int NET_BUFFER_HT_PROP_VAL = 65536;
    protected static final String NET_BUFFER_PROP_KEY = "net-buffer";
    protected static final int NET_BUFFER_ST_PROP_VAL = 2048;
    protected static final String PORT_CLASS_PROP_KEY = "class";
    protected static final String PORT_IFC_PROP_KEY = "ifc";
    protected static final String[] PORT_IFC_PROP_VAL = new String[]{"*"};
    protected static final String PORT_KEY = "port-no";
    protected static final String PORT_SOCKET_PROP_KEY = "socket";
    protected static final String PORT_TYPE_PROP_KEY = "type";
    protected static final String PROP_KEY = "connections/";
    private static final Logger log = Logger.getLogger(AbstractConnectionManager.class.getCanonicalName());
    private static ConnectionOpenThread connectThread = ConnectionOpenThread.getInstance();
    protected static final String PORTS_PROP_KEY = "connections/ports";
    protected Map<String, IO> services = new ConcurrentHashMap<String, IO>();
    private long bytesReceived = 0L;
    private long bytesSent = 0L;
    private int[] ports = null;
    private long socketOverflow = 0L;
    private LinkedList<Map<String, Object>> waitingTasks = new LinkedList();
    private Set<ConnectionListenerImpl> pending_open = Collections.synchronizedSet(new HashSet());
    private IOServiceStatisticsGetter ioStatsGetter = new IOServiceStatisticsGetter();
    private boolean initializationCompleted = false;
    protected int net_buffer = 2048;

    public synchronized void everyMinute() {
        this.doForAllServices(this.ioStatsGetter);
        super.everyMinute();
    }

    public void initializationCompleted() {
        this.initializationCompleted = true;
        for (Map map : this.waitingTasks) {
            this.reconnectService(map, 2000L);
        }
        this.waitingTasks.clear();
        super.initializationCompleted();
    }

    public void serviceStarted(IO serv) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "connection {0} started", serv.getUniqueId());
        }
        serv.setIOServiceListener((IOServiceListener)this);
        this.services.put(serv.getUniqueId(), serv);
    }

    public boolean serviceStopped(IO serv) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "connection {0} stopped", serv.getUniqueId());
        }
        this.services.remove(serv.getUniqueId());
        return true;
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        props.put(NET_BUFFER_PROP_KEY, 65536);
        int[] ports = this.getDefaultPorts();
        props.put(PORTS_PROP_KEY, ports);
        for (int port : ports) {
            this.putDefPortParams(props, port, SocketType.plain);
        }
        return props;
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Open connections", this.services.size(), Level.INFO);
        if (list.checkLevel(Level.FINEST) || this.services.size() < 1000) {
            int waitingToSendSize = 0;
            for (IOService serv : this.services.values()) {
                waitingToSendSize += serv.waitingToSendSize();
            }
            list.add(this.getName(), "Waiting to send", waitingToSendSize, Level.FINE);
        }
        list.add(this.getName(), "Bytes sent", this.bytesSent, Level.FINE);
        list.add(this.getName(), "Bytes received", this.bytesReceived, Level.FINE);
        list.add(this.getName(), "Socket overflow", this.socketOverflow, Level.FINE);
    }

    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.get(NET_BUFFER_PROP_KEY) != null) {
            this.net_buffer = (Integer)props.get(NET_BUFFER_PROP_KEY);
        }
        if (props.size() == 1) {
            return;
        }
        this.releaseListeners();
        this.ports = (int[])props.get(PORTS_PROP_KEY);
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                LinkedHashMap<String, Object> port_props = new LinkedHashMap<String, Object>(20);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (!entry.getKey().startsWith(PROP_KEY + this.ports[i])) continue;
                    int idx = entry.getKey().lastIndexOf(47);
                    String key = entry.getKey().substring(idx + 1);
                    log.log(Level.CONFIG, "Adding port property key: {0}={1}", new Object[]{key, entry.getValue()});
                    port_props.put(key, entry.getValue());
                }
                port_props.put(PORT_KEY, this.ports[i]);
                this.addWaitingTask(port_props);
            }
        }
    }

    protected void addWaitingTask(Map<String, Object> conn) {
        if (this.initializationCompleted) {
            this.reconnectService(conn, 2000L);
        } else {
            this.waitingTasks.add(conn);
        }
    }

    protected void doForAllServices(ServiceChecker<IO> checker) {
        for (IOService service : this.services.values()) {
            checker.check(service);
        }
    }

    protected abstract int[] getDefaultPorts();

    protected abstract IO getIOServiceInstance() throws IOException;

    protected int[] getPorts() {
        return this.ports;
    }

    protected boolean isHighThroughput() {
        return false;
    }

    private void putDefPortParams(Map<String, Object> props, int port, SocketType sock) {
        log.log(Level.CONFIG, "Generating defaults for port: {0}", port);
        props.put(PROP_KEY + port + "/" + PORT_TYPE_PROP_KEY, ConnectionType.accept);
        props.put(PROP_KEY + port + "/" + PORT_SOCKET_PROP_KEY, sock);
        props.put(PROP_KEY + port + "/" + PORT_IFC_PROP_KEY, PORT_IFC_PROP_VAL);
    }

    private void reconnectService(final Map<String, Object> port_props, long delay) {
        if (log.isLoggable(Level.FINER)) {
            String cid = "" + port_props.get("local-hostname") + "@" + port_props.get("remote-hostname");
            log.log(Level.FINER, "Reconnecting service for: {0}, scheduling next try in {1}secs, cid: {2}", new Object[]{this.getName(), delay / 1000L, cid});
        }
        this.addTimerTask(new TimerTask(){

            @Override
            public void run() {
                int port = (Integer)port_props.get(AbstractConnectionManager.PORT_KEY);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reconnecting service for component: {0}, on port: {1}", new Object[]{AbstractConnectionManager.this.getName(), port});
                }
                AbstractConnectionManager.this.startService(port_props);
            }
        }, delay);
    }

    private void releaseListeners() {
        for (ConnectionListenerImpl cli : this.pending_open) {
            connectThread.removeConnectionOpenListener((ConnectionOpenListener)cli);
        }
        this.pending_open.clear();
    }

    private void startService(Map<String, Object> port_props) {
        if (port_props == null) {
            throw new NullPointerException("port_props cannot be null.");
        }
        ConnectionListenerImpl cli = new ConnectionListenerImpl(port_props);
        if (cli.getConnectionType() == ConnectionType.accept) {
            this.pending_open.add(cli);
        }
        connectThread.addConnectionOpenListener((ConnectionOpenListener)cli);
    }

    private class IOServiceStatisticsGetter
    implements ServiceChecker<IO> {
        private StatisticsList list = new StatisticsList(Level.ALL);

        private IOServiceStatisticsGetter() {
        }

        @Override
        public synchronized void check(IO service) {
            service.getStatistics(this.list, true);
            AbstractConnectionManager.this.bytesReceived += this.list.getValue("socketio", "Bytes received", -1L);
            AbstractConnectionManager.this.bytesSent += this.list.getValue("socketio", "Bytes sent", -1L);
            AbstractConnectionManager.this.socketOverflow += this.list.getValue("socketio", "Buffers overflow", -1L);
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionOpenListener {
        private Map<String, Object> port_props = null;

        public ConnectionListenerImpl(Map<String, Object> port_props) {
            this.port_props = port_props;
        }

        public void accept(SocketChannel sc) {
            block2: {
                IOService conn = null;
                try {
                    conn = (IOService)AbstractConnectionManager.this.getIOServiceInstance();
                    conn.setIOServiceListener(null);
                    conn.accept(sc);
                    AbstractConnectionManager.this.serviceStarted(conn);
                    SocketThread.addSocketService(conn);
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, "Can not accept connection.", ex);
                    if (conn == null) break block2;
                    conn.stop();
                }
            }
        }

        public ConnectionType getConnectionType() {
            String type = null;
            if (this.port_props.get(AbstractConnectionManager.PORT_TYPE_PROP_KEY) == null) {
                log.warning(AbstractConnectionManager.this.getName() + ": connection type is null: " + this.port_props.get(AbstractConnectionManager.PORT_KEY).toString());
            } else {
                type = this.port_props.get(AbstractConnectionManager.PORT_TYPE_PROP_KEY).toString();
            }
            return ConnectionType.valueOf((String)type);
        }

        public String[] getIfcs() {
            return (String[])this.port_props.get(AbstractConnectionManager.PORT_IFC_PROP_KEY);
        }

        public int getPort() {
            return (Integer)this.port_props.get(AbstractConnectionManager.PORT_KEY);
        }

        public int getReceiveBufferSize() {
            return AbstractConnectionManager.this.net_buffer;
        }

        public InetSocketAddress getRemoteAddress() {
            return (InetSocketAddress)this.port_props.get("remote-address");
        }

        public String getRemoteHostname() {
            return (String)this.port_props.get("remote-hostname");
        }

        public SocketType getSocketType() {
            return SocketType.valueOf((String)this.port_props.get(AbstractConnectionManager.PORT_SOCKET_PROP_KEY).toString());
        }

        public String getSRVType() {
            return "_socks5._tcp";
        }

        public int getTrafficClass() {
            if (AbstractConnectionManager.this.isHighThroughput()) {
                return 8;
            }
            return 2;
        }
    }
}

