/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ConnectionRecordExt;
import tigase.sys.OnlineJidsReporter;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class CacheContener
implements OnlineJidsReporter {
    private static final Logger a = Logger.getLogger(CacheContener.class.getName());
    private volatile int b = 0;
    private volatile int c = 0;
    private final Map<BareJID, Map<JID, ConnectionRecordExt>> d = new ConcurrentSkipListMap<BareJID, Map<JID, ConnectionRecordExt>>();
    private boolean e = true;

    public int connectionsSize() {
        return this.b;
    }

    public boolean containsJid(BareJID jid) {
        return this.d.containsKey(jid);
    }

    public int mapSize() {
        return this.c;
    }

    public boolean needsSync() {
        return !this.e;
    }

    public void setSync(boolean sync) {
        this.e = sync;
        System.out.println(" == setting sync: " + this.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllForNode(JID node) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Removing connections from cache for node: {0}", node);
        }
        Iterator<Map<JID, ConnectionRecordExt>> iterator = this.d.values().iterator();
        while (iterator.hasNext()) {
            Map<JID, ConnectionRecordExt> map;
            Map<JID, ConnectionRecordExt> map2 = map = iterator.next();
            synchronized (map2) {
                Iterator<Map.Entry<JID, ConnectionRecordExt>> iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<JID, ConnectionRecordExt> entry = iterator2.next();
                    if (node.equals((Object)entry.getValue().getNode())) {
                        iterator2.remove();
                        --this.b;
                        if (!a.isLoggable(Level.FINEST)) continue;
                        a.log(Level.FINEST, "Removed connection: {0}", (Object)entry.getValue());
                        continue;
                    }
                    if (!a.isLoggable(Level.FINEST)) continue;
                    a.log(Level.FINEST, "Different node: {0}", (Object)entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePresence(Element presence, ConnectionRecordExt rec) {
        Map<JID, ConnectionRecordExt> map = this.d.get(rec.getUserJid().getBareJID());
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                ConnectionRecordExt connectionRecordExt = map.get(rec.getConnectionId());
                if (connectionRecordExt != null) {
                    connectionRecordExt.setLastPresence(presence);
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "Last presence set for: {0}", (Object)connectionRecordExt);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userDisconnected(ConnectionRecordExt rec) {
        Map<JID, ConnectionRecordExt> map = this.d.get(rec.getUserJid().getBareJID());
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                if (map.remove(rec.getConnectionId()) != null) {
                    --this.b;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usersConnected(ConnectionRecordExt ... recs) {
        for (ConnectionRecordExt connectionRecordExt : recs) {
            Map<JID, ConnectionRecordExt> map = null;
            Map<Object, Object> map2 = this.d;
            synchronized (map2) {
                map = this.d.get(connectionRecordExt.getUserJid().getBareJID());
                if (map == null) {
                    map = new LinkedHashMap<JID, ConnectionRecordExt>(2);
                    this.d.put(connectionRecordExt.getUserJid().getBareJID(), map);
                    ++this.c;
                }
            }
            map2 = map;
            synchronized (map2) {
                if (map.put(connectionRecordExt.getConnectionId(), connectionRecordExt) == null) {
                    ++this.b;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JID[] getConnectionIdsForJid(BareJID jid) {
        JID[] jIDArray = null;
        Map<JID, ConnectionRecordExt> map = this.d.get(jid);
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                int n = map.size();
                if (n > 0) {
                    jIDArray = map.keySet().toArray(new JID[n]);
                }
            }
        }
        return jIDArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionRecordExt getConnectionRecord(JID jid) {
        ConnectionRecordExt connectionRecordExt = null;
        Map<JID, ConnectionRecordExt> map = this.d.get(jid.getBareJID());
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                for (ConnectionRecordExt connectionRecordExt2 : map.values()) {
                    if (!jid.equals((Object)connectionRecordExt2.getUserJid())) continue;
                    connectionRecordExt = connectionRecordExt2;
                    break;
                }
            }
        }
        return connectionRecordExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConnectionRecordExt> getConnectionRecords(BareJID bareJID) {
        LinkedHashSet<ConnectionRecordExt> linkedHashSet = null;
        Map<JID, ConnectionRecordExt> map = this.d.get(bareJID);
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                linkedHashSet = new LinkedHashSet<ConnectionRecordExt>(map.values());
            }
        }
        return linkedHashSet;
    }

    public Object getInternalData() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JID> getNodesForJid(JID jid) {
        ArrayList<JID> arrayList = null;
        Map<JID, ConnectionRecordExt> map = this.d.get(jid.getBareJID());
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                int n = map.size();
                if (n > 0) {
                    arrayList = new ArrayList<JID>(n);
                    for (ConnectionRecordExt connectionRecordExt : map.values()) {
                        if (arrayList.contains(connectionRecordExt.getNode())) continue;
                        arrayList.add(connectionRecordExt.getNode());
                    }
                }
            }
        }
        return arrayList;
    }

    public boolean hasCompleteJidsInfo() {
        return this.e;
    }
}

