/*
 * Decompiled with CFR 0.152.
 */
package tigase.osgi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.conf.Configurator;
import tigase.osgi.ModulesManager;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.xmpp.XMPPImplIfc;

public class ModulesManagerImpl
implements ModulesManager {
    private static ModulesManagerImpl instance = null;
    private Map<String, XMPPImplIfc> plugins = new ConcurrentHashMap<String, XMPPImplIfc>();
    private Map<String, Class<? extends Configurable>> componentsClasses = new ConcurrentHashMap<String, Class<? extends Configurable>>();
    private boolean active = false;

    public static ModulesManagerImpl getInstance() {
        if (instance == null) {
            instance = new ModulesManagerImpl();
        }
        return instance;
    }

    private ModulesManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPluginClass(Class<? extends XMPPImplIfc> pluginCls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            try {
                XMPPImplIfc plugin = pluginCls.newInstance();
                this.plugins.put(plugin.id(), plugin);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(ModulesManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ModulesManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPluginClass(Class<? extends XMPPImplIfc> pluginClass) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            String key = null;
            for (Map.Entry<String, XMPPImplIfc> entry : this.plugins.entrySet()) {
                if (!pluginClass.equals(entry.getValue())) continue;
                key = entry.getKey();
            }
            if (key != null) {
                this.plugins.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServerComponentClass(Class<? extends Configurable> compCls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            this.componentsClasses.put(compCls.getCanonicalName(), compCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterServerComponentClass(Class<? extends Configurable> compCls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            this.componentsClasses.remove(compCls.getCanonicalName());
        }
    }

    @Override
    public void update() {
        if (this.active) {
            ((Configurator)XMPPServer.getConfigurator()).updateMessageRouter();
        }
    }

    public XMPPImplIfc getPlugin(String plug_id) throws InstantiationException, IllegalAccessException {
        return this.plugins.get(plug_id);
    }

    public boolean hasPluginForId(String plug_id) {
        return this.plugins.containsKey(plug_id);
    }

    public Class<? extends ServerComponent> getServerComponentClass(String className) {
        return this.componentsClasses.get(className);
    }

    public ServerComponent getServerComponent(String className) throws InstantiationException, IllegalAccessException {
        Class<? extends Configurable> compCls = this.componentsClasses.get(className);
        if (compCls == null) {
            return null;
        }
        return compCls.newInstance();
    }

    public boolean hasClassForServerComponent(String className) {
        return this.componentsClasses.containsKey(className);
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

