/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.RSM;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.server.Message;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;

public class MessageArchiveDB {
    private static final String JIDS_ID = "jid_id";
    private static final String JIDS_JID = "jid";
    private static final String JIDS_TABLE = "tig_ma_jids";
    private static final Logger log = Logger.getLogger(MessageArchiveDB.class.getCanonicalName());
    private static final long LONG_NULL = 0L;
    private static final long MILIS_PER_DAY = 86400000L;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat formatter3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat formatter4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String MSGS_BUDDY_ID = "buddy_id";
    private static final String MSGS_DIRECTION = "direction";
    private static final String MSGS_MSG = "msg";
    private static final String MSGS_OWNER_ID = "owner_id";
    private static final String MSGS_TABLE = "tig_ma_msgs";
    private static final String MSGS_TIMESTAMP = "ts";
    private static final String MSGS_TYPE = "type";
    private static final SimpleParser parser;
    private static final String GET_JID_IDS_QUERY = "select jid, jid_id from tig_ma_jids where jid = ? or jid = ?";
    private static final String GET_JID_ID_QUERY = "select jid, jid_id from tig_ma_jids where jid = ?";
    private static final String ADD_JID_QUERY = "insert into tig_ma_jids (jid) values (?)";
    private static final String DERBY_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint generated by default as identity not null, jid varchar(2049), primary key ( jid_id ));create unique index tig_ma_jids_jid on tig_ma_jids (jid);";
    private static final String PGSQL_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigserial, jid varchar(2049), primary key (jid_id)); create unique index tig_ma_jids_jid on tig_ma_jids ( jid);";
    private static final String SQLSERVER_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint identity(1,1), jid nvarchar(2049),jid_fragment as left (jid, 765),primary key (jid_id)); create unique index tig_ma_jids_jid on tig_ma_jids ( jid_fragment );";
    private static final String MYSQL_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint unsigned NOT NULL auto_increment, jid varchar(2049), primary key (jid_id)); ";
    private static final String GET_MESSAGES = "select msg from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ? order by ts";
    private static final String GET_MESSAGES_END = "select msg from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ? and ts <= ? order by ts";
    private static final String GET_MESSAGES_COUNT = "select count(ts) from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ?";
    private static final String GET_MESSAGES_END_COUNT = "select count(ts) from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ? and ts <= ?";
    private static final String GET_COLLECTIONS_SELECT = "select min(m.ts), j.jid from tig_ma_msgs m inner join tig_ma_jids j on m.buddy_id = j.jid_id where m.owner_id = ? ";
    private static final String GET_COLLECTIONS_SELECT_GROUP = "group by date(m.ts), m.buddy_id, j.jid order by min(m.ts), j.jid";
    private static final String GET_COLLECTIONS_COUNT = "select count(1) from (select min(m.ts), m.buddy_id from tig_ma_msgs m where m.owner_id = ? ";
    private static final String GET_COLLECTIONS_COUNT_GROUP = "group by date(m.ts), m.buddy_id) x";
    private static final String GENERIC_LIMIT = " limit ? offset ?";
    private static final String DERBY_LIMIT = " offset ? rows fetch next ? rows only";
    private static final String[][] GET_COLLECTIONS_WHERES;
    private static final String[] GET_COLLECTIONS_COMBINATIONS;
    private static final String ADD_MESSAGE = "insert into tig_ma_msgs (owner_id, buddy_id, ts, direction, type, msg) values (?, ?, ?, ?, ?, ?)";
    private static final String REMOVE_MSGS = "delete from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts <= ? and ts >= ?";
    private static final String DERBY_CREATE_MSGS = "create table tig_ma_msgs (owner_id bigint references tig_ma_jids(jid_id),buddy_id bigint references tig_ma_jids(jid_id),ts timestamp, direction smallint, type varchar(10), msg varchar(32672));create index tig_ma_msgs_owner_id_index on tig_ma_msgs (owner_id);create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs (owner_id, buddy_id);create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs (owner_id, ts, buddy_id);";
    private static final String PGSQL_CREATE_MSGS = "create table tig_ma_msgs (owner_id bigint, buddy_id bigint, ts timestamp, direction smallint, type varchar(10),msg text, foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id) ); create index tig_ma_msgs_owner_id_index on tig_ma_msgs ( owner_id); create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs ( owner_id, buddy_id); create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs ( owner_id, ts, buddy_id); ";
    private static final String SQLSERVER_CREATE_MSGS = "create table tig_ma_msgs (owner_id bigint, buddy_id bigint, ts datetime, direction smallint, type nvarchar(10),msg ntext, foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id) ); create index tig_ma_msgs_owner_id_index on tig_ma_msgs ( owner_id); create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs ( owner_id, buddy_id); create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs ( owner_id, ts, buddy_id); ";
    private static final String MYSQL_CREATE_MSGS = "create table tig_ma_msgs (owner_id bigint unsigned, buddy_id bigint unsigned, ts timestamp, direction smallint, type varchar(10),msg text, foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id), key (owner_id), key (owner_id, buddy_id), key (owner_id, ts, buddy_id));";
    private DataRepository data_repo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRepository(String conn_str, Map<String, String> params) throws SQLException {
        SimpleDateFormat simpleDateFormat = formatter;
        synchronized (simpleDateFormat) {
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, (String)conn_str, params);
            switch (this.data_repo.getDatabaseType()) {
                case mysql: {
                    this.data_repo.checkTable(JIDS_TABLE, MYSQL_CREATE_JIDS);
                    this.data_repo.checkTable(MSGS_TABLE, MYSQL_CREATE_MSGS);
                    break;
                }
                case derby: {
                    this.data_repo.checkTable(JIDS_TABLE, DERBY_CREATE_JIDS);
                    this.data_repo.checkTable(MSGS_TABLE, DERBY_CREATE_MSGS);
                    break;
                }
                case postgresql: {
                    this.data_repo.checkTable(JIDS_TABLE, PGSQL_CREATE_JIDS);
                    this.data_repo.checkTable(MSGS_TABLE, PGSQL_CREATE_MSGS);
                    break;
                }
                case jtds: 
                case sqlserver: {
                    this.data_repo.checkTable(JIDS_TABLE, SQLSERVER_CREATE_JIDS);
                    this.data_repo.checkTable(MSGS_TABLE, SQLSERVER_CREATE_MSGS);
                }
            }
            this.data_repo.initPreparedStatement(ADD_JID_QUERY, ADD_JID_QUERY);
            this.data_repo.initPreparedStatement(GET_JID_ID_QUERY, GET_JID_ID_QUERY);
            this.data_repo.initPreparedStatement(GET_JID_IDS_QUERY, GET_JID_IDS_QUERY);
            this.data_repo.initPreparedStatement(ADD_MESSAGE, ADD_MESSAGE);
            for (String combination : GET_COLLECTIONS_COMBINATIONS) {
                String[] whereParts = combination.split("_");
                String select = GET_COLLECTIONS_SELECT;
                String count = GET_COLLECTIONS_COUNT;
                for (String part : whereParts) {
                    for (String[] where : GET_COLLECTIONS_WHERES) {
                        if (!part.equals(where[0])) continue;
                        select = select + where[1];
                        count = count + where[1];
                    }
                }
                select = select + GET_COLLECTIONS_SELECT_GROUP;
                count = count + GET_COLLECTIONS_COUNT_GROUP;
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        select = select + DERBY_LIMIT;
                        break;
                    }
                    default: {
                        select = select + GENERIC_LIMIT;
                    }
                }
                this.data_repo.initPreparedStatement("GET_COLLECTIONS_" + combination + "_SELECT", select);
                this.data_repo.initPreparedStatement("GET_COLLECTIONS_" + combination + "_COUNT", count);
            }
            switch (this.data_repo.getDatabaseType()) {
                case derby: {
                    this.data_repo.initPreparedStatement(GET_MESSAGES, "select msg from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ? order by ts offset ? rows fetch next ? rows only");
                    this.data_repo.initPreparedStatement(GET_MESSAGES_END, "select msg from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ? and ts <= ? order by ts offset ? rows fetch next ? rows only");
                    break;
                }
                default: {
                    this.data_repo.initPreparedStatement(GET_MESSAGES, "select msg from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ? order by ts limit ? offset ?");
                    this.data_repo.initPreparedStatement(GET_MESSAGES_END, "select msg from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts >= ? and ts <= ? order by ts limit ? offset ?");
                }
            }
            this.data_repo.initPreparedStatement(GET_MESSAGES_COUNT, GET_MESSAGES_COUNT);
            this.data_repo.initPreparedStatement(GET_MESSAGES_END_COUNT, GET_MESSAGES_END_COUNT);
            this.data_repo.initPreparedStatement(REMOVE_MSGS, REMOVE_MSGS);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "MessageArchiveDB initialization exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveMessage(BareJID owner, BareJID buddy, short direction, Element msg) {
        try {
            PreparedStatement add_message_st;
            String owner_str = owner.toString();
            String buddy_str = buddy.toString();
            long[] jids_ids = this.getJidsIds(owner_str, buddy_str);
            long owner_id = jids_ids[0] != 0L ? jids_ids[0] : this.addJidId(owner_str);
            long buddy_id = jids_ids[1] != 0L ? jids_ids[1] : this.addJidId(buddy_str);
            Timestamp mtime = null;
            Element delay = msg.findChildStaticStr(Message.MESSAGE_DELAY_PATH);
            if (delay != null) {
                try {
                    String stamp = delay.getAttributeStaticStr("stamp");
                    mtime = this.parseTimestamp(stamp);
                }
                catch (ParseException e1) {}
            } else {
                mtime = new Timestamp(System.currentTimeMillis());
            }
            msg.addAttribute("time", String.valueOf(mtime.getTime()));
            String type = msg.getAttributeStaticStr(MSGS_TYPE);
            String msgStr = msg.toString();
            PreparedStatement preparedStatement = add_message_st = this.data_repo.getPreparedStatement(owner, ADD_MESSAGE);
            synchronized (preparedStatement) {
                add_message_st.setLong(1, owner_id);
                add_message_st.setLong(2, buddy_id);
                add_message_st.setTimestamp(3, mtime);
                add_message_st.setShort(4, direction);
                add_message_st.setString(5, type);
                add_message_st.setString(6, msgStr);
                add_message_st.executeUpdate();
            }
        }
        catch (SQLException ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: {0}", msg);
        }
    }

    public List<Element> getCollections(BareJID owner, String withJid, Date start, Date end, RSM rsm) throws SQLException {
        long[] jids_ids = withJid == null ? this.getJidsIds(owner.toString()) : this.getJidsIds(owner.toString(), withJid);
        Long buddyId = jids_ids.length > 1 ? Long.valueOf(jids_ids[1]) : null;
        Timestamp start_ = start != null ? new Timestamp(start.getTime()) : null;
        Timestamp end_ = end != null ? new Timestamp(end.getTime()) : null;
        int index = rsm.getIndex() == null ? 0 : rsm.getIndex();
        StringBuilder query = new StringBuilder(20);
        if (start_ != null) {
            query.append("FROM");
        }
        if (end_ != null) {
            if (query.length() > 0) {
                query.append("_");
            }
            query.append("TO");
        }
        if (buddyId != null) {
            if (query.length() > 0) {
                query.append("_");
            }
            query.append("WITH");
        }
        String queryStr = query.toString();
        List<Element> results = this.getCollections(owner, jids_ids[0], buddyId, start_, end_, index, rsm.getMax(), queryStr);
        Integer count = this.getCollectionsCount(owner, jids_ids[0], buddyId, start_, end_, queryStr);
        rsm.setResults(count, index);
        return results;
    }

    public List<Element> getItems(BareJID owner, String withJid, Date start, Date end, RSM rsm) throws SQLException {
        long[] jids_ids = this.getJidsIds(owner.toString(), withJid);
        Timestamp startTimestamp = new Timestamp(start.getTime());
        Timestamp endTimestamp = end != null ? new Timestamp(end.getTime()) : null;
        int offset = rsm.getIndex() != null ? rsm.getIndex() : 0;
        int limit = rsm.getMax();
        List<Element> items = this.getItems(owner, jids_ids[0], jids_ids[1], startTimestamp, endTimestamp, offset, limit);
        int count = this.getItemsCount(owner, jids_ids[0], jids_ids[1], startTimestamp, endTimestamp);
        rsm.setResults(count, offset);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItems(BareJID owner, String withJid, Date start, Date end) throws SQLException {
        PreparedStatement remove_msgs_st;
        long[] jids_ids = this.getJidsIds(owner.toString(), withJid);
        if (start == null) {
            start = new Date(0L);
        }
        if (end == null) {
            end = new Date(0L);
        }
        Timestamp start_ = new Timestamp(start.getTime());
        Timestamp end_ = new Timestamp(end.getTime());
        PreparedStatement preparedStatement = remove_msgs_st = this.data_repo.getPreparedStatement(owner, REMOVE_MSGS);
        synchronized (preparedStatement) {
            PreparedStatement preparedStatement2 = remove_msgs_st;
            synchronized (preparedStatement2) {
                remove_msgs_st.setLong(1, jids_ids[0]);
                remove_msgs_st.setLong(2, jids_ids[1]);
                remove_msgs_st.setTimestamp(3, end_);
                remove_msgs_st.setTimestamp(4, start_);
                remove_msgs_st.executeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> getCollections(BareJID owner, long ownerId, Long buddyId, Timestamp start, Timestamp end, int index, int limit, String queryStr) throws SQLException {
        LinkedList<Element> results = new LinkedList<Element>();
        ResultSet selectRs = null;
        try {
            PreparedStatement get_collections_st = this.data_repo.getPreparedStatement(owner, "GET_COLLECTIONS_" + queryStr + "_SELECT");
            int i = 2;
            PreparedStatement preparedStatement = get_collections_st;
            synchronized (preparedStatement) {
                get_collections_st.setLong(1, ownerId);
                if (start != null) {
                    get_collections_st.setTimestamp(i++, start);
                }
                if (end != null) {
                    get_collections_st.setTimestamp(i++, end);
                }
                if (buddyId != null) {
                    get_collections_st.setLong(i++, buddyId);
                }
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        get_collections_st.setInt(i++, index);
                        get_collections_st.setInt(i++, limit);
                        break;
                    }
                    default: {
                        get_collections_st.setInt(i++, limit);
                        get_collections_st.setInt(i++, index);
                    }
                }
                selectRs = get_collections_st.executeQuery();
                while (selectRs.next()) {
                    Timestamp startTs = selectRs.getTimestamp(1);
                    String with = selectRs.getString(2);
                    String formattedStart = null;
                    SimpleDateFormat simpleDateFormat = formatter2;
                    synchronized (simpleDateFormat) {
                        formattedStart = formatter2.format(startTs);
                    }
                    results.add(new Element("chat", new String[]{"with", "start"}, new String[]{with, formattedStart}));
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, selectRs);
            throw throwable;
        }
        this.data_repo.release(null, selectRs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCollectionsCount(BareJID owner, long ownerId, Long buddyId, Timestamp start_, Timestamp end_, String queryStr) throws SQLException {
        ResultSet countRs = null;
        Integer count = null;
        try {
            PreparedStatement get_collections_count = this.data_repo.getPreparedStatement(owner, "GET_COLLECTIONS_" + queryStr + "_COUNT");
            int i = 2;
            PreparedStatement preparedStatement = get_collections_count;
            synchronized (preparedStatement) {
                get_collections_count.setLong(1, ownerId);
                if (start_ != null) {
                    get_collections_count.setTimestamp(i++, start_);
                }
                if (end_ != null) {
                    get_collections_count.setTimestamp(i++, end_);
                }
                if (buddyId != null) {
                    get_collections_count.setLong(i++, buddyId);
                }
                if ((countRs = get_collections_count.executeQuery()).next()) {
                    count = countRs.getInt(1);
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, countRs);
            throw throwable;
        }
        this.data_repo.release(null, countRs);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> getItems(BareJID owner, long ownerId, long withId, Timestamp startTimestamp, Timestamp endTimestamp, int offset, int limit) throws SQLException {
        ResultSet rs = null;
        StringBuilder buf = new StringBuilder(16384);
        int i = 1;
        try {
            PreparedStatement get_messages_st;
            PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, endTimestamp != null ? GET_MESSAGES_END : GET_MESSAGES);
            synchronized (preparedStatement) {
                get_messages_st.setLong(i++, ownerId);
                get_messages_st.setLong(i++, withId);
                get_messages_st.setTimestamp(i++, startTimestamp);
                if (endTimestamp != null) {
                    get_messages_st.setTimestamp(i++, endTimestamp);
                }
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        get_messages_st.setInt(i++, offset);
                        get_messages_st.setInt(i++, limit);
                        break;
                    }
                    default: {
                        get_messages_st.setInt(i++, limit);
                        get_messages_st.setInt(i++, offset);
                    }
                }
                rs = get_messages_st.executeQuery();
                while (rs.next()) {
                    buf.append(rs.getString(1));
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        LinkedList<Element> msgs = null;
        if (buf != null) {
            String results = buf.toString();
            msgs = new LinkedList<Element>();
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse((SimpleHandler)domHandler, results.toCharArray(), 0, results.length());
            Queue queue = domHandler.getParsedElements();
            String ownerStr = owner.toString();
            Element msg = null;
            while ((msg = (Element)queue.poll()) != null) {
                Element item = new Element(msg.getAttributeStaticStr("from").startsWith(ownerStr) ? "to" : "from");
                item.addChild((XMLNodeIfc)msg.getChild("body"));
                item.setAttribute("secs", String.valueOf((Long.valueOf(msg.getAttributeStaticStr("time")) - startTimestamp.getTime()) / 1000L));
                msgs.add(item);
            }
            Collections.sort(msgs, new Comparator<Element>(){

                @Override
                public int compare(Element m1, Element m2) {
                    return m1.getAttributeStaticStr("secs").compareTo(m2.getAttributeStaticStr("secs"));
                }
            });
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getItemsCount(BareJID owner, long ownerId, long withId, Timestamp startTimestamp, Timestamp endTimestamp) throws SQLException {
        ResultSet rs = null;
        Integer count = null;
        int i = 1;
        try {
            PreparedStatement get_messages_st;
            PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, endTimestamp != null ? GET_MESSAGES_END_COUNT : GET_MESSAGES_COUNT);
            synchronized (preparedStatement) {
                get_messages_st.setLong(i++, ownerId);
                get_messages_st.setLong(i++, withId);
                get_messages_st.setTimestamp(i++, startTimestamp);
                if (endTimestamp != null) {
                    get_messages_st.setTimestamp(i++, endTimestamp);
                }
                if ((rs = get_messages_st.executeQuery()).next()) {
                    count = rs.getInt(1);
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected long[] getJidsIds(String ... jids) throws SQLException {
        long[] lArray;
        long[] results;
        ResultSet rs;
        block13: {
            PreparedStatement preparedStatement;
            block14: {
                PreparedStatement get_jid_id_st;
                rs = null;
                results = new long[jids.length];
                Arrays.fill(results, 0L);
                if (jids.length != 1) break block13;
                preparedStatement = get_jid_id_st = this.data_repo.getPreparedStatement(null, GET_JID_ID_QUERY);
                // MONITORENTER : preparedStatement
                get_jid_id_st.setString(1, jids[0]);
                rs = get_jid_id_st.executeQuery();
                if (!rs.next()) break block14;
                results[0] = rs.getLong(JIDS_ID);
                long[] lArray2 = results;
                // MONITOREXIT : preparedStatement
                this.data_repo.release(null, rs);
                return lArray2;
            }
            // MONITOREXIT : preparedStatement
            preparedStatement = null;
            this.data_repo.release(null, rs);
            return preparedStatement;
        }
        try {
            PreparedStatement get_jids_id_st;
            PreparedStatement preparedStatement = get_jids_id_st = this.data_repo.getPreparedStatement(null, GET_JID_IDS_QUERY);
            // MONITORENTER : preparedStatement
            for (int i = 0; i < jids.length; ++i) {
                get_jids_id_st.setString(i + 1, jids[i]);
            }
            rs = get_jids_id_st.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                String db_jid = rs.getString(JIDS_JID);
                for (int i = 0; i < jids.length; ++i) {
                    if (!db_jid.equals(jids[i])) continue;
                    results[i] = rs.getLong(JIDS_ID);
                    ++cnt;
                }
            }
            lArray = results;
            // MONITOREXIT : preparedStatement
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addJidId(String jid) throws SQLException {
        PreparedStatement add_jid_st;
        PreparedStatement preparedStatement = add_jid_st = this.data_repo.getPreparedStatement(null, ADD_JID_QUERY);
        synchronized (preparedStatement) {
            add_jid_st.setString(1, jid);
            add_jid_st.executeUpdate();
        }
        long[] jid_ids = this.getJidsIds(jid);
        if (jid_ids != null) {
            return jid_ids[0];
        }
        log.log(Level.WARNING, "I have just added new jid but it was not found.... {0}", jid);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp parseTimestamp(String tmp) throws ParseException {
        Date date = null;
        if (tmp.endsWith("Z")) {
            if (tmp.contains(".")) {
                SimpleDateFormat simpleDateFormat = formatter4;
                synchronized (simpleDateFormat) {
                    date = formatter4.parse(tmp);
                }
            } else {
                SimpleDateFormat simpleDateFormat = formatter;
                synchronized (simpleDateFormat) {
                    date = formatter.parse(tmp);
                }
            }
        } else {
            if (tmp.contains(".")) {
                SimpleDateFormat simpleDateFormat = formatter3;
                synchronized (simpleDateFormat) {
                    date = formatter3.parse(tmp);
                }
            }
            SimpleDateFormat simpleDateFormat = formatter2;
            synchronized (simpleDateFormat) {
                date = formatter2.parse(tmp);
            }
        }
        return new Timestamp(date.getTime());
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter3.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter4.setTimeZone(TimeZone.getTimeZone("UTC"));
        parser = SingletonFactory.getParserInstance();
        GET_COLLECTIONS_WHERES = new String[][]{{"FROM", "and m.ts >= ? "}, {"TO", "and m.ts <= ? "}, {"WITH", "and m.buddy_id = ? "}};
        GET_COLLECTIONS_COMBINATIONS = new String[]{"FROM", "FROM_TO", "FROM_TO_WITH", "FROM_WITH", "TO", "TO_WITH", "WITH"};
    }
}

