/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.Items;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.stats.StatisticsList;
import tigase.xmpp.BareJID;

public class CachedPubSubRepository
implements IPubSubRepository {
    public static final long MAX_WRITE_DELAY = 15000L;
    protected final IPubSubDAO dao;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final Integer maxCacheSize;
    protected final Map<String, Node> nodes;
    private long nodes_added = 0L;
    private final ConcurrentSkipListSet<Node> nodesToSave = new ConcurrentSkipListSet<Node>(new NodeComparator());
    private long repo_writes = 0L;
    private final ConcurrentHashMap<BareJID, Set<String>> rootCollection = new ConcurrentHashMap();
    private NodeSaver nodeSaver;
    private long updateSubscriptionsCalled = 0L;
    private long writingTime = 0L;

    public CachedPubSubRepository(PubSubDAO dao, Integer maxCacheSize) {
        this.dao = dao;
        this.maxCacheSize = maxCacheSize;
        this.nodes = Collections.synchronizedMap(new SizedCache(this.maxCacheSize));
        this.log.config("Initializing Cached Repository with cache size = " + (maxCacheSize == null ? "OFF" : maxCacheSize));
        this.nodeSaver = new NodeSaver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStats(String name, StatisticsList stats) {
        if (this.nodes.size() > 0) {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINE);
        } else {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINEST);
        }
        if (this.nodesToSave.size() > 0) {
            stats.add(name, "Unsaved nodes", this.nodesToSave.size(), Level.INFO);
        } else {
            stats.add(name, "Unsaved nodes", this.nodesToSave.size(), Level.FINEST);
        }
        long subscriptionsCount = 0L;
        long affiliationsCount = 0L;
        LinkedHashMap<String, Node> tmp = null;
        Map<String, Node> map = this.nodes;
        synchronized (map) {
            tmp = new LinkedHashMap<String, Node>(this.nodes);
        }
        for (Node nd : tmp.values()) {
            subscriptionsCount += (long)nd.getNodeSubscriptions().getSubscriptionsMap().size();
            affiliationsCount += (long)nd.getNodeAffiliations().getAffiliationsMap().size();
        }
        if (this.updateSubscriptionsCalled > 0L) {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINE);
        } else {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINEST);
        }
        if (subscriptionsCount > 0L) {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINE);
        } else {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINEST);
        }
        if (affiliationsCount > 0L) {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINE);
        } else {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINEST);
        }
        if (this.repo_writes > 0L) {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINE);
        } else {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Added new nodes", this.nodes_added, Level.INFO);
        } else {
            stats.add(name, "Added new nodes", this.nodes_added, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.INFO);
        } else {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.FINEST);
        }
        if (this.nodes_added + this.repo_writes > 0L) {
            if (this.nodes_added > 0L) {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.INFO);
            } else {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.FINEST);
            }
        }
    }

    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        this.dao.addToRootCollection(serviceJid, nodeName);
        this.getRootCollectionSet(serviceJid).add(nodeName);
    }

    protected String createKey(BareJID serviceJid, String nodeName) {
        return serviceJid.toString() + "/" + nodeName;
    }

    @Override
    public void createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        long start = System.currentTimeMillis();
        Long collectionId = null;
        if (collection != null && !collection.equals("") && (collectionId = Long.valueOf(this.dao.getNodeId(serviceJid, collection))) == 0L) {
            throw new RepositoryException("Parent collection does not exists yet!");
        }
        long nodeId = this.dao.createNode(serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collectionId);
        tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = NodeAffiliations.create((Queue<UsersAffiliation>)null);
        tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = NodeSubscriptions.create();
        Node node = new Node(nodeId, serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions);
        String key = this.createKey(serviceJid, nodeName);
        this.nodes.put(key, node);
        long end = System.currentTimeMillis();
        ++this.nodes_added;
        this.writingTime += end - start;
    }

    @Override
    public void deleteNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        long nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        this.dao.deleteNode(serviceJid, nodeId);
        if (node != null) {
            node.setDeleted(true);
        }
        this.nodes.remove(key);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void forgetConfiguration(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        this.nodes.remove(key);
    }

    public Collection<Node> getAllNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public String[] getBuddyGroups(BareJID owner, BareJID bareJid) throws RepositoryException {
        return this.dao.getBuddyGroups(owner, bareJid);
    }

    @Override
    public String getBuddySubscription(BareJID owner, BareJID buddy) throws RepositoryException {
        return this.dao.getBuddySubscription(owner, buddy);
    }

    protected Node getNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        if (node == null) {
            long nodeId = this.dao.getNodeId(serviceJid, nodeName);
            String cfgData = this.dao.getNodeConfig(serviceJid, nodeId);
            AbstractNodeConfig nodeConfig = this.dao.parseConfig(nodeName, cfgData);
            if (nodeConfig == null) {
                return null;
            }
            tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = new tigase.pubsub.repository.cached.NodeAffiliations(this.dao.getNodeAffiliations(serviceJid, nodeId));
            tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = new tigase.pubsub.repository.cached.NodeSubscriptions(this.dao.getNodeSubscriptions(serviceJid, nodeId));
            node = new Node(nodeId, serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions);
            this.nodes.put(key, node);
        }
        return node;
    }

    @Override
    public IAffiliations getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        return node == null ? null : node.getNodeAffiliations();
    }

    @Override
    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        try {
            return node == null ? null : node.getNodeConfig().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IItems getNodeItems(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        long nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        return new Items(nodeId, serviceJid, nodeName, this.dao);
    }

    @Override
    public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        return node == null ? null : node.getNodeSubscriptions();
    }

    @Override
    public IPubSubDAO getPubSubDAO() {
        return this.dao;
    }

    @Override
    public String[] getRootCollection(BareJID serviceJid) throws RepositoryException {
        Set<String> rootCollection = this.getRootCollectionSet(serviceJid);
        if (rootCollection == null) {
            return null;
        }
        return rootCollection.toArray(new String[rootCollection.size()]);
    }

    protected Set<String> getRootCollectionSet(BareJID serviceJid) throws RepositoryException {
        Set rootCollection = this.rootCollection.get(serviceJid);
        if (rootCollection == null || rootCollection.isEmpty()) {
            Set oldRootCollection;
            if (rootCollection == null && (oldRootCollection = (Set)this.rootCollection.putIfAbsent(serviceJid, new HashSet())) != null) {
                rootCollection = oldRootCollection;
            }
            String[] x = this.dao.getChildNodes(serviceJid, null);
            if (rootCollection == null) {
                rootCollection = new HashSet<String>();
            }
            if (x != null) {
                for (String string : x) {
                    rootCollection.add(string);
                }
            }
        }
        return rootCollection;
    }

    @Override
    public BareJID[] getUserRoster(BareJID owner) throws RepositoryException {
        return this.dao.getUserRoster(owner);
    }

    @Override
    public void init() {
        this.log.config("Cached PubSubRepository initialising...");
    }

    @Override
    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        long nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        this.dao.removeFromRootCollection(serviceJid, nodeId);
        this.rootCollection.remove(nodeName);
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            node.configCopyFrom(nodeConfig);
            this.log.finest("Node '" + nodeName + "' added to lazy write queue (config)");
            this.nodeSaver.save(node);
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        if (nodeAffiliations instanceof tigase.pubsub.repository.cached.NodeAffiliations) {
            Node node = this.getNode(serviceJid, nodeName);
            if (node != null) {
                if (node.getNodeAffiliations() != nodeAffiliations) {
                    throw new RuntimeException("INCORRECT");
                }
                this.log.finest("Node '" + nodeName + "' added to lazy write queue (affiliations)");
                this.nodeSaver.save(node);
            }
        } else {
            throw new RuntimeException("Wrong class");
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, ISubscriptions nodeSubscriptions) throws RepositoryException {
        ++this.updateSubscriptionsCalled;
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            this.log.finest("Node '" + nodeName + "' added to lazy write queue (subscriptions)");
            this.nodeSaver.save(node);
        }
    }

    private class SizedCache
    extends LinkedHashMap<String, Node> {
        private static final long serialVersionUID = 1L;
        private int maxCacheSize;

        public SizedCache(int maxSize) {
            super(maxSize, 0.1f, true);
            this.maxCacheSize = 1000;
            this.maxCacheSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Node> eldest) {
            return this.size() > this.maxCacheSize && !eldest.getValue().needsWriting();
        }
    }

    private class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.getCreationTime() < o2.getCreationTime()) {
                return -1;
            }
            if (o1.getCreationTime() > o2.getCreationTime()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class NodeSaver {
        private NodeSaver() {
        }

        public void save(Node node) throws RepositoryException {
            long start = System.currentTimeMillis();
            ++CachedPubSubRepository.this.repo_writes;
            try {
                if (node.isDeleted()) {
                    return;
                }
                if (node.affiliationsNeedsWriting()) {
                    Map<BareJID, UsersAffiliation> changedAffiliations = node.getNodeAffiliations().getChanged();
                    for (Map.Entry<BareJID, Cloneable> entry : changedAffiliations.entrySet()) {
                        CachedPubSubRepository.this.dao.updateNodeAffiliation(node.getServiceJid(), node.getNodeId(), (UsersAffiliation)entry.getValue());
                    }
                    node.affiliationsSaved();
                }
                if (node.subscriptionsNeedsWriting()) {
                    Map<BareJID, UsersSubscription> changedSubscriptions = node.getNodeSubscriptions().getChanged();
                    for (Map.Entry<BareJID, Cloneable> entry : changedSubscriptions.entrySet()) {
                        UsersSubscription subscription = (UsersSubscription)entry.getValue();
                        if (subscription.getSubscription() == Subscription.none) {
                            CachedPubSubRepository.this.dao.removeNodeSubscription(node.getServiceJid(), node.getNodeId(), subscription.getJid());
                            continue;
                        }
                        CachedPubSubRepository.this.dao.updateNodeSubscription(node.getServiceJid(), node.getNodeId(), subscription);
                    }
                    node.subscriptionsSaved();
                }
                if (node.configNeedsWriting()) {
                    String collection = node.getNodeConfig().getCollection();
                    Long collectionId = null;
                    if (collection != null && !collection.equals("") && (collectionId = Long.valueOf(CachedPubSubRepository.this.dao.getNodeId(node.getServiceJid(), collection))) == 0L) {
                        throw new RepositoryException("Parent collection does not exists yet!");
                    }
                    CachedPubSubRepository.this.dao.updateNodeConfig(node.getServiceJid(), node.getNodeId(), node.getNodeConfig().getFormElement().toString(), collectionId);
                    node.configSaved();
                }
            }
            catch (Exception e) {
                CachedPubSubRepository.this.log.log(Level.WARNING, "Problem saving pubsub data: ", e);
                node.resetChanges();
                throw new RepositoryException("Problem saving pubsub data", e);
            }
            if (node.needsWriting()) {
                this.save(node);
            }
            long end = System.currentTimeMillis();
            CachedPubSubRepository.this.writingTime += end - start;
        }
    }
}

