/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocCommandManager;
import tigase.adhoc.AdHocScriptCommandManager;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class AdHocConfigCommandModule
extends AbstractPubSubModule {
    private static final String[] COMMAND_PATH = new String[]{"iq", "command"};
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"command", (String)"http://jabber.org/protocol/commands"));
    private final AdHocCommandManager commandsManager = new AdHocCommandManager();
    private AdHocScriptCommandManager scriptCommandManager;

    public AdHocConfigCommandModule(PubSubConfig config, PacketWriter packetWriter, AdHocScriptCommandManager scriptCommandManager) {
        super(config, packetWriter);
        this.scriptCommandManager = scriptCommandManager;
    }

    public List<Element> getCommandListItems(JID senderJid, JID toJid) {
        ArrayList<Element> commandsList = new ArrayList<Element>();
        for (AdHocCommand command : this.commandsManager.getAllCommands()) {
            if (!this.config.isAdmin(senderJid)) continue;
            commandsList.add(new Element("item", new String[]{"jid", "node", "name"}, new String[]{toJid.toString(), command.getNode(), command.getName()}));
        }
        List<Element> scriptCommandsList = this.scriptCommandManager.getCommandListItems(senderJid, toJid);
        if (scriptCommandsList != null) {
            commandsList.addAll(scriptCommandsList);
        }
        return commandsList;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/commands"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        String node = packet.getAttributeStaticStr(COMMAND_PATH, "node");
        if (this.commandsManager.hasCommand(node)) {
            try {
                this.packetWriter.write(this.commandsManager.process(packet));
            }
            catch (AdHocCommandException e) {
                throw new PubSubException(e.getErrorCondition(), e.getMessage());
            }
        } else {
            this.packetWriter.write(this.scriptCommandManager.process(packet));
        }
    }

    public void register(AdHocCommand command) {
        this.commandsManager.registerCommand(command);
    }
}

