/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateUtil;
import tigase.xmpp.XMPPIOService;

public class ClientTrustManagerFactory {
    public static final String CA_CERT_PATH = "clientCertCA";
    private static final char[] EMPTY_PASS = new char[0];
    private final ArrayList<X509Certificate> acceptedIssuers = new ArrayList();
    private final KeyStore keystore;
    private TrustManagerFactory tmf;
    private X509TrustManager trustManager;
    private final TrustManager[] trustWrapper = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            ClientTrustManagerFactory.this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return ClientTrustManagerFactory.this.trustManager.getAcceptedIssuers();
        }
    }};
    private boolean saslExternalAvailable = false;

    public ClientTrustManagerFactory() {
        try {
            this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keystore.load(null, EMPTY_PASS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers.toArray(new X509Certificate[0]);
    }

    public TrustManager[] getManager(XMPPIOService<Object> serv) {
        return this.isActive() ? this.trustWrapper : null;
    }

    public boolean isActive() {
        return this.acceptedIssuers.size() > 0;
    }

    protected void loadTrustedCert(String caCertFile) {
        try {
            CertificateEntry certEntry = CertificateUtil.loadCertificate(caCertFile);
            Certificate[] chain = certEntry.getCertChain();
            if (chain != null) {
                for (Certificate cert : chain) {
                    if (!(cert instanceof X509Certificate)) continue;
                    X509Certificate crt = (X509Certificate)cert;
                    String alias = crt.getSubjectX500Principal().getName();
                    this.keystore.setCertificateEntry(alias, crt);
                    this.acceptedIssuers.add(crt);
                }
            }
            this.tmf.init(this.keystore);
            TrustManager[] trustManagers = this.tmf.getTrustManagers();
            this.trustManager = (X509TrustManager)trustManagers[0];
            this.saslExternalAvailable = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey(CA_CERT_PATH)) {
            this.loadTrustedCert((String)props.get(CA_CERT_PATH));
        }
    }

    public boolean isSaslExternalAvailable() {
        return this.saslExternalAvailable;
    }
}

