/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.test;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class TestComponent
extends AbstractMessageReceiver {
    private static final String ABUSE_ADDRESS_KEY = "abuse-address";
    private static final String BAD_WORDS_KEY = "bad-words";
    private static final String BAD_WORDS_VAR = "badWords";
    private static final String[] INITIAL_BAD_WORDS = new String[]{"word1", "word2", "word3"};
    private static final String[] INITIAL_WHITE_LIST = new String[]{"admin@localhost"};
    private static final String NOTIFICATION_FREQ_KEY = "notification-freq";
    private static final String PREPEND_TEXT_KEY = "log-prepend";
    private static final String SECURE_LOGGING_KEY = "secure-logging";
    private static final String WHITE_LIST_VAR = "whiteList";
    private static final String WHITELIST_KEY = "white-list";
    private static final Logger log = Logger.getLogger(TestComponent.class.getName());
    private JID abuseAddress = null;
    private Set<String> badWords = new CopyOnWriteArraySet<String>();
    private int delayCounter = 0;
    private long messagesCounter = 0L;
    private int notificationFrequency = 10;
    private String prependText = "Spam detected: ";
    private long spamCounter = 0L;
    private long totalSpamCounter = 0L;
    private Set<String> whiteList = new ConcurrentSkipListSet<String>();
    private boolean secureLogging = false;

    @Override
    public synchronized void everyMinute() {
        super.everyMinute();
        if (++this.delayCounter >= this.notificationFrequency) {
            this.addOutPacket(Message.getMessage(this.getComponentId(), this.abuseAddress, StanzaType.chat, "Detected spam messages: " + this.spamCounter, "Spam counter", null, this.newPacketId("spam-")));
            this.delayCounter = 0;
            this.spamCounter = 0L;
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        Collections.addAll(this.badWords, INITIAL_BAD_WORDS);
        Collections.addAll(this.whiteList, INITIAL_WHITE_LIST);
        defs.put(BAD_WORDS_KEY, INITIAL_BAD_WORDS);
        defs.put(WHITELIST_KEY, INITIAL_WHITE_LIST);
        defs.put(PREPEND_TEXT_KEY, this.prependText);
        defs.put(SECURE_LOGGING_KEY, this.secureLogging);
        defs.put(ABUSE_ADDRESS_KEY, "admin@localhost");
        defs.put(NOTIFICATION_FREQ_KEY, this.notificationFrequency);
        return defs;
    }

    @Override
    public String getDiscoCategoryType() {
        return "spam";
    }

    @Override
    public String getDiscoDescription() {
        return "Spam filtering";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Spam messages found", this.totalSpamCounter, Level.INFO);
        list.add(this.getName(), "All messages processed", this.messagesCounter, Level.FINE);
        if (list.checkLevel(Level.FINEST)) {
            // empty if block
        }
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        if (packet.getStanzaFrom() != null) {
            return packet.getStanzaFrom().hashCode();
        }
        return 1;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(BAD_WORDS_VAR, (Object)this.badWords);
        binds.put(WHITE_LIST_VAR, (Object)this.whiteList);
    }

    @Override
    public void processPacket(Packet packet) {
        if ("message" == packet.getElemName()) {
            String body;
            this.updateServiceDiscoveryItem(this.getName(), "messages", "Messages processed: [" + ++this.messagesCounter + "]", true);
            JID from = packet.getStanzaFrom();
            if (!this.whiteList.contains(from.getBareJID().toString()) && (body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH)) != null && !body.isEmpty()) {
                body = body.toLowerCase();
                for (String word : this.badWords) {
                    if (!body.contains(word)) continue;
                    log.finest(this.prependText + packet.toString(this.secureLogging));
                    ++this.spamCounter;
                    this.updateServiceDiscoveryItem(this.getName(), "spam", "Spam caught: [" + ++this.totalSpamCounter + "]", true);
                    return;
                }
            }
        }
        Packet result = packet.swapStanzaFromTo();
        this.addOutPacket(result);
    }

    @Override
    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        Collections.addAll(this.badWords, (String[])props.get(BAD_WORDS_KEY));
        Collections.addAll(this.whiteList, (String[])props.get(WHITELIST_KEY));
        this.prependText = (String)props.get(PREPEND_TEXT_KEY);
        this.secureLogging = (Boolean)props.get(SECURE_LOGGING_KEY);
        try {
            this.abuseAddress = JID.jidInstance((String)props.get(ABUSE_ADDRESS_KEY));
        }
        catch (TigaseStringprepException ex) {
            log.warning("Incorrect abuseAddress, stringprep error: " + (String)props.get(ABUSE_ADDRESS_KEY));
        }
        this.notificationFrequency = (Integer)props.get(NOTIFICATION_FREQ_KEY);
        this.updateServiceDiscoveryItem(this.getName(), null, this.getDiscoDescription(), "automation", "spam-filtering", true, "tigase:x:spam-filter", "tigase:x:spam-reporting");
    }
}

