/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class MobileV2
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPacketFilterIfc {
    private static final int DEF_MAX_QUEUE_SIZE_VAL = 50;
    private static final String ID = "mobile_v2";
    private static final Logger log = Logger.getLogger(MobileV2.class.getCanonicalName());
    private static final String MAX_QUEUE_SIZE_KEY = "max-queue-size";
    private static final String MOBILE_EL_NAME = "mobile";
    private static final String XMLNS = "http://tigase.org/protocol/mobile#v2";
    private static final String[][] ELEMENT_PATHS = new String[][]{{"iq", "mobile"}};
    private static final String[] XMLNSS = new String[]{"http://tigase.org/protocol/mobile#v2"};
    private static final Element[] SUP_FEATURES = new Element[]{new Element("mobile", new String[]{"xmlns"}, new String[]{"http://tigase.org/protocol/mobile#v2"})};
    private static final String QUEUE_KEY = "mobile_v2-queue";
    private int maxQueueSize = 50;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        Integer maxQueueSizeVal = (Integer)settings.get(MAX_QUEUE_SIZE_KEY);
        if (maxQueueSizeVal != null) {
            this.maxQueueSize = maxQueueSizeVal;
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            try {
                results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "ignoring packet from not authorized session which is already of type error");
            }
            return;
        }
        try {
            StanzaType type = packet.getType();
            switch (type) {
                case set: {
                    boolean value;
                    Element el = packet.getElement().getChild(MOBILE_EL_NAME);
                    String valueStr = el.getAttributeStaticStr("enable");
                    boolean bl = value = valueStr != null && ("true".equals(valueStr) || "1".equals(valueStr));
                    if (session.getSessionData(QUEUE_KEY) == null) {
                        session.putSessionData(QUEUE_KEY, new ConcurrentHashMap());
                    }
                    session.putSessionData(XMLNS, value);
                    results.offer(packet.okResult((Element)null, 0));
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Mobile processing type is incorrect", false));
                    break;
                }
            }
        }
        catch (PacketErrorTypeException ex) {
            Logger.getLogger(MobileV2.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null) {
            return null;
        }
        if (!session.isAuthorized()) {
            return null;
        }
        return SUP_FEATURES;
    }

    @Override
    public void filter(Packet _packet, XMPPResourceConnection sessionFromSM, NonAuthUserRepository repo, Queue<Packet> results) {
        if (sessionFromSM == null || !sessionFromSM.isAuthorized() || results == null || results.size() == 0) {
            return;
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Packet res = (Packet)it.next();
            if (res == null || res.getPacketTo() == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("packet without destination");
                continue;
            }
            XMPPResourceConnection session = sessionFromSM.getParentSession().getResourceForConnectionId(res.getPacketTo());
            if (session == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "no session for destination {0} for packet {1}", new Object[]{res.getPacketTo().toString(), res.toString()});
                continue;
            }
            Map queue = (Map)session.getSessionData(QUEUE_KEY);
            if (!this.isQueueEnabled(session)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("queue is no enabled");
                }
                if (queue == null || queue.isEmpty()) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("sending packets from queue (DISABLED)");
                }
                for (Packet p : queue.values()) {
                    results.offer(p);
                }
                queue.clear();
                continue;
            }
            if (!this.filter(session, res, queue)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "queuing packet = {0}", res.toString());
            }
            it.remove();
            if (queue.size() <= this.maxQueueSize) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("sending packets from queue (OVERFLOW)");
            }
            for (Packet p : queue.values()) {
                results.offer(res);
            }
            queue.clear();
            break;
        }
    }

    public boolean filter(XMPPResourceConnection session, Packet res, Map<JID, Packet> queue) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "checking if packet should be queued {0}", res.toString());
        }
        if (res.getElemName() != "presence") {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "ignoring packet, packet is not presence:  {0}", res.toString());
            }
            return false;
        }
        StanzaType type = res.getType();
        if (type != null && type != StanzaType.unavailable && type != StanzaType.available) {
            return false;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "queuing packet {0}", res.toString());
        }
        queue.put(res.getStanzaFrom(), res);
        return true;
    }

    protected boolean isQueueEnabled(XMPPResourceConnection session) {
        Boolean enabled = (Boolean)session.getSessionData(XMLNS);
        return enabled != null && enabled != false;
    }
}

