/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;
import tigase.util.DNSEntry;
import tigase.util.DNSResolver;

public class PacketChecker
extends S2SAbstractProcessor {
    private static final Logger log = Logger.getLogger(PacketChecker.class.getName());
    private static final String ALLOW_PACKETS_FROM_OTHER_DOMAINS_MAP_KEY = "allow-packets-from-other-domains-map";
    private static final String ALLOW_PACKETS_FROM_OTHER_DOMAINS_WITH_SAME_IP_KEY = "allow-packets-from-other-domains-with-same-ip";
    private static final String ALLOW_PACKETS_FROM_OTHER_DOMAINS_WITH_SAME_IP_WHITELIST_KEY = "allow-packets-from-other-domains-with-same-ip-whitelist";
    private Map<String, String[]> allowedOtherDomainsMap = new ConcurrentHashMap<String, String[]>();
    private boolean allowOtherDomainsWithSameIp = false;
    private String[] allowedOtherDomainsWithSameIpWhitelist = null;

    @Override
    public void init(S2SConnectionHandlerIfc<S2SIOService> handler, Map<String, Object> props) {
        String allowedOtherDomainsWhitelistStr;
        super.init(handler, props);
        String allowOtherDomainsStr = (String)props.get(ALLOW_PACKETS_FROM_OTHER_DOMAINS_WITH_SAME_IP_KEY);
        if (allowOtherDomainsStr != null) {
            this.allowOtherDomainsWithSameIp = Boolean.parseBoolean(allowOtherDomainsStr);
        }
        if ((allowedOtherDomainsWhitelistStr = (String)props.get(ALLOW_PACKETS_FROM_OTHER_DOMAINS_WITH_SAME_IP_WHITELIST_KEY)) != null) {
            this.allowedOtherDomainsWithSameIpWhitelist = allowedOtherDomainsWhitelistStr.split(",");
            Arrays.sort(this.allowedOtherDomainsWithSameIpWhitelist);
        } else {
            this.allowedOtherDomainsWithSameIpWhitelist = new String[0];
        }
        String allowedOtherDomainsMapStr = (String)props.get(ALLOW_PACKETS_FROM_OTHER_DOMAINS_MAP_KEY);
        this.allowedOtherDomainsMap.clear();
        if (allowedOtherDomainsMapStr != null) {
            for (String listOfDomainsStr : allowedOtherDomainsMapStr.split(",")) {
                Object[] listOfDomains = listOfDomainsStr.split(":");
                Arrays.sort(listOfDomains);
                for (int i = 0; i < listOfDomains.length; ++i) {
                    this.allowedOtherDomainsMap.put((String)listOfDomains[i], (String[])listOfDomains);
                }
            }
        }
    }

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        if (p.getXMLNS() == "jabber:server" || p.getXMLNS() == "jabber:client") {
            if (p.getStanzaFrom() == null || p.getStanzaFrom().getDomain().trim().isEmpty() || p.getStanzaTo() == null || p.getStanzaTo().getDomain().trim().isEmpty()) {
                this.generateStreamError(false, "improper-addressing", serv);
                return true;
            }
            CID cid = new CID(p.getStanzaTo().getDomain(), p.getStanzaFrom().getDomain());
            if (!this.isAllowed(p, serv, cid)) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "{0}, Invalid hostname from the remote server for packet: {1}, authenticated domains for this connection: {2}", new Object[]{serv, p, serv.getCIDs()});
                }
                this.generateStreamError(false, "invalid-from", serv);
                return true;
            }
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "{0}, Invalid namespace for packet: {1}", new Object[]{serv, p});
            }
            this.generateStreamError(false, "invalid-namespace", serv);
            return true;
        }
        return false;
    }

    protected boolean isAllowed(Packet p, S2SIOService serv, CID cid) {
        boolean allowed;
        block7: {
            allowed = serv.isAuthenticated(cid);
            if (!allowed && serv.isAuthenticated()) {
                String domain = p.getStanzaFrom().getDomain();
                Object[] allowedOtherDomainsMapValue = this.allowedOtherDomainsMap.get(domain);
                if (allowedOtherDomainsMapValue != null) {
                    ArrayList<CID> authenticatedCids = new ArrayList<CID>(serv.getCIDs());
                    for (CID acid : authenticatedCids) {
                        if (Arrays.binarySearch(allowedOtherDomainsMapValue, acid.getRemoteHost()) < 0) continue;
                        serv.addCID(cid);
                        allowed = true;
                        break;
                    }
                }
                if (!allowed && this.allowOtherDomainsWithSameIp && (this.allowedOtherDomainsWithSameIpWhitelist.length == 0 || Arrays.binarySearch(this.allowedOtherDomainsWithSameIpWhitelist, domain) >= 0)) {
                    try {
                        DNSEntry[] entries = DNSResolver.getHostSRV_Entries(domain);
                        if (entries == null) break block7;
                        String remoteAddress = serv.getRemoteAddress();
                        for (DNSEntry entry : entries) {
                            if (!remoteAddress.equals(entry.getIp())) continue;
                            serv.addCID(cid);
                            allowed = true;
                            break;
                        }
                    }
                    catch (UnknownHostException ex) {
                        log.log(Level.FINE, "Unknown host for domain: {0}", domain);
                    }
                }
            }
        }
        return allowed;
    }
}

