/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.Base64;
import tigase.xmpp.XMPPIOService;

public class WebSocketXMPPIOService<RefObject>
extends XMPPIOService<RefObject> {
    private static final String BAD_REQUEST = "HTTP/1.0 400 Bad request\r\n\r\n";
    private static final String CONNECTION_KEY = "Connection";
    private static final String GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String HOST_KEY = "Host";
    private static final Logger log = Logger.getLogger(WebSocketXMPPIOService.class.getCanonicalName());
    private static final String ORIGIN_KEY = "Origin";
    private static final String RESPONSE_HEADER = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nAccess-Control-Allow-Origin: *\r\nAccess-Control-Allow-Methods: GET, POST, OPTIONS\r\nAccess-Control-Allow-Headers: Content-Type\r\nAccess-Control-Max-Age: 86400\r\n";
    private static final String WS_ACCEPT_KEY = "Sec-WebSocket-Accept";
    private static final String WS_KEY_KEY = "Sec-WebSocket-Key";
    private static final String WS_PROTOCOL_KEY = "Sec-WebSocket-Protocol";
    private static final String WS_VERSION_KEY = "Sec-WebSocket-Version";
    private byte[] buf = null;
    private long frameLength = -1L;
    private byte[] maskingKey = null;
    private int pos = 0;
    private int version = 0;
    private byte[] partialFrame = null;
    private boolean websocket = false;
    private boolean started = false;

    @Override
    protected char[] readData() throws IOException {
        ByteBuffer cb = super.readBytes();
        if (cb == null) {
            return null;
        }
        if (this.websocket) {
            if (this.partialFrame != null) {
                ByteBuffer oldtmp = cb;
                cb = ByteBuffer.allocate(this.partialFrame.length + oldtmp.remaining());
                cb.order(oldtmp.order());
                cb.put(this.partialFrame);
                cb.put(oldtmp);
                cb.flip();
                oldtmp.clear();
                this.partialFrame = null;
            }
            ByteBuffer tmp = ByteBuffer.allocate(cb.remaining());
            ByteBuffer decoded = null;
            while (cb.hasRemaining() && (decoded = this.decodeFrame(cb)) != null) {
                if (decoded == null || !decoded.hasRemaining()) continue;
                tmp.put(decoded);
            }
            if (cb.hasRemaining()) {
                this.partialFrame = new byte[cb.remaining()];
                cb.get(this.partialFrame);
            }
            cb.compact();
            if (tmp.capacity() > 0) {
                tmp.flip();
            }
            cb = tmp;
        }
        if (this.started) {
            return this.decode(cb);
        }
        if (!cb.hasRemaining()) {
            return null;
        }
        if (this.pos == 0 && cb.get(0) != 71) {
            this.started = true;
            return this.decode(cb);
        }
        if (this.buf == null) {
            this.buf = new byte[1024];
        }
        try {
            int read = cb.remaining();
            cb.get(this.buf, this.pos, read);
            this.pos += read;
            cb.compact();
            if (this.pos > 100 && (this.buf[this.pos - 1] == 10 && this.buf[this.pos - 1] == this.buf[this.pos - 3] || this.buf[this.pos - 9] == 10 && this.buf[this.pos - 9] == this.buf[this.pos - 11])) {
                this.started = true;
                this.processWebSocketHandshake();
                this.websocket = true;
                this.buf = null;
            }
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "exception processing websocket handshake", ex);
            }
            this.forceStop();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeData(String data) {
        block12: {
            boolean locked = this.writeInProgress.tryLock();
            if (!locked) {
                if (data == null) {
                    return;
                }
                this.writeInProgress.lock();
            }
            try {
                if (this.websocket) {
                    try {
                        if (data != null) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "sending data = {0}", data);
                            }
                            ByteBuffer buf = this.encode(data);
                            int size = buf.remaining();
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "sending encoded data size = {0}", size);
                            }
                            ByteBuffer bbuf = this.createFrameHeader((byte)-127, size);
                            this.writeBytes(bbuf);
                            this.writeBytes(buf);
                            break block12;
                        }
                        this.writeBytes(null);
                    }
                    catch (Exception ex) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "exception writing data", ex);
                        }
                        this.forceStop();
                    }
                    break block12;
                }
                super.writeData(data);
            }
            finally {
                this.writeInProgress.unlock();
            }
        }
    }

    private void processWebSocketHandshake() throws NoSuchAlgorithmException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        int i = 0;
        while (this.buf[i] != 10) {
            ++i;
        }
        ++i;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "parsing request = \n{0}", new String(this.buf));
        }
        StringBuilder builder = new StringBuilder(64);
        String key = null;
        while (i < this.pos) {
            switch (this.buf[i]) {
                case 58: {
                    if (key == null) {
                        key = builder.toString();
                        builder = new StringBuilder(64);
                        ++i;
                        break;
                    }
                    builder.append((char)this.buf[i]);
                    break;
                }
                case 13: {
                    headers.put(key, builder.toString());
                    key = null;
                    builder = new StringBuilder(64);
                    if (this.buf[i + 2] == 13) {
                        i += 3;
                        break;
                    }
                    ++i;
                    break;
                }
                default: {
                    builder.append((char)this.buf[i]);
                }
            }
            ++i;
        }
        if (!headers.containsKey(CONNECTION_KEY) || !((String)headers.get(CONNECTION_KEY)).contains("Upgrade")) {
            this.writeRawData(BAD_REQUEST);
            this.dumpHeaders(headers);
            return;
        }
        if (!headers.containsKey(WS_PROTOCOL_KEY) || !headers.get(WS_PROTOCOL_KEY).contains("xmpp")) {
            this.writeRawData(BAD_REQUEST);
            this.dumpHeaders(headers);
            return;
        }
        StringBuilder response = new StringBuilder(RESPONSE_HEADER.length() * 2);
        response.append(RESPONSE_HEADER);
        if (headers.containsKey(WS_VERSION_KEY)) {
            this.version = Integer.parseInt(headers.get(WS_VERSION_KEY));
            key = headers.get(WS_KEY_KEY) + GUID;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] resp = md.digest(key.getBytes());
            response.append(WS_PROTOCOL_KEY);
            response.append(": xmpp\r\n");
            response.append("Sec-WebSocket-Accept: ");
            response.append(Base64.encode(resp));
            response.append("\r\n");
            response.append("\r\n");
            this.maskingKey = new byte[4];
            this.writeRawData(response.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer decodeFrame(ByteBuffer buf) {
        byte[] data;
        if (!buf.hasRemaining()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("no content remainging to process");
            }
            return null;
        }
        boolean masked = false;
        byte type = 0;
        int position = buf.position();
        if (this.frameLength == -1L) {
            type = buf.get();
            if ((type & 8) == 8) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("closing connection due to client request");
                }
                this.forceStop();
                return null;
            }
            byte b2 = buf.get();
            masked = (b2 & 0x80) == 128;
            this.frameLength = b2 & 0x7F;
            if (this.frameLength > 125L) {
                long l = this.frameLength = this.frameLength == 126L ? (long)buf.getShort() : buf.getLong();
            }
            if (masked) {
                buf.get(this.maskingKey);
            }
        }
        ByteBuffer unmasked = null;
        if ((long)buf.remaining() >= this.frameLength) {
            data = new byte[(int)this.frameLength];
            buf.get(data);
            if (masked) {
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (byte)(data[i] ^ this.maskingKey[i % 4]);
                }
            }
        } else {
            buf.position(position);
            this.frameLength = -1L;
            return null;
        }
        unmasked = ByteBuffer.wrap(data);
        this.frameLength = -1L;
        if (this.frameLength == -1L) {
            if ((type & 0xA) == 10) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("ignoring pong frame");
                }
                unmasked = null;
            } else if ((type & 9) == 9) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("sending response on ping frame");
                }
                type = (byte)((byte)(type ^ 9) | 0xA);
                try {
                    ByteBuffer header = this.createFrameHeader(type, unmasked.remaining());
                    this.writeInProgress.lock();
                    this.writeBytes(header);
                    this.writeBytes(unmasked);
                }
                finally {
                    this.writeInProgress.unlock();
                }
                unmasked = null;
            }
        }
        return unmasked;
    }

    private ByteBuffer createFrameHeader(byte type, int size) {
        ByteBuffer bbuf = ByteBuffer.allocate(12);
        bbuf.put(type);
        if (size <= 125) {
            bbuf.put((byte)size);
        } else if (size <= 65535) {
            bbuf.put((byte)126);
            bbuf.putShort((short)size);
        } else {
            bbuf.put((byte)127);
            bbuf.putLong(size);
        }
        bbuf.flip();
        return bbuf;
    }

    private char[] decode(ByteBuffer tmpBuffer) throws MalformedInputException {
        CoderResult cr;
        if (tmpBuffer == null) {
            return null;
        }
        char[] result = null;
        if (this.partialCharacterBytes != null) {
            ByteBuffer oldTmpBuffer = tmpBuffer;
            tmpBuffer = ByteBuffer.allocate(this.partialCharacterBytes.length + oldTmpBuffer.remaining() + 2);
            tmpBuffer.put(this.partialCharacterBytes);
            tmpBuffer.put(oldTmpBuffer);
            tmpBuffer.flip();
            oldTmpBuffer.clear();
            this.partialCharacterBytes = null;
        }
        if (this.cb.capacity() < tmpBuffer.remaining() * 4) {
            this.cb = CharBuffer.allocate(tmpBuffer.remaining() * 4);
        }
        if ((cr = this.decoder.decode(tmpBuffer, this.cb, false)).isMalformed()) {
            throw new MalformedInputException(tmpBuffer.remaining());
        }
        if (this.cb.remaining() > 0) {
            this.cb.flip();
            result = new char[this.cb.remaining()];
            this.cb.get(result);
        }
        if (cr.isUnderflow() && tmpBuffer.remaining() > 0) {
            this.partialCharacterBytes = new byte[tmpBuffer.remaining()];
            tmpBuffer.get(this.partialCharacterBytes);
        }
        tmpBuffer.clear();
        this.cb.clear();
        return result;
    }

    private ByteBuffer encode(String data) throws CharacterCodingException {
        ByteBuffer dataBuffer = null;
        this.encoder.reset();
        dataBuffer = this.encoder.encode(CharBuffer.wrap(data));
        this.encoder.flush(dataBuffer);
        return dataBuffer;
    }

    public void dumpHeaders(Map<String, String> headers) {
        if (log.isLoggable(Level.FINEST)) {
            StringBuilder builder = new StringBuilder(1000);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.append("KEY = ");
                builder.append(entry.getKey());
                builder.append("VALUE = ");
                builder.append(entry.getValue());
                builder.append('\n');
            }
            log.log(Level.FINEST, "received headers = \n{0}", builder.toString());
        }
    }
}

