/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.migration;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfiguratorAbstract;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.migration.IPubSubOldDAO;
import tigase.pubsub.repository.migration.PubSubNewDAOJDBC;
import tigase.pubsub.repository.migration.PubSubOldDAO;
import tigase.pubsub.repository.migration.PubSubOldDAOJDBC;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xmpp.BareJID;

public class Converter {
    private static final Logger log = Logger.getLogger(Converter.class.getCanonicalName());
    private IPubSubOldDAO oldRepo;
    private PubSubNewDAOJDBC newRepo;

    public static void main(String[] argv) throws RepositoryException, IOException {
        Converter.initLogger();
        if (argv == null || argv.length == 0) {
            System.out.println("\nConverter paramters:\n");
            System.out.println(" -in-repo-class tigase.pubsub.PubSubDAO                                     -\t\tclass of source repository");
            System.out.println(" -in 'jdbc:xxxx://localhost/tigasedb?user=tigase&password=tigase_pass'      -\t\turi of source database");
            System.out.println(" -out 'jdbc:xxxx://localhost/tigasedb?user=tigase&password=tigase_pass'     -\t\turi of destination database");
            return;
        }
        Converter converter = new Converter();
        log.config("parsing configuration parameters");
        String repoClass = null;
        String oldRepoUri = null;
        String newRepoUri = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if ("-in".equals(arg)) {
                oldRepoUri = argv[++i];
                continue;
            }
            if ("-out".equals(arg)) {
                newRepoUri = argv[++i];
                continue;
            }
            if (!"-in-repo-class".equals(arg)) continue;
            repoClass = argv[++i];
        }
        log.config("initializing converter");
        converter.init(repoClass, oldRepoUri, newRepoUri);
        log.info("starting migration");
        converter.convert();
        log.info("migration finished");
    }

    public void init(String repoClass, String oldRepoUri, String newRepoUri) throws RepositoryException {
        try {
            String repoCls = null;
            if (oldRepoUri.contains(":mysql:")) {
                repoCls = "mysql";
            } else if (oldRepoUri.contains(":postgresql:")) {
                repoCls = "pgsql";
            } else if (oldRepoUri.contains(":derby:")) {
                repoCls = "derby";
            } else if (oldRepoUri.contains(":sqlserver:")) {
                repoCls = "sqlserver";
            }
            if (repoClass == null || repoClass.endsWith("PubSubDAO")) {
                UserRepository userRepository = RepositoryFactory.getUserRepository((String)repoCls, (String)oldRepoUri, null);
                this.oldRepo = new PubSubOldDAO(userRepository);
            } else {
                this.oldRepo = new PubSubOldDAOJDBC(repoCls, oldRepoUri);
            }
            log.log(Level.FINE, "initializing source repository {0} for uri {1}", new Object[]{this.oldRepo.getClass().getCanonicalName(), oldRepoUri});
            this.oldRepo.init();
            this.newRepo = new PubSubNewDAOJDBC(newRepoUri);
            log.log(Level.INFO, "initializing destination repository {0} for uri {1}", new Object[]{this.newRepo.getClass().getCanonicalName(), newRepoUri});
            this.newRepo.init();
        }
        catch (Exception ex) {
            throw new RepositoryException("could not initialize converter", ex);
        }
    }

    public static void initLogger() {
        String initial_config = "tigase.level=ALL\ntigase.db.jdbc.level=INFO\ntigase.xml.level=INFO\ntigase.form.level=INFO\nhandlers=java.util.logging.ConsoleHandler java.util.logging.FileHandler\njava.util.logging.ConsoleHandler.level=ALL\njava.util.logging.ConsoleHandler.formatter=tigase.util.LogFormatter\njava.util.logging.FileHandler.formatter=tigase.util.LogFormatter\njava.util.logging.FileHandler.pattern=pubsub_db_migration.log\ntigase.useParentHandlers=true\n";
        ConfiguratorAbstract.loadLogManagerConfig((String)initial_config);
    }

    public void convert() throws RepositoryException {
        BareJID[] serviceJids;
        for (BareJID serviceJid : serviceJids = this.oldRepo.getServiceJids()) {
            String[] allNodesIds = this.oldRepo.getNodesList(serviceJid);
            if (allNodesIds == null || allNodesIds.length == 0) continue;
            log.log(Level.INFO, "starting migration for {0}", serviceJid.toString());
            this.convertNodesConfigurations(serviceJid, allNodesIds);
            this.convertNodesAffiliations(serviceJid, allNodesIds);
            this.convertNodesSubscriptions(serviceJid, allNodesIds);
            this.convertNodesItems(serviceJid, allNodesIds);
            log.log(Level.INFO, "migration for {0} finished", serviceJid.toString());
        }
    }

    private void convertNodesConfigurations(BareJID serviceJid, String[] allNodesIds) throws RepositoryException {
        String nodeName;
        AbstractNodeConfig nodeConfig;
        log.log(Level.INFO, "loading nodes configurations for {0}", serviceJid.toString());
        HashSet<String> rootCollection = new HashSet<String>();
        HashMap<String, AbstractNodeConfig> nodeConfigs = new HashMap<String, AbstractNodeConfig>();
        for (String nodeName2 : allNodesIds) {
            AbstractNodeConfig nodeConfig2 = this.oldRepo.getNodeConfig(serviceJid, nodeName2);
            if (nodeConfig2 == null) continue;
            nodeConfigs.put(nodeName2, nodeConfig2);
            if (!(nodeConfig2 instanceof CollectionNodeConfig)) continue;
            CollectionNodeConfig collectionNodeConfig = (CollectionNodeConfig)nodeConfig2;
            collectionNodeConfig.setChildren(null);
        }
        for (Map.Entry entry : nodeConfigs.entrySet()) {
            String nodeName2;
            AbstractNodeConfig nodeConfig3 = (AbstractNodeConfig)entry.getValue();
            nodeName2 = (String)entry.getKey();
            String collectionNodeName = nodeConfig3.getCollection();
            if (collectionNodeName == null || collectionNodeName.equals("")) {
                nodeConfig3.setCollection("");
                rootCollection.add(nodeName2);
                continue;
            }
            AbstractNodeConfig potentialParent = (AbstractNodeConfig)nodeConfigs.get(collectionNodeName);
            if (potentialParent != null && potentialParent instanceof CollectionNodeConfig) {
                CollectionNodeConfig collectionConfig = (CollectionNodeConfig)potentialParent;
                collectionConfig.addChildren(nodeName2);
                continue;
            }
            nodeConfig3.setCollection("");
            rootCollection.add(nodeName2);
        }
        log.log(Level.INFO, "creating nodes in new store for {0}", serviceJid.toString());
        HashMap<String, Long> nodeIds = new HashMap<String, Long>();
        for (Map.Entry entry : nodeConfigs.entrySet()) {
            nodeConfig = (AbstractNodeConfig)entry.getValue();
            nodeName = (String)entry.getKey();
            long nodeId = this.newRepo.getNodeId(serviceJid, nodeName);
            if (nodeId != 0L) {
                nodeIds.put(nodeName, nodeId);
                continue;
            }
            BareJID owner = this.oldRepo.getNodeCreator(serviceJid, nodeName);
            long collectionId = this.newRepo.getNodeId(serviceJid, nodeConfig.getCollection());
            nodeId = this.newRepo.createNode(serviceJid, nodeName, owner, nodeConfig, nodeConfig.getNodeType(), collectionId == 0L ? null : Long.valueOf(collectionId));
            nodeIds.put(nodeName, nodeId);
        }
        log.log(Level.INFO, "fixing nodes metadata in new store for {0}", serviceJid.toString());
        for (Map.Entry entry : nodeConfigs.entrySet()) {
            nodeConfig = (AbstractNodeConfig)entry.getValue();
            nodeName = (String)entry.getKey();
            Long nodeId = (Long)nodeIds.get(nodeName);
            Long collectionId = (Long)nodeIds.get(nodeConfig.getCollection());
            this.newRepo.updateNodeConfig(serviceJid, nodeId, nodeConfig.getFormElement().toString(), collectionId);
            Date nodeCreationDate = this.oldRepo.getNodeCreationDate(serviceJid, nodeName);
            this.newRepo.fixNode(serviceJid, nodeId, nodeCreationDate);
        }
    }

    private void convertNodesAffiliations(BareJID serviceJid, String[] nodesIds) throws RepositoryException {
        log.log(Level.INFO, "migrating nodes affiliations for {0}", serviceJid.toString());
        for (String nodeName : nodesIds) {
            UsersAffiliation[] affiliations;
            long nodeId = this.newRepo.getNodeId(serviceJid, nodeName);
            for (UsersAffiliation aff : affiliations = this.oldRepo.getNodeAffiliations(serviceJid, nodeName)) {
                this.newRepo.updateNodeAffiliation(serviceJid, nodeId, aff);
            }
        }
    }

    private void convertNodesSubscriptions(BareJID serviceJid, String[] nodesIds) throws RepositoryException {
        log.log(Level.INFO, "migrating nodes subscriptions for {0}", serviceJid.toString());
        for (String nodeName : nodesIds) {
            UsersSubscription[] subscription;
            long nodeId = this.newRepo.getNodeId(serviceJid, nodeName);
            for (UsersSubscription subscr : subscription = this.oldRepo.getNodeSubscriptions(serviceJid, nodeName)) {
                this.newRepo.updateNodeSubscription(serviceJid, nodeId, subscr);
            }
        }
    }

    private void convertNodesItems(BareJID serviceJid, String[] nodesIds) throws RepositoryException {
        log.log(Level.INFO, "migrating nodes items for {0}", serviceJid.toString());
        for (String nodeName : nodesIds) {
            String[] itemIds = this.oldRepo.getItemsIds(serviceJid, nodeName);
            if (itemIds == null || itemIds.length == 0) continue;
            long nodeId = this.newRepo.getNodeId(serviceJid, nodeName);
            for (String id : itemIds) {
                IPubSubOldDAO.Item item = this.oldRepo.getItem(serviceJid, nodeName, id);
                this.newRepo.writeItem(serviceJid, nodeId, 0L, item.publisher, id, item.item);
                this.newRepo.fixItem(serviceJid, nodeId, item.id, item.creationDate, item.updateDate);
            }
        }
    }
}

