/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class RetrieveItemsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"items"));
    private static final Comparator<IItems.ItemMeta> itemsCreationDateComparator = new Comparator<IItems.ItemMeta>(){

        @Override
        public int compare(IItems.ItemMeta o1, IItems.ItemMeta o2) {
            return o1.getCreationDate().compareTo(o2.getCreationDate()) * -1;
        }
    };

    public RetrieveItemsModule(PubSubConfig config, PacketWriter packetWriter) {
        super(config, packetWriter);
    }

    private Integer asInteger(String attribute) {
        if (attribute == null) {
            return null;
        }
        return Integer.parseInt(attribute);
    }

    private List<String> extractItemsIds(Element items) throws PubSubException {
        List il = items.getChildren();
        if (il == null || il.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Element i : il) {
            String id = i.getAttributeStaticStr("id");
            if (!"item".equals(i.getName()) || id == null) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            result.add(id);
        }
        return result;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-items"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            String[] ids;
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element pubsub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element items = pubsub.getChild("items");
            String nodeName = items.getAttributeStaticStr("node");
            JID senderJid = packet.getStanzaFrom();
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            this.checkPermission(senderJid, toJid, nodeName, nodeConfig);
            if (nodeConfig instanceof CollectionNodeConfig) {
                ArrayList<IItems.ItemMeta> itemsMeta = new ArrayList<IItems.ItemMeta>();
                String[] childNodes = nodeConfig.getChildren();
                HashMap<String, IItems> nodeItemsCache = new HashMap<String, IItems>();
                if (childNodes != null) {
                    for (String childNodeName : childNodes) {
                        LeafNodeConfig leafChildNode;
                        AbstractNodeConfig childNode = this.getRepository().getNodeConfig(toJid, childNodeName);
                        if (childNode == null || childNode.getNodeType() != NodeType.leaf || !(leafChildNode = (LeafNodeConfig)childNode).isPersistItem()) continue;
                        try {
                            this.checkPermission(senderJid, toJid, childNodeName, childNode);
                            IItems childNodeItems = this.getRepository().getNodeItems(toJid, childNodeName);
                            nodeItemsCache.put(childNodeName, childNodeItems);
                            itemsMeta.addAll(childNodeItems.getItemsMeta());
                        }
                        catch (PubSubException ex) {
                            // empty catch block
                        }
                    }
                }
                Collections.sort(itemsMeta, itemsCreationDateComparator);
                Element rpubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
                Packet iq = packet.okResult(rpubsub, 0);
                Integer maxItems = this.asInteger(items.getAttributeStaticStr("max_items"));
                Integer offset = 0;
                Element rsmGet = pubsub.getChild("set", "http://jabber.org/protocol/rsm");
                if (rsmGet != null) {
                    Element m = rsmGet.getChild("max");
                    if (m != null) {
                        maxItems = this.asInteger(m.getCData());
                    }
                    if ((m = rsmGet.getChild("index")) != null) {
                        offset = this.asInteger(m.getCData());
                    }
                }
                HashMap nodeItemsElMap = new HashMap();
                int idx = offset;
                String lastId = null;
                for (int count = 0; itemsMeta.size() > idx && (maxItems == null || count < maxItems); ++idx, ++count) {
                    IItems.ItemMeta itemMeta = (IItems.ItemMeta)itemsMeta.get(idx);
                    String node = itemMeta.getNode();
                    ArrayList<Element> nodeItemsElems = (ArrayList<Element>)nodeItemsElMap.get(node);
                    if (nodeItemsElems == null) {
                        nodeItemsElems = new ArrayList<Element>();
                        nodeItemsElMap.put(node, nodeItemsElems);
                    }
                    IItems nodeItems = (IItems)nodeItemsCache.get(node);
                    Element item = nodeItems.getItem(itemMeta.getId());
                    lastId = itemMeta.getId();
                    nodeItemsElems.add(item);
                }
                nodeItemsCache.clear();
                for (Map.Entry entry : nodeItemsElMap.entrySet()) {
                    Element itemsEl = new Element("items", new String[]{"node"}, new String[]{(String)entry.getKey()});
                    List itemsElems = (List)entry.getValue();
                    Collections.reverse(itemsElems);
                    itemsEl.addChildren(itemsElems);
                    rpubsub.addChild((XMLNodeIfc)itemsEl);
                }
                if (nodeItemsElMap.size() > 0) {
                    Element rsmResponse = new Element("set", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/rsm"});
                    rsmResponse.addChild((XMLNodeIfc)new Element("first", ((IItems.ItemMeta)itemsMeta.get(offset)).getId(), new String[]{"index"}, new String[]{String.valueOf(offset)}));
                    rsmResponse.addChild((XMLNodeIfc)new Element("count", "" + itemsMeta.size()));
                    if (lastId != null) {
                        rsmResponse.addChild((XMLNodeIfc)new Element("last", lastId));
                    }
                    rpubsub.addChild((XMLNodeIfc)rsmResponse);
                } else {
                    rpubsub.addChild((XMLNodeIfc)new Element("items", new String[]{"node"}, new String[]{nodeName}));
                }
                this.packetWriter.write(iq);
                return;
            }
            if (nodeConfig instanceof LeafNodeConfig && !((LeafNodeConfig)nodeConfig).isPersistItem()) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "persistent-items"));
            }
            List<String> requestedId = this.extractItemsIds(items);
            Element rpubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            Element ritems = new Element("items", new String[]{"node"}, new String[]{nodeName});
            Packet iq = packet.okResult(rpubsub, 0);
            rpubsub.addChild((XMLNodeIfc)ritems);
            Integer maxItems = this.asInteger(items.getAttributeStaticStr("max_items"));
            Integer offset = 0;
            Element rsmGet = pubsub.getChild("set", "http://jabber.org/protocol/rsm");
            if (rsmGet != null) {
                Element m = rsmGet.getChild("max");
                if (m != null) {
                    maxItems = this.asInteger(m.getCData());
                }
                if ((m = rsmGet.getChild("index")) != null) {
                    offset = this.asInteger(m.getCData());
                }
            }
            IItems nodeItems = this.getRepository().getNodeItems(toJid, nodeName);
            if (requestedId == null && (ids = nodeItems.getItemsIds()) != null) {
                requestedId = Arrays.asList(ids);
                requestedId = new ArrayList<String>(requestedId);
                Collections.reverse(requestedId);
            }
            Element rsmResponse = new Element("set", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/rsm"});
            if (requestedId != null) {
                if (maxItems == null) {
                    maxItems = requestedId.size();
                }
                ArrayList<Element> ritemsList = new ArrayList<Element>();
                rsmResponse.addChild((XMLNodeIfc)new Element("count", "" + requestedId.size()));
                String lastId = null;
                for (int i = 0; i < maxItems; ++i) {
                    if (i + offset >= requestedId.size()) continue;
                    String id = requestedId.get(i + offset);
                    if (i == 0) {
                        rsmResponse.addChild((XMLNodeIfc)new Element("first", id, new String[]{"index"}, new String[]{"" + (i + offset)}));
                    }
                    Element item = nodeItems.getItem(id);
                    lastId = id;
                    ritemsList.add(item);
                }
                if (lastId != null) {
                    rsmResponse.addChild((XMLNodeIfc)new Element("last", lastId));
                }
                Collections.reverse(ritemsList);
                ritems.addChildren(ritemsList);
                if (maxItems.intValue() != requestedId.size()) {
                    rpubsub.addChild((XMLNodeIfc)rsmResponse);
                }
            }
            this.packetWriter.write(iq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void checkPermission(JID senderJid, BareJID toJid, String nodeName, AbstractNodeConfig nodeConfig) throws PubSubException, RepositoryException {
        boolean allowed;
        if (nodeConfig == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        if (nodeConfig.getNodeAccessModel() == AccessModel.open && !Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains())) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
        UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid.getBareJID());
        if (senderAffiliation.getAffiliation() == Affiliation.outcast) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
        Subscription senderSubscription = nodeSubscriptions.getSubscription(senderJid.getBareJID());
        if (nodeConfig.getNodeAccessModel() == AccessModel.whitelist && !senderAffiliation.getAffiliation().isRetrieveItem()) {
            throw new PubSubException(Authorization.NOT_ALLOWED, PubSubErrorCondition.CLOSED_NODE);
        }
        if (!(nodeConfig.getNodeAccessModel() != AccessModel.authorize || senderSubscription == Subscription.subscribed && senderAffiliation.getAffiliation().isRetrieveItem())) {
            throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_SUBSCRIBED);
        }
        if (nodeConfig.getNodeAccessModel() == AccessModel.presence) {
            boolean allowed2 = this.hasSenderSubscription(senderJid.getBareJID(), nodeAffiliations, nodeSubscriptions);
            if (!allowed2) {
                throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.PRESENCE_SUBSCRIPTION_REQUIRED);
            }
        } else if (nodeConfig.getNodeAccessModel() == AccessModel.roster && !(allowed = this.isSenderInRosterGroup(senderJid.getBareJID(), nodeConfig, nodeAffiliations, nodeSubscriptions))) {
            throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_IN_ROSTER_GROUP);
        }
    }
}

