/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tigase.component2.PacketWriter;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventType;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PresenceCollectorModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    private final Map<BareJID, Set<String>> resources = new HashMap<BareJID, Set<String>>();

    public PresenceCollectorModule(PubSubConfig config, PacketWriter packetWriter) {
        super(config, packetWriter);
    }

    public void addBuddyVisibilityHandler(BuddyVisibilityHandler handler) {
        this.config.getEventBus().addHandler(BuddyVisibilityHandler.BuddyVisibilityEvent.TYPE, handler);
    }

    public synchronized boolean addJid(JID jid) {
        if (jid == null) {
            return false;
        }
        boolean added = false;
        BareJID bareJid = jid.getBareJID();
        String resource = jid.getResource();
        if (resource != null) {
            Set<String> resources = this.resources.get(bareJid);
            if (resources == null) {
                resources = new HashSet<String>();
                this.resources.put(bareJid, resources);
            }
            added = resources.add(resource);
            this.log.finest("Contact " + jid + " is collected.");
        }
        return added;
    }

    public void addPresenceChangeHandler(PresenceChangeHandler handler) {
        this.config.getEventBus().addHandler(PresenceChangeHandler.PresenceChangeEvent.TYPE, handler);
    }

    private void firePresenceChangeEvent(Packet packet) {
        PresenceChangeHandler.PresenceChangeEvent event = new PresenceChangeHandler.PresenceChangeEvent(packet);
        this.config.getEventBus().fire(event);
    }

    public List<JID> getAllAvailableJids() {
        ArrayList<JID> result = new ArrayList<JID>();
        for (Map.Entry<BareJID, Set<String>> entry : this.resources.entrySet()) {
            for (String reource : entry.getValue()) {
                result.add(JID.jidInstanceNS((BareJID)entry.getKey(), (String)reource));
            }
        }
        return result;
    }

    public List<JID> getAllAvailableResources(BareJID bareJid) {
        ArrayList<JID> result = new ArrayList<JID>();
        Set<String> jid_resources = this.resources.get(bareJid);
        if (jid_resources != null) {
            for (String reource : jid_resources) {
                result.add(JID.jidInstanceNS((BareJID)bareJid, (String)reource));
            }
        }
        return result;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#presence-notifications"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isJidAvailable(BareJID bareJid) {
        Set<String> resources = this.resources.get(bareJid);
        return resources != null && resources.size() > 0;
    }

    private Packet preparePresence(Packet presence, StanzaType type) {
        JID to = presence.getTo();
        JID from = presence.getStanzaFrom();
        if (from != null && to != null && !from.getBareJID().equals((Object)to.getBareJID())) {
            JID jid = from.copyWithoutResource();
            Element p = new Element("presence", new String[]{"to", "from"}, new String[]{jid.toString(), to.toString()});
            if (type != null) {
                p.setAttribute("type", type.toString());
            }
            p.setXMLNS("jabber:client");
            return new Presence(p, to, from);
        }
        return null;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        StanzaType type = packet.getType();
        JID jid = packet.getStanzaFrom();
        JID toJid = packet.getStanzaTo();
        PresenceChangeHandler.PresenceChangeEvent event = new PresenceChangeHandler.PresenceChangeEvent(packet);
        this.config.getEventBus().fire(event, this);
        if (type == null || type == StanzaType.available) {
            boolean added = this.addJid(jid);
            this.firePresenceChangeEvent(packet);
            if (added) {
                Presence p = new Presence(new Element("presence", new String[]{"to", "from"}, new String[]{jid.toString(), toJid.toString()}), toJid, jid);
                this.packetWriter.write((Packet)p);
            }
        } else if (StanzaType.unavailable == type) {
            this.removeJid(jid);
            this.firePresenceChangeEvent(packet);
            Presence p = new Presence(new Element("presence", new String[]{"to", "from", "type"}, new String[]{jid.toString(), toJid.toString(), StanzaType.unavailable.toString()}), toJid, jid);
            this.packetWriter.write((Packet)p);
        } else if (StanzaType.subscribe == type) {
            this.log.finest("Contact " + jid + " wants to subscribe PubSub");
            Packet presence = this.preparePresence(packet, StanzaType.subscribed);
            if (presence != null) {
                this.packetWriter.write(presence);
            }
            if ((presence = this.preparePresence(packet, StanzaType.subscribe)) != null) {
                this.packetWriter.write(presence);
            }
        } else if (StanzaType.unsubscribe == type || StanzaType.unsubscribed == type) {
            this.log.finest("Contact " + jid + " wants to unsubscribe PubSub");
            Packet presence = this.preparePresence(packet, StanzaType.unsubscribed);
            if (presence != null) {
                this.packetWriter.write(presence);
            }
            if ((presence = this.preparePresence(packet, StanzaType.unsubscribe)) != null) {
                this.packetWriter.write(presence);
            }
        }
    }

    public void removeBuddyVisibilityHandler(BuddyVisibilityHandler handler) {
        this.config.getEventBus().remove(BuddyVisibilityHandler.BuddyVisibilityEvent.TYPE, handler);
    }

    protected synchronized boolean removeJid(JID jid) {
        if (jid == null) {
            return false;
        }
        BareJID bareJid = jid.getBareJID();
        String resource = jid.getResource();
        boolean removed = false;
        if (resource == null) {
            this.resources.remove(bareJid);
            BuddyVisibilityHandler.BuddyVisibilityEvent event = new BuddyVisibilityHandler.BuddyVisibilityEvent(bareJid, false);
            this.config.getEventBus().fire(event);
        } else {
            Set<String> resources = this.resources.get(bareJid);
            if (resources != null) {
                removed = resources.remove(resource);
                this.log.finest("Contact " + jid + " is removed from collection.");
                if (resources.size() == 0) {
                    this.resources.remove(bareJid);
                    BuddyVisibilityHandler.BuddyVisibilityEvent event = new BuddyVisibilityHandler.BuddyVisibilityEvent(bareJid, false);
                    this.config.getEventBus().fire(event);
                }
            }
        }
        return removed;
    }

    public void removePresenceChangeHandler(PresenceChangeHandler handler) {
        this.config.getEventBus().remove(PresenceChangeHandler.PresenceChangeEvent.TYPE, handler);
    }

    public static interface PresenceChangeHandler
    extends EventHandler {
        public void onPresenceChange(Packet var1);

        public static class PresenceChangeEvent
        extends Event<PresenceChangeHandler> {
            public static final EventType<PresenceChangeHandler> TYPE = new EventType();
            private Packet packet;

            public PresenceChangeEvent(Packet packet) {
                super(TYPE);
                this.packet = packet;
            }

            @Override
            protected void dispatch(PresenceChangeHandler handler) {
                handler.onPresenceChange(this.packet);
            }
        }
    }

    public static interface BuddyVisibilityHandler
    extends EventHandler {
        public void onBuddyVisibilityChange(BareJID var1, boolean var2);

        public static class BuddyVisibilityEvent
        extends Event<BuddyVisibilityHandler> {
            public static final EventType<BuddyVisibilityHandler> TYPE = new EventType();
            private final boolean becomeOnline;
            private final BareJID buddyJID;

            public BuddyVisibilityEvent(BareJID buddyJID, boolean becomeOnline) {
                super(TYPE);
                this.buddyJID = buddyJID;
                this.becomeOnline = becomeOnline;
            }

            @Override
            protected void dispatch(BuddyVisibilityHandler handler) {
                handler.onBuddyVisibilityChange(this.buddyJID, this.becomeOnline);
            }
        }
    }
}

