/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;

public class ApiKeyItem
extends RepositoryItemAbstract {
    private static final String ELEM_NAME = "api-key";
    private static final String KEY_ATTR = "key";
    private static final String[] REGEX_PATH = new String[]{"api-key", "regex"};
    private static final String API_KEY_LABEL = "API Key";
    private static final String REGEX_LABEL = "Regular expressions (only request matching any of following regular expressions will be allowed, if no regular expression is set then request to any path is allowed)";
    private String key;
    private List<Pattern> regexs = new CopyOnWriteArrayList<Pattern>();

    public String getElemName() {
        return ELEM_NAME;
    }

    public String getKey() {
        return this.key;
    }

    public void addCommandFields(Packet packet) {
        Command.addFieldValue((Packet)packet, (String)API_KEY_LABEL, (String)(this.key == null ? UUID.randomUUID().toString() : this.key));
        ArrayList<String> values = new ArrayList<String>();
        if (!this.regexs.isEmpty()) {
            for (Pattern regex : this.regexs) {
                values.add(regex.pattern());
            }
        }
        Command.addFieldMultiValue((Packet)packet, (String)REGEX_LABEL, values);
    }

    public void initFromCommand(Packet packet) {
        super.initFromCommand(packet);
        this.key = Command.getFieldValue((Packet)packet, (String)API_KEY_LABEL);
        String[] regexs = Command.getFieldValues((Packet)packet, (String)REGEX_LABEL);
        if (regexs != null) {
            String[] stringArray = regexs;
            int n = regexs.length;
            int n2 = 0;
            while (n2 < n) {
                String regex = stringArray[n2];
                if (!regex.isEmpty()) {
                    this.regexs.add(Pattern.compile(regex));
                }
                ++n2;
            }
        }
    }

    public void initFromElement(Element elem) {
        if (elem.getName() != ELEM_NAME) {
            throw new IllegalArgumentException("Incorrect element name, expected: api-key");
        }
        super.initFromElement(elem);
        this.key = elem.getAttributeStaticStr(KEY_ATTR);
        List regexs = elem.getChildren();
        if (regexs != null) {
            for (Element regex : regexs) {
                if (!regex.getName().equals("regex")) continue;
                this.regexs.add(Pattern.compile(XMLUtils.unescape((String)regex.getCData())));
            }
        }
    }

    public void initFromPropertyString(String propString) {
        this.key = propString;
    }

    public Element toElement() {
        Element elem = super.toElement();
        elem.setAttribute(KEY_ATTR, this.key);
        for (Pattern regex : this.regexs) {
            String pattern = regex.pattern();
            elem.addChild((XMLNodeIfc)new Element("regex", XMLUtils.escape((String)pattern)));
        }
        return elem;
    }

    public String toPropertyString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key);
        return sb.toString();
    }

    public boolean isAllowed(String key, String path) {
        if (this.key.equals(key)) {
            if (this.regexs.isEmpty()) {
                return true;
            }
            for (Pattern regex : this.regexs) {
                if (!regex.matcher(path).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

