/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import tigase.http.HttpRegistrator;
import tigase.http.rest.RestMessageReceiver;
import tigase.http.rest.RestSerlvet;
import tigase.http.rest.Service;
import tigase.http.security.TigasePlainLoginService;

public class HttpServer {
    private static final Logger log = Logger.getLogger(HttpServer.class.getCanonicalName());
    private static final String PORT_KEY = "port";
    private static final String CONTEXT_KEY = "context";
    private static final String CONTEXT_FILE_PATH_KEY = "context-file-path";
    private static final String USE_LOCAL_SERVER_KEY = "use-local-server";
    private static final String REST_SCRIPTS_DIRECTORY_KEY = "rest-scripts-dir";
    private static final int DEFAULT_PORT_VAL = 8080;
    private static final String DEFAULT_CONTEXT_VAL = "/rest";
    private static final String DEFAULT_CONTEXT_FILE_PATH_VAL = "etc/tigase-http-context.xml";
    private static final String DEFAULT_REST_SCRIPTS_DIRECTORY_VAL = "scripts/rest";
    private static Server localServer;
    private static int port;
    private static String context;
    private static String contextFilePath;
    private static boolean useLocal;
    private static String scriptsDir;
    private static boolean osgi;
    private static HttpRegistrator osgiHttpRegistrator;
    private static HttpRegistrator localHttpRegistrator;
    private static ServletContextHandler httpContext;
    private static RestMessageReceiver restComponent;

    static {
        port = 8080;
        context = DEFAULT_CONTEXT_VAL;
        contextFilePath = null;
        useLocal = true;
        scriptsDir = DEFAULT_REST_SCRIPTS_DIRECTORY_VAL;
        osgi = false;
        httpContext = null;
    }

    public static void setOSGi(boolean osgi_) {
        osgi = osgi_;
    }

    public static void setOsgiHttpRegistrator(HttpRegistrator registrator) {
        osgiHttpRegistrator = registrator;
    }

    public static Map<String, Object> getDefaults(Map<String, Object> params, Map<String, Object> props) {
        props.put(PORT_KEY, 8080);
        props.put(CONTEXT_KEY, DEFAULT_CONTEXT_VAL);
        props.put(CONTEXT_FILE_PATH_KEY, DEFAULT_CONTEXT_FILE_PATH_VAL);
        props.put(USE_LOCAL_SERVER_KEY, !osgi);
        props.put(REST_SCRIPTS_DIRECTORY_KEY, DEFAULT_REST_SCRIPTS_DIRECTORY_VAL);
        return props;
    }

    public static void setProperties(Map<String, Object> props) {
        HttpRegistrator registrator;
        useLocal = (Boolean)props.get(USE_LOCAL_SERVER_KEY);
        port = (Integer)props.get(PORT_KEY);
        contextFilePath = (String)props.get(CONTEXT_FILE_PATH_KEY);
        context = (String)props.get(CONTEXT_KEY);
        scriptsDir = (String)props.get(REST_SCRIPTS_DIRECTORY_KEY);
        HttpRegistrator httpRegistrator = registrator = useLocal ? localHttpRegistrator : osgiHttpRegistrator;
        if (registrator != null) {
            registrator.setContextFilePath(contextFilePath);
        } else {
            log.warning("no HttpRegistrator instance where useLocal = " + useLocal);
        }
    }

    public static void start() {
        HttpRegistrator registrator = osgiHttpRegistrator;
        if (useLocal) {
            localServer = new Server(port);
            registrator = localHttpRegistrator = new HttpRegistrator(){

                @Override
                public void registerHttpServletContext(ServletContextHandler ctx) {
                    localServer.setHandler((Handler)ctx);
                }

                @Override
                public void unregisterContext(ServletContextHandler ctx) {
                    try {
                        ctx.stop();
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Exception stopping servlet context", e);
                    }
                }
            };
        }
        if (contextFilePath != null) {
            registrator.setContextFilePath(contextFilePath);
        }
        try {
            HttpServer.start(registrator);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception creating context", ex);
        }
        if (useLocal) {
            try {
                localServer.start();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception starting http server", e);
            }
        }
    }

    public static void stop() {
        HttpServer.stop(useLocal ? localHttpRegistrator : osgiHttpRegistrator);
        if (useLocal) {
            try {
                localServer.stop();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception stopping http server", e);
            }
            httpContext = null;
        }
    }

    private static void start(HttpRegistrator registrator) throws Exception {
        httpContext = new ServletContextHandler(0);
        httpContext.setSecurityHandler((SecurityHandler)httpContext.getDefaultSecurityHandlerClass().newInstance());
        httpContext.getSecurityHandler().setLoginService((LoginService)new TigasePlainLoginService());
        httpContext.setContextPath(context);
        File scriptsDirFile = new File(scriptsDir);
        File[] scriptDirFiles = scriptsDirFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (scriptDirFiles != null) {
            File[] fileArray = scriptDirFiles;
            int n = scriptDirFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File dirFile = fileArray[n2];
                HttpServer.startRestServletForDirectory(httpContext, dirFile);
                ++n2;
            }
        }
        registrator.registerHttpServletContext(httpContext);
    }

    private static void startRestServletForDirectory(ServletContextHandler httpContext, File scriptsDirFile) {
        File[] scriptFiles = scriptsDirFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith("groovy");
            }
        });
        if (scriptFiles != null) {
            RestSerlvet restServlet = new RestSerlvet();
            httpContext.addServlet(new ServletHolder((Servlet)restServlet), "/" + scriptsDirFile.getName() + "/*");
            restServlet.loadHandlers(scriptFiles);
        }
    }

    private static void stop(HttpRegistrator registrator) {
        registrator.unregisterContext(httpContext);
    }

    public static void setService(RestMessageReceiver component) {
        restComponent = component;
    }

    public static Service getService() {
        return restComponent;
    }
}

