/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.licence.LicenceChecker;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.cluster.CachedPubSubRepositoryClustered;
import tigase.pubsub.cluster.PartitionedStrategy;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class PubSubComponentClustered
extends PubSubComponent
implements ClusteredComponentIfc {
    private static final Logger a = Logger.getLogger(PubSubComponentClustered.class.getCanonicalName());
    private static final String b = "packet-forward-pubsub-cmd";
    private a c = new a();
    private ClusterControllerIfc d;
    private StrategyIfc e = new PartitionedStrategy();
    private ComponentInfo f = null;
    private LicenceChecker g;

    public PubSubComponentClustered() {
        this.e.setPubSubComponentClustered(this);
        this.g = LicenceChecker.getLicenceChecker((String)"acs-pubsub");
    }

    public void nodeConnected(String node) {
        JID jID = JID.jidInstanceNS((String)node);
        this.e.nodeConnected(jID);
    }

    public void nodeDisconnected(String node) {
        JID jID = JID.jidInstanceNS((String)node);
        this.e.nodeDisconnected(jID);
    }

    public void processPacket(Packet packet) {
        List<JID> list;
        boolean bl;
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Received packet: {0}", packet);
        }
        if (bl = (list = this.e.getNodesForPacket(packet)).contains(this.e.getLocalNodeJid())) {
            if (list.size() == 1) {
                list = null;
            } else {
                list.remove(this.e.getLocalNodeJid());
            }
        }
        if (list != null) {
            this.d.sendToNodes(b, packet.getElement(), this.e.getLocalNodeJid(), null, list.toArray(new JID[list.size()]));
        }
        if (bl) {
            super.processPacket(packet);
            this.getPubSubRepository().clearRemoteNodes();
        }
    }

    public ComponentInfo getComponentInfo() {
        this.f = super.getComponentInfo();
        this.f.getComponentData().put("PubSubClusteringStrategy", this.e != null ? this.e.getClass() : null);
        return this.f;
    }

    public String getDiscoDescription() {
        return super.getDiscoDescription() + " acs-clustered";
    }

    public CachedPubSubRepositoryClustered getPubSubRepository() {
        return (CachedPubSubRepositoryClustered)this.pubsubRepository;
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.d != null) {
            this.d.removeCommandListener((CommandListener)this.c);
        }
        this.d = cl_controller;
        this.d.setCommandListener((CommandListener)this.c);
        this.e.setClusterController(cl_controller);
    }

    protected CachedPubSubRepository createPubSubRepository(PubSubDAO directRepository) {
        return new CachedPubSubRepositoryClustered(directRepository, this.maxRepositoryCacheSize, this.e);
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(PubSubComponentClustered.b);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            for (Element element : packets) {
                try {
                    Packet packet = Packet.packetInstance((Element)element);
                    PubSubComponentClustered.super.processPacket(packet);
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    a.warning("Addressing problem, stringprep failed for packet: " + element);
                }
            }
        }
    }
}

