/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.DNSResolver;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class MessageArchivePlugin
extends XMPPProcessor
implements XMPPProcessorIfc {
    public static final String LIST = "list";
    public static final String OWNER_JID = "owner";
    public static final String REMOVE = "remove";
    public static final String RETRIEVE = "retrieve";
    public static final String XEP0136NS = "urn:xmpp:archive";
    private static final String ARCHIVE = "message-archive";
    private static final String AUTO = "auto";
    private static final String ID = "message-archive-xep-0136";
    private static final Logger log = Logger.getLogger(MessageArchivePlugin.class.getCanonicalName());
    private static final String MESSAGE = "message";
    private static final String SETTINGS = "message-archive/settings";
    private static final String XMLNS = "jabber:client";
    private static final String[][] ELEMENT_PATHS = new String[][]{{"message"}, {"iq", "auto"}, {"iq", "retrieve"}, {"iq", "list"}};
    private static final String[] XMLNSS = new String[]{"jabber:client", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive"};
    private static final Set<StanzaType> TYPES;
    private static final Element[] DISCO_FEATURES;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private JID ma_jid = null;

    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        String componentJidStr = (String)settings.get("component-jid");
        if (componentJidStr != null) {
            this.ma_jid = JID.jidInstanceNS((String)componentJidStr);
        } else {
            String defHost = DNSResolver.getDefaultHostname();
            this.ma_jid = JID.jidInstanceNS((String)ARCHIVE, (String)defHost, null);
        }
        log.log(Level.CONFIG, "Loaded message archiving component jid option: {0} = {1}", new Object[]{"component-jid", this.ma_jid});
        System.out.println("MA LOADED = " + this.ma_jid.toString());
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        block20: {
            if (session == null) {
                return;
            }
            try {
                if (MESSAGE == packet.getElemName()) {
                    StanzaType type = packet.getType();
                    if (packet.getElement().findChildStaticStr(Message.MESSAGE_BODY_PATH) == null || type != null && type != StanzaType.chat && type != StanzaType.normal) {
                        return;
                    }
                    boolean auto = this.getAutoSave(session);
                    if (auto && packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH) != null) {
                        Packet result = packet.copyElementOnly();
                        result.setPacketTo(this.ma_jid);
                        result.getElement().addAttribute(OWNER_JID, session.getBareJID().toString());
                        results.offer(result);
                    }
                    break block20;
                }
                if ("iq" != packet.getElemName()) break block20;
                if (this.ma_jid.equals((Object)packet.getPacketFrom())) {
                    JID connId = session.getConnectionId(packet.getStanzaTo());
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(connId);
                    results.offer(result);
                    return;
                }
                if (packet.getType() != StanzaType.get && packet.getType() != StanzaType.set) {
                    return;
                }
                Element auto = packet.getElement().getChild(AUTO);
                Element pref = packet.getElement().getChild("pref");
                if (auto == null && pref == null) {
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(this.ma_jid);
                    results.offer(result);
                    break block20;
                }
                if (pref != null) {
                    if (packet.getType() == StanzaType.get) {
                        Element prefEl = new Element("pref");
                        prefEl.setXMLNS(XEP0136NS);
                        Element autoEl = new Element(AUTO);
                        autoEl.setAttribute("save", String.valueOf(this.getAutoSave(session)));
                        prefEl.addChild((XMLNodeIfc)autoEl);
                        Element defaultEl = new Element("default");
                        defaultEl.setAttribute("otr", "forbid");
                        defaultEl.setAttribute("save", MESSAGE);
                        prefEl.addChild((XMLNodeIfc)defaultEl);
                        Element methodEl = new Element("method");
                        methodEl.setAttribute("type", AUTO);
                        methodEl.setAttribute("use", "prefer");
                        prefEl.addChild((XMLNodeIfc)methodEl);
                        methodEl = new Element("method");
                        methodEl.setAttribute("type", "local");
                        methodEl.setAttribute("use", "prefer");
                        prefEl.addChild((XMLNodeIfc)methodEl);
                        methodEl = new Element("method");
                        methodEl.setAttribute("type", "manual");
                        methodEl.setAttribute("use", "prefer");
                        prefEl.addChild((XMLNodeIfc)methodEl);
                        results.offer(packet.okResult(prefEl, 0));
                    } else if (packet.getType() == StanzaType.set) {
                        results.offer(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, true));
                    } else {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, true));
                    }
                    break block20;
                }
                String val = auto.getAttributeStaticStr("save");
                boolean save = false;
                if ("1".equals(val) || "true".equals(val)) {
                    save = true;
                } else if ("0".equals(val) || "false".equals(val)) {
                    save = false;
                } else {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Save value is incorrect or missing", false));
                }
                try {
                    this.setAutoSave(session, save);
                    session.putCommonSessionData("message-archive-xep-0136/auto", (Object)save);
                    Element res = new Element(AUTO);
                    res.setXMLNS(XEP0136NS);
                    res.setAttribute("save", save ? "true" : "false");
                    results.offer(packet.okResult(res, 0));
                    return;
                }
                catch (TigaseDBException ex) {
                    log.log(Level.WARNING, "Error setting Message Archive state: {0}", ex.getMessage());
                    results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
                }
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.WARNING, "NotAuthorizedException for packet: {0}", packet);
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
            }
        }
    }

    public String id() {
        return ID;
    }

    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }

    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    public Set<StanzaType> supTypes() {
        return TYPES;
    }

    private boolean getAutoSave(XMPPResourceConnection session) throws NotAuthorizedException {
        Boolean auto = (Boolean)session.getCommonSessionData("message-archive-xep-0136/auto");
        if (auto == null) {
            try {
                String data = session.getData(SETTINGS, AUTO, "false");
                auto = Boolean.parseBoolean(data);
                session.putCommonSessionData("message-archive-xep-0136/auto", (Object)auto);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Error getting Message Archive state: {0}", ex.getMessage());
                auto = false;
            }
        }
        return auto;
    }

    public void setAutoSave(XMPPResourceConnection session, Boolean auto) throws NotAuthorizedException, TigaseDBException {
        session.setData(SETTINGS, AUTO, String.valueOf(auto));
    }

    static {
        DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:archive:auto"}), new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:archive:manage"})};
        HashSet<StanzaType[]> tmpTYPES = new HashSet<StanzaType[]>();
        tmpTYPES.add(null);
        tmpTYPES.addAll(EnumSet.of(StanzaType.normal, new StanzaType[]{StanzaType.chat, StanzaType.get, StanzaType.set, StanzaType.error, StanzaType.result}));
        TYPES = Collections.unmodifiableSet(tmpTYPES);
    }
}

