/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.tracer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;

public class TigaseTracer {
    private static final Logger log = Logger.getLogger(TigaseTracer.class.getName());
    public static final String TRACER_IPS_PROP_KEY = "--tracer-ips";
    public static final String TRACER_JIDS_PROP_KEY = "--tracer-jids";
    public static final String TRACER_CIDS_PROP_KEY = "--tracer-cids";
    private static final String DEF_DIR = "logs";
    private static final long DEF_MAX_FILE_SIZE = 10000000L;
    private static final int DEF_FILES_COUNT = 5;
    private static final String DEF_FILE_NAME = "packet-tracing.log";
    private static TigaseTracer instance = null;
    private static ConcurrentSkipListSet<String> ips = new ConcurrentSkipListSet();
    private static ConcurrentSkipListSet<String> jids = new ConcurrentSkipListSet();
    private static ConcurrentSkipListSet<String> cids = new ConcurrentSkipListSet();
    private ArrayBlockingQueue<String> waiting = new ArrayBlockingQueue(10000, true);
    private Runnable worker = null;
    private File[] files = null;
    private long maxFileSize = 10000000L;
    private int filesCount = 5;
    private String dir = "logs";
    private String fileName = "packet-tracing.log";

    public static TigaseTracer getTracer(String name) {
        if (instance == null) {
            try {
                instance = new TigaseTracer();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error initializing Tigase tracer: ", e);
            }
        }
        return instance;
    }

    public static void addIP(String ip) {
        ips.add(ip);
    }

    public static void removeIP(String ip) {
        ips.remove(ip);
    }

    public static void addJid(String jid) {
        jids.add(jid);
    }

    public static void removeJid(String jid) {
        jids.remove(jid);
    }

    public static void addCid(String cid) {
        cids.add(cid);
    }

    public static void removeCid(String cid) {
        cids.remove(cid);
    }

    private TigaseTracer() throws IOException {
        this.init();
    }

    private void init() throws IOException {
        this.files = new File[this.filesCount];
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = new File(this.dir, this.fileName + "." + i);
        }
        this.worker = new TracingWorker(new FileWriter(this.files[0], true), this.files[0].length());
        Thread thr = new Thread(this.worker);
        thr.setName("tracing-worker");
        thr.setDaemon(true);
        thr.start();
    }

    public boolean trace(String ip, String to_jid, String from_jid, String cid, String id, String point, String msg, Packet packet) {
        if (ip != null && ips.contains(ip)) {
            return this.waiting.offer(this.format(ip, id, point, msg, packet));
        }
        if (to_jid != null && jids.contains(to_jid)) {
            return this.waiting.offer(this.format("TO: " + to_jid, id, point, msg, packet));
        }
        if (from_jid != null && jids.contains(from_jid)) {
            return this.waiting.offer(this.format("FROM: " + from_jid, id, point, msg, packet));
        }
        if (cid != null && cids.contains(cid)) {
            return this.waiting.offer(this.format(cid, id, point, msg, packet));
        }
        return false;
    }

    private String format(String filter, String id, String point, String msg, Packet packet) {
        StringBuilder sb = new StringBuilder();
        Calendar cal = Calendar.getInstance();
        sb.append(cal.get(1));
        sb.append("-");
        sb.append(cal.get(2) + 1);
        sb.append("-");
        sb.append(cal.get(5));
        sb.append(" ");
        sb.append(cal.get(11));
        sb.append(":");
        sb.append(cal.get(12));
        sb.append(":");
        sb.append(cal.get(13));
        sb.append(".");
        sb.append(cal.get(14));
        sb.append("[");
        sb.append(filter);
        sb.append("] {");
        sb.append(id);
        sb.append('-');
        sb.append(point);
        sb.append("} ");
        if (msg != null) {
            sb.append(msg);
        }
        if (packet != null) {
            sb.append(packet);
        }
        sb.append('\n');
        return sb.toString();
    }

    public boolean tracegByIP(String ip, String point, String msg, Packet packet) {
        return this.trace(ip, null, null, null, null, point, msg, packet);
    }

    public boolean traceByToJid(String jid, String point, String msg, Packet packet) {
        return this.trace(null, jid, null, null, null, point, msg, packet);
    }

    public boolean traceByFromJid(String jid, String point, String msg, Packet packet) {
        return this.trace(null, null, jid, null, null, point, msg, packet);
    }

    public boolean traceByCid(String cid, String point, String msg, Packet packet) {
        return this.trace(null, null, null, cid, null, point, msg, packet);
    }

    private Writer rotateFiles(Writer writer) throws IOException {
        writer.close();
        for (int i = this.files.length - 2; i >= 0; --i) {
            File file1 = this.files[i];
            File file2 = this.files[i + 1];
            if (!file1.exists()) continue;
            if (file2.exists()) {
                file2.delete();
            }
            file1.renameTo(file2);
        }
        return new FileWriter(this.files[0], false);
    }

    private class TracingWorker
    implements Runnable {
        private boolean stopped = false;
        private Writer writer = null;
        private long size = 0L;

        protected TracingWorker(Writer writer, long initSize) {
            this.writer = writer;
            this.size = initSize;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    String entry = (String)TigaseTracer.this.waiting.take();
                    if (entry == null) continue;
                    try {
                        this.writer.write(entry);
                        this.writer.flush();
                        this.size += (long)entry.length();
                        if (this.size < TigaseTracer.this.maxFileSize) continue;
                        this.writer = TigaseTracer.this.rotateFiles(this.writer);
                        this.size = 0L;
                    }
                    catch (IOException ex) {
                        log.log(Level.WARNING, "Can not write to trace file: ", ex);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

