/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslServerFactory;
import tigase.auth.mechanisms.TigaseSaslServerFactory;

public class TigaseSaslProvider
extends Provider {
    public static final String FACTORY_KEY = "factory";
    private static final String INFO = "This is tigase provider (provides Tigase server specific mechanisms)";
    private static final Logger log = Logger.getLogger(TigaseSaslProvider.class.getName());
    private static final String MY_NAME = "tigase.sasl";
    private static final long serialVersionUID = 1L;
    private static final double VERSION = 1.0;

    public TigaseSaslProvider(Map<String, Object> settings) {
        super(MY_NAME, 1.0, INFO);
        Class facClass;
        if (settings.containsKey(FACTORY_KEY)) {
            try {
                facClass = Class.forName(settings.get(FACTORY_KEY).toString());
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, "Unknown factory class", e);
                throw new RuntimeException(e);
            }
        } else {
            facClass = TigaseSaslServerFactory.class;
        }
        try {
            String[] mech;
            SaslServerFactory tmp = (SaslServerFactory)facClass.newInstance();
            for (String name : mech = tmp.getMechanismNames(new HashMap())) {
                log.config("Registering SASL mechanism '" + name + "' with factory " + facClass.getName());
                this.putService(new Provider.Service(this, "SaslServerFactory", name, facClass.getName(), null, null));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't instantiate factory", e);
            throw new RuntimeException(e);
        }
    }
}

