/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.ElementWriter;
import tigase.db.DataRepository;
import tigase.muc.Room;
import tigase.muc.history.AbstractJDBCHistoryProvider;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class SqlserverSqlHistoryProvider
extends AbstractJDBCHistoryProvider {
    public static final String ADD_MESSAGE_QUERY_VAL = "insert into muc_history (room_name, event_type, timestamp, sender_jid, sender_nickname, body, public_event, msg) values (?, 1, ?, ?, ?, ?, ?, ?)";
    private static final String CREATE_MUC_HISTORY_TABLE_VAL = "create table muc_history (room_name nvarchar(128) NOT NULL,\nevent_type int, \ntimestamp bigint,\nsender_jid nvarchar(2049),\nsender_nickname nvarchar(128),\nbody text,\npublic_event bit,\n msg text )";
    public static final String DELETE_MESSAGES_QUERY_VAL = "delete from muc_history where room_name=?";
    public static final String GET_MESSAGES_MAXSTANZAS_QUERY_VAL = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body, msg from (select top (?) * from muc_history where room_name=? order by timestamp desc  ) AS t order by t.timestamp";
    public static final String GET_MESSAGES_SINCE_QUERY_VAL = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body, msg from (select top (?) * from muc_history where room_name= ? and timestamp >= ? order by timestamp desc  ) AS t order by t.timestamp";
    private Logger log = Logger.getLogger(this.getClass().getName());

    public SqlserverSqlHistoryProvider(DataRepository dataRepository) {
        super(dataRepository);
    }

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, ElementWriter writer) {
        ResultSet rs;
        block24: {
            rs = null;
            String roomJID = room.getRoomJID().toString();
            int maxMessages = room.getConfig().getMaxHistory();
            try {
                PreparedStatement st;
                if (since != null) {
                    PreparedStatement st2;
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Using SINCE selector: roomJID=" + roomJID + ", since=" + since.getTime() + " (" + since + ")");
                    }
                    PreparedStatement preparedStatement = st2 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_SINCE_QUERY_KEY");
                    synchronized (preparedStatement) {
                        st2.setInt(1, maxMessages);
                        st2.setString(2, roomJID);
                        st2.setLong(3, since.getTime());
                        rs = st2.executeQuery();
                        this.processResultSet(room, senderJID, writer, rs);
                        break block24;
                    }
                }
                if (maxstanzas != null) {
                    PreparedStatement st3;
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Using MAXSTANZAS selector: roomJID=" + roomJID + ", maxstanzas=" + maxstanzas);
                    }
                    PreparedStatement preparedStatement = st3 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                    synchronized (preparedStatement) {
                        st3.setInt(1, Math.min(maxstanzas, maxMessages));
                        st3.setString(2, roomJID);
                        System.out.println("getHistoryMessages: " + st3 + " || \t " + "GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                        rs = st3.executeQuery();
                        this.processResultSet(room, senderJID, writer, rs);
                        break block24;
                    }
                }
                if (seconds != null) {
                    PreparedStatement st4;
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Using SECONDS selector: roomJID=" + roomJID + ", seconds=" + seconds);
                    }
                    PreparedStatement preparedStatement = st4 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_SINCE_QUERY_KEY");
                    synchronized (preparedStatement) {
                        st4.setInt(1, maxMessages);
                        st4.setString(2, roomJID);
                        st4.setLong(3, new Date().getTime() - (long)(seconds * 1000));
                        rs = st4.executeQuery();
                        this.processResultSet(room, senderJID, writer, rs);
                        break block24;
                    }
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Using DEFAULT selector: roomJID=" + roomJID);
                }
                PreparedStatement preparedStatement = st = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                synchronized (preparedStatement) {
                    st.setInt(1, maxMessages);
                    st.setString(2, roomJID);
                    System.out.println("getHistoryMessages: " + st.toString() + " max " + maxMessages + " roomJID " + roomJID + " || \t " + "GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                    rs = st.executeQuery();
                    this.processResultSet(room, senderJID, writer, rs);
                }
            }
            catch (Exception e) {
                try {
                    if (this.log.isLoggable(Level.SEVERE)) {
                        this.log.log(Level.SEVERE, "Can't get history", e);
                    }
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.dataRepository.release(null, rs);
                    throw throwable;
                }
            }
        }
        this.dataRepository.release(null, rs);
    }

    @Override
    public void init(Map<String, Object> props) {
        try {
            this.dataRepository.checkTable("muc_history", CREATE_MUC_HISTORY_TABLE_VAL);
            this.internalInit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Initializing problem", e);
            }
            try {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Trying to create tables: create table muc_history (room_name nvarchar(128) NOT NULL,\nevent_type int, \ntimestamp bigint,\nsender_jid nvarchar(2049),\nsender_nickname nvarchar(128),\nbody text,\npublic_event bit,\n msg text )");
                }
                Statement st = this.dataRepository.createStatement(null);
                st.execute(CREATE_MUC_HISTORY_TABLE_VAL);
                this.internalInit();
            }
            catch (SQLException e1) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "Can't initialize muc history", e1);
                }
                throw new RuntimeException(e1);
            }
        }
    }

    private void internalInit() throws SQLException {
        this.dataRepository.initPreparedStatement("ADD_MESSAGE_QUERY_KEY", ADD_MESSAGE_QUERY_VAL);
        this.dataRepository.initPreparedStatement("DELETE_MESSAGES_QUERY_KEY", DELETE_MESSAGES_QUERY_VAL);
        this.dataRepository.initPreparedStatement("GET_MESSAGES_SINCE_QUERY_KEY", GET_MESSAGES_SINCE_QUERY_VAL);
        this.dataRepository.initPreparedStatement("GET_MESSAGES_MAXSTANZAS_QUERY_KEY", GET_MESSAGES_MAXSTANZAS_QUERY_VAL);
    }
}

