/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.HashMap;
import java.util.Map;
import tigase.pubsub.Affiliation;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xmpp.BareJID;

public abstract class NodeAffiliations
implements IAffiliations {
    protected static final String DELIMITER = ";";
    protected final Map<BareJID, UsersAffiliation> affs = new HashMap<BareJID, UsersAffiliation>();
    private boolean changed = false;

    public static tigase.pubsub.repository.cached.NodeAffiliations create(String data) {
        tigase.pubsub.repository.cached.NodeAffiliations a = new tigase.pubsub.repository.cached.NodeAffiliations();
        try {
            a.parse(data);
            return a;
        }
        catch (Exception e) {
            return new tigase.pubsub.repository.cached.NodeAffiliations();
        }
    }

    protected NodeAffiliations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a = new UsersAffiliation(bareJid, affiliation);
        Map<BareJID, UsersAffiliation> map = this.affs;
        synchronized (map) {
            this.affs.put(bareJid, a);
        }
        this.changed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a = this.get(bareJid);
        if (a != null) {
            a.setAffiliation(affiliation);
            this.changed = true;
        } else {
            a = new UsersAffiliation(bareJid, affiliation);
            Map<BareJID, UsersAffiliation> map = this.affs;
            synchronized (map) {
                this.affs.put(bareJid, a);
            }
            this.changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAffiliations clone() throws CloneNotSupportedException {
        Map<BareJID, UsersAffiliation> map = this.affs;
        synchronized (map) {
            tigase.pubsub.repository.cached.NodeAffiliations clone = new tigase.pubsub.repository.cached.NodeAffiliations();
            for (UsersAffiliation a : this.affs.values()) {
                clone.affs.put(a.getJid(), a.clone());
            }
            clone.changed = this.changed;
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UsersAffiliation get(BareJID bareJid) {
        Map<BareJID, UsersAffiliation> map = this.affs;
        synchronized (map) {
            UsersAffiliation s = this.affs.get(bareJid);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsersAffiliation[] getAffiliations() {
        Map<BareJID, UsersAffiliation> map = this.affs;
        synchronized (map) {
            return this.affs.values().toArray(new UsersAffiliation[0]);
        }
    }

    public Map<BareJID, UsersAffiliation> getAffiliationsMap() {
        return this.affs;
    }

    @Override
    public UsersAffiliation getSubscriberAffiliation(BareJID bareJid) {
        UsersAffiliation a = this.get(bareJid);
        if (a == null) {
            a = new UsersAffiliation(bareJid, Affiliation.none);
        }
        return a;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String data) {
        Map<BareJID, UsersAffiliation> map = this.affs;
        synchronized (map) {
            String[] tokens = data.split(DELIMITER);
            this.affs.clear();
            int c = 0;
            BareJID jid = null;
            String state = null;
            for (String t : tokens) {
                if (c == 1) {
                    state = t;
                    ++c;
                } else if (c == 0) {
                    jid = BareJID.bareJIDInstanceNS((String)t);
                    ++c;
                }
                if (c != 2) continue;
                UsersAffiliation b = new UsersAffiliation(jid, Affiliation.valueOf(state));
                this.affs.put(jid, b);
                jid = null;
                state = null;
                c = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBy(IAffiliations nodeAffiliations) {
        Map<BareJID, UsersAffiliation> map = this.affs;
        synchronized (map) {
            if (nodeAffiliations instanceof NodeAffiliations) {
                NodeAffiliations na = (NodeAffiliations)nodeAffiliations;
                this.changed = true;
                this.affs.clear();
                for (UsersAffiliation a : na.affs.values()) {
                    this.affs.put(a.getJid(), a);
                }
            }
        }
    }

    public void resetChangedFlag() {
        this.changed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize() {
        StringBuilder sb = new StringBuilder();
        Map<BareJID, UsersAffiliation> map = this.affs;
        synchronized (map) {
            for (UsersAffiliation a : this.affs.values()) {
                if (a.getAffiliation() == Affiliation.none) continue;
                sb.append(a.getJid());
                sb.append(DELIMITER);
                sb.append(a.getAffiliation().name());
                sb.append(DELIMITER);
            }
        }
        return sb.toString();
    }
}

