/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.List;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ManageAffiliationsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"affiliations"));

    private static Packet createAffiliationNotification(JID fromJid, JID toJid, String nodeName, Affiliation affilation) {
        Packet message = Message.getMessage((JID)fromJid, (JID)toJid, null, null, null, null, null);
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        message.getElement().addChild((XMLNodeIfc)pubsub);
        Element affilations = new Element("affiliations", new String[]{"node"}, new String[]{nodeName});
        pubsub.addChild((XMLNodeIfc)affilations);
        affilations.addChild((XMLNodeIfc)new Element("affilation", new String[]{"jid", "affiliation"}, new String[]{toJid.toString(), affilation.name()}));
        return message;
    }

    public ManageAffiliationsModule(PubSubConfig config, PacketWriter packetWriter) {
        super(config, packetWriter);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#modify-affiliations"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            UsersAffiliation senderAffiliation;
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element element = packet.getElement();
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element affiliations = pubsub.getChild("affiliations");
            String nodeName = affiliations.getAttributeStaticStr("node");
            StanzaType type = packet.getType();
            if (type == null || type != StanzaType.get && type != StanzaType.set) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            JID senderJid = packet.getStanzaFrom();
            if (!this.config.isAdmin(senderJid) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid.getBareJID())).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            if (type == StanzaType.get) {
                this.processGet(packet, affiliations, nodeName, nodeAffiliations, this.packetWriter);
            } else if (type == StanzaType.set) {
                this.processSet(packet, affiliations, nodeName, nodeConfig, nodeAffiliations, this.packetWriter);
            }
            if (nodeAffiliations.isChanged()) {
                this.getRepository().update(toJid, nodeName, nodeAffiliations);
            }
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void processGet(Packet packet, Element affiliations, String nodeName, IAffiliations nodeAffiliations, PacketWriter packetWriter) throws RepositoryException {
        Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
        Packet iq = packet.okResult(ps, 0);
        Element afr = new Element("affiliations", new String[]{"node"}, new String[]{nodeName});
        ps.addChild((XMLNodeIfc)afr);
        UsersAffiliation[] affiliationsList = nodeAffiliations.getAffiliations();
        if (affiliationsList != null) {
            for (UsersAffiliation affi : affiliationsList) {
                if (affi.getAffiliation() == Affiliation.none) continue;
                Element affiliation = new Element("affiliation", new String[]{"jid", "affiliation"}, new String[]{affi.getJid().toString(), affi.getAffiliation().name()});
                afr.addChild((XMLNodeIfc)affiliation);
            }
        }
        packetWriter.write(iq);
    }

    private void processSet(Packet packet, Element affiliations, String nodeName, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, PacketWriter packetWriter) throws PubSubException, RepositoryException {
        List affs = affiliations.getChildren();
        for (Element a : affs) {
            if ("affiliation".equals(a.getName())) continue;
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        for (Element af : affs) {
            String strAfiliation = af.getAttributeStaticStr("affiliation");
            String jidStr = af.getAttributeStaticStr("jid");
            JID jid = JID.jidInstanceNS((String)jidStr);
            if (strAfiliation == null) continue;
            Affiliation newAffiliation = Affiliation.valueOf(strAfiliation);
            Affiliation oldAffiliation = nodeAffiliations.getSubscriberAffiliation(jid.getBareJID()).getAffiliation();
            Affiliation affiliation = oldAffiliation = oldAffiliation == null ? Affiliation.none : oldAffiliation;
            if (oldAffiliation == Affiliation.none && newAffiliation != Affiliation.none) {
                nodeAffiliations.addAffiliation(jid.getBareJID(), newAffiliation);
                if (!nodeConfig.isTigaseNotifyChangeSubscriptionAffiliationState()) continue;
                packetWriter.write(ManageAffiliationsModule.createAffiliationNotification(packet.getStanzaTo(), jid, nodeName, newAffiliation));
                continue;
            }
            nodeAffiliations.changeAffiliation(jid.getBareJID(), newAffiliation);
            if (!nodeConfig.isTigaseNotifyChangeSubscriptionAffiliationState()) continue;
            packetWriter.write(ManageAffiliationsModule.createAffiliationNotification(packet.getStanzaTo(), jid, nodeName, newAffiliation));
        }
        Packet iq = packet.okResult((Element)null, 0);
        packetWriter.write(iq);
    }
}

