/*
 * Decompiled with CFR 0.152.
 */
package tigase.component2.eventbus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventBus;
import tigase.component2.eventbus.EventBusException;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventListener;
import tigase.component2.eventbus.EventType;

public class DefaultEventBus
extends EventBus {
    protected final Map<EventType<?>, List<EventHandler>> handlers = new HashMap();
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private boolean throwingExceptionOn = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <H extends EventHandler> void addHandler(EventType<H> type, H handler) {
        Map<EventType<?>, List<EventHandler>> map = this.handlers;
        synchronized (map) {
            List<EventHandler> lst = this.handlers.get(type);
            if (lst == null) {
                lst = new ArrayList<EventHandler>();
                this.handlers.put(type, lst);
            }
            lst.add(handler);
        }
    }

    @Override
    public <H extends EventHandler> void addListener(EventListener listener) {
        this.addListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <H extends EventHandler> void addListener(EventType<H> type, EventListener listener) {
        Map<EventType<?>, List<EventHandler>> map = this.handlers;
        synchronized (map) {
            List<EventHandler> lst = this.handlers.get(type);
            if (lst == null) {
                lst = new ArrayList<EventHandler>();
                this.handlers.put(type, lst);
            }
            lst.add(listener);
        }
    }

    protected void doFire(Event<EventHandler> event, Object source) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        this.setEventSource(event, source);
        ArrayList<EventHandler> handlers = new ArrayList<EventHandler>();
        handlers.addAll(this.getHandlersList(event.getType(), source));
        handlers.addAll(this.getHandlersList(null, source));
        HashSet<Throwable> causes = new HashSet<Throwable>();
        for (EventHandler eventHandler : handlers) {
            try {
                if (eventHandler instanceof EventListener) {
                    ((EventListener)eventHandler).onEvent(event);
                    continue;
                }
                event.dispatch(eventHandler);
            }
            catch (Throwable e) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "", e);
                }
                causes.add(e);
            }
        }
        if (!causes.isEmpty() && this.throwingExceptionOn) {
            throw new EventBusException(causes);
        }
    }

    @Override
    public void fire(Event<?> event) {
        this.doFire(event, null);
    }

    @Override
    public void fire(Event<?> event, Object source) {
        this.doFire(event, source);
    }

    protected Collection<EventHandler> getHandlersList(EventType<?> type, Object source) {
        List<EventHandler> list = this.handlers.get(type);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public boolean isThrowingExceptionOn() {
        return this.throwingExceptionOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <H extends EventHandler> void remove(EventType<H> type, H handler) {
        Map<EventType<?>, List<EventHandler>> map = this.handlers;
        synchronized (map) {
            List<EventHandler> lst = this.handlers.get(type);
            if (lst != null) {
                lst.remove(handler);
                if (lst.isEmpty()) {
                    this.handlers.remove(type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <H extends EventHandler> void remove(H handler) {
        Map<EventType<?>, List<EventHandler>> map = this.handlers;
        synchronized (map) {
            Iterator<Map.Entry<EventType<?>, List<EventHandler>>> iterator = this.handlers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<EventType<?>, List<EventHandler>> entry = iterator.next();
                if (entry == null) continue;
                entry.getValue().remove(handler);
                if (!entry.getValue().isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    public void setThrowingExceptionOn(boolean throwingExceptionOn) {
        this.throwingExceptionOn = throwingExceptionOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<EventType<?>, List<EventHandler>> map = this.handlers;
        synchronized (map) {
            this.handlers.clear();
        }
    }
}

