/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.util.DataTypes;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.DomainFilterPolicy;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class VHostItem
extends RepositoryItemAbstract {
    public static final String ANONYMOUS_ENABLED_ATT = "anon";
    public static final String ANONYMOUS_ENABLED_LABEL = "Anonymous enabled";
    public static final String COMPONENTS_ATT = "comps";
    public static final String COMPONENTS_ELEM = "comps";
    public static final String DOMAIN_FILTER_POLICY_ATT = "domain-filter";
    public static final String DOMAIN_FILTER_POLICY_LABEL = "Domain filter policy";
    public static final String ENABLED_ATT = "enabled";
    public static final String ENABLED_LABEL = "Enabled";
    public static final String HOSTNAME_ATT = "hostname";
    public static final String HOSTNAME_LABEL = "Domain name";
    public static final String MAX_USERS_NUMBER_ATT = "max-users";
    public static final String MAX_USERS_NUMBER_LABEL = "Max users";
    public static final String MESSAGE_FORWARD_ADDRESS_ATT = "mess-forw";
    public static final String MESSAGE_FORWARD_ADDRESS_LABEL = "Message forward address";
    public static final String OTHER_PARAMS_ELEM = "other";
    public static final String OTHER_PARAMS_LABEL = "Other parameters";
    public static final String PRESENCE_FORWARD_ADDRESS_ATT = "pres-forw";
    public static final String PRESENCE_FORWARD_ADDRESS_LABEL = "Presence forward address";
    public static final String REGISTER_ENABLED_ATT = "register";
    public static final String REGISTER_ENABLED_LABEL = "In-band registration";
    public static final String S2S_SECRET_ATT = "s2s-secret";
    public static final String S2S_SECRET_LABEL = "S2S secret";
    public static final String TLS_REQUIRED_ATT = "tls-required";
    public static final String TLS_REQUIRED_LABEL = "TLS required";
    public static final String VHOST_ELEM = "vhost";
    protected static final String DOMAIN_FILTER_POLICY_PROP_KEY = "domain-filter-policy";
    protected static final String S2S_SECRET_PROP_DEF = null;
    protected static final String S2S_SECRET_PROP_KEY = "s2s-secret";
    protected static final String VHOST_ANONYMOUS_ENABLED_PROP_KEY = "vhost-anonymous-enabled";
    protected static final Boolean VHOST_ANONYMOUS_ENABLED_PROP_DEF = Boolean.TRUE;
    protected static final String VHOST_MAX_USERS_PROP_KEY = "vhost-max-users";
    protected static final Long VHOST_MAX_USERS_PROP_DEF = 0L;
    protected static final String VHOST_MESSAGE_FORWARD_PROP_DEF = null;
    protected static final String VHOST_MESSAGE_FORWARD_PROP_KEY = "vhost-message-forward-jid";
    protected static final String VHOST_PRESENCE_FORWARD_PROP_DEF = null;
    protected static final String VHOST_PRESENCE_FORWARD_PROP_KEY = "vhost-presence-forward-jid";
    protected static final String VHOST_REGISTER_ENABLED_PROP_KEY = "vhost-register-enabled";
    protected static final Boolean VHOST_REGISTER_ENABLED_PROP_DEF = Boolean.TRUE;
    protected static final String VHOST_TLS_REQUIRED_PROP_KEY = "vhost-tls-required";
    protected static final Boolean VHOST_TLS_REQUIRED_PROP_DEF = Boolean.FALSE;
    protected static final DomainFilterPolicy DOMAIN_FILTER_POLICY_PROP_DEF = DomainFilterPolicy.ALL;
    private static final Logger log = Logger.getLogger(VHostItem.class.getName());
    protected static final String[] VHOST_OTHER_PARAMS_PATH = new String[]{"vhost", "other"};
    protected static final String[] VHOST_COMPONENTS_PATH = new String[]{"vhost", "comps"};
    private String[] comps = null;
    private long maxUsersNumber = Long.getLong("vhost-max-users", VHOST_MAX_USERS_PROP_DEF);
    private JID messageForward = JID.jidInstanceNS(System.getProperty("vhost-message-forward-jid", VHOST_MESSAGE_FORWARD_PROP_DEF));
    private String otherDomainParams = null;
    private JID presenceForward = JID.jidInstanceNS(System.getProperty("vhost-presence-forward-jid", VHOST_PRESENCE_FORWARD_PROP_DEF));
    private VHostItem unmodifiableItem = null;
    private JID vhost = null;
    private boolean tlsRequired = DataTypes.getProperty("vhost-tls-required", VHOST_TLS_REQUIRED_PROP_DEF);
    private String s2sSecret = System.getProperty("s2s-secret", S2S_SECRET_PROP_DEF);
    private boolean registerEnabled = DataTypes.getProperty("vhost-register-enabled", VHOST_REGISTER_ENABLED_PROP_DEF);
    private boolean enabled = true;
    private DomainFilterPolicy domainFilter = DomainFilterPolicy.valueof(System.getProperty("domain-filter-policy", DOMAIN_FILTER_POLICY_PROP_DEF.toString()));
    private boolean anonymousEnabled = DataTypes.getProperty("vhost-anonymous-enabled", VHOST_ANONYMOUS_ENABLED_PROP_DEF);

    public VHostItem() {
    }

    public VHostItem(Element elem) {
        this.initFromElement(elem);
    }

    public VHostItem(JID vhost) {
        this.setVHost(vhost);
    }

    public VHostItem(String vhost) throws TigaseStringprepException {
        this.setVHost(vhost);
    }

    @Override
    public void addCommandFields(Packet packet) {
        Command.addFieldValue(packet, HOSTNAME_LABEL, this.vhost != null ? this.vhost.getDomain() : "");
        Command.addCheckBoxField(packet, ENABLED_LABEL, this.enabled);
        Command.addCheckBoxField(packet, ANONYMOUS_ENABLED_LABEL, this.anonymousEnabled);
        Command.addCheckBoxField(packet, REGISTER_ENABLED_LABEL, this.registerEnabled);
        Command.addCheckBoxField(packet, TLS_REQUIRED_LABEL, this.tlsRequired);
        Command.addFieldValue(packet, S2S_SECRET_LABEL, this.s2sSecret != null ? this.s2sSecret : "");
        Command.addFieldValue(packet, DOMAIN_FILTER_POLICY_LABEL, this.domainFilter.toString(), DOMAIN_FILTER_POLICY_LABEL, DomainFilterPolicy.valuesStr(), DomainFilterPolicy.valuesStr());
        Command.addFieldValue(packet, MAX_USERS_NUMBER_LABEL, "" + this.maxUsersNumber);
        Command.addFieldValue(packet, PRESENCE_FORWARD_ADDRESS_LABEL, this.presenceForward != null ? this.presenceForward.toString() : "");
        Command.addFieldValue(packet, MESSAGE_FORWARD_ADDRESS_LABEL, this.messageForward != null ? this.messageForward.toString() : "");
        Command.addFieldValue(packet, OTHER_PARAMS_LABEL, this.otherDomainParams != null ? this.otherDomainParams : "");
        super.addCommandFields(packet);
    }

    @Override
    public void initFromCommand(Packet packet) {
        super.initFromCommand(packet);
        String tmp = Command.getFieldValue(packet, HOSTNAME_LABEL);
        try {
            this.setVHost(tmp);
        }
        catch (TigaseStringprepException ex) {
            throw new IllegalArgumentException("Incorrect domain, unable to parse it: " + tmp, ex);
        }
        this.enabled = Command.getCheckBoxFieldValue(packet, ENABLED_LABEL);
        this.anonymousEnabled = Command.getCheckBoxFieldValue(packet, ANONYMOUS_ENABLED_LABEL);
        this.registerEnabled = Command.getCheckBoxFieldValue(packet, REGISTER_ENABLED_LABEL);
        this.tlsRequired = Command.getCheckBoxFieldValue(packet, TLS_REQUIRED_LABEL);
        tmp = Command.getFieldValue(packet, S2S_SECRET_LABEL);
        this.s2sSecret = tmp != null && !tmp.trim().isEmpty() ? tmp : null;
        tmp = Command.getFieldValue(packet, DOMAIN_FILTER_POLICY_LABEL);
        try {
            this.domainFilter = DomainFilterPolicy.valueof(tmp);
            if (this.domainFilter == null) {
                this.domainFilter = DomainFilterPolicy.valueof(System.getProperty(DOMAIN_FILTER_POLICY_PROP_KEY, DOMAIN_FILTER_POLICY_PROP_DEF.toString()));
            }
        }
        catch (Exception ex) {
            this.domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
        }
        try {
            this.maxUsersNumber = Long.parseLong(Command.getFieldValue(packet, MAX_USERS_NUMBER_LABEL));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can not parse max users number: {0}", Command.getFieldValue(packet, MAX_USERS_NUMBER_LABEL));
        }
        tmp = Command.getFieldValue(packet, PRESENCE_FORWARD_ADDRESS_LABEL);
        if (tmp != null && !tmp.trim().isEmpty()) {
            try {
                this.presenceForward = JID.jidInstance(tmp);
            }
            catch (TigaseStringprepException ex) {
                this.presenceForward = null;
                throw new IllegalArgumentException("Incorrect presence forward address: " + tmp, ex);
            }
        }
        if ((tmp = Command.getFieldValue(packet, MESSAGE_FORWARD_ADDRESS_LABEL)) != null && !tmp.trim().isEmpty()) {
            try {
                this.messageForward = JID.jidInstance(tmp);
            }
            catch (TigaseStringprepException ex) {
                this.messageForward = null;
                throw new IllegalArgumentException("Incorrect message forward address: " + tmp, ex);
            }
        }
        this.otherDomainParams = Command.getFieldValue(packet, OTHER_PARAMS_LABEL);
    }

    @Override
    public void initFromElement(Element elem) {
        String comps_str;
        if (elem.getName() != VHOST_ELEM) {
            throw new IllegalArgumentException("Incorrect element name, expected: vhost");
        }
        super.initFromElement(elem);
        this.setVHost(JID.jidInstanceNS(elem.getAttributeStaticStr(HOSTNAME_ATT)));
        this.enabled = Boolean.parseBoolean(elem.getAttributeStaticStr(ENABLED_ATT));
        this.anonymousEnabled = Boolean.parseBoolean(elem.getAttributeStaticStr(ANONYMOUS_ENABLED_ATT));
        this.registerEnabled = Boolean.parseBoolean(elem.getAttributeStaticStr(REGISTER_ENABLED_ATT));
        this.tlsRequired = Boolean.parseBoolean(elem.getAttributeStaticStr(TLS_REQUIRED_ATT));
        this.s2sSecret = elem.getAttributeStaticStr("s2s-secret");
        try {
            this.domainFilter = DomainFilterPolicy.valueof(elem.getAttributeStaticStr(DOMAIN_FILTER_POLICY_ATT));
            if (this.domainFilter == null) {
                this.domainFilter = DomainFilterPolicy.valueof(System.getProperty(DOMAIN_FILTER_POLICY_PROP_KEY, DOMAIN_FILTER_POLICY_PROP_DEF.toString()));
            }
        }
        catch (Exception e) {
            this.domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
        }
        try {
            this.maxUsersNumber = Long.parseLong(elem.getAttributeStaticStr(MAX_USERS_NUMBER_ATT));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can not parse max users number: {0}", elem.getAttributeStaticStr(MAX_USERS_NUMBER_ATT));
            this.maxUsersNumber = Long.getLong(VHOST_MAX_USERS_PROP_KEY, VHOST_MAX_USERS_PROP_DEF);
        }
        String tmp = elem.getAttributeStaticStr(PRESENCE_FORWARD_ADDRESS_ATT);
        if (tmp != null && !tmp.trim().isEmpty()) {
            this.presenceForward = JID.jidInstanceNS(tmp);
        }
        if ((tmp = elem.getAttributeStaticStr(MESSAGE_FORWARD_ADDRESS_ATT)) != null && !tmp.trim().isEmpty()) {
            this.messageForward = JID.jidInstanceNS(tmp);
        }
        if ((comps_str = elem.getCDataStaticStr(VHOST_COMPONENTS_PATH)) != null && !comps_str.isEmpty()) {
            this.comps = comps_str.split(",");
        }
        this.otherDomainParams = elem.getCDataStaticStr(VHOST_OTHER_PARAMS_PATH);
    }

    @Override
    public void initFromPropertyString(String propString) {
        String[] props = propString.split(":");
        try {
            this.setVHost(props[0]);
        }
        catch (TigaseStringprepException ex) {
            throw new IllegalArgumentException("Domain misconfiguration, cannot parse it: " + props[0], ex);
        }
        for (String tmp : props) {
            String[] mu;
            String[] c;
            String comps_str;
            boolean val = true;
            if (tmp.startsWith("-")) {
                val = false;
            }
            if (tmp.endsWith(ANONYMOUS_ENABLED_ATT)) {
                this.anonymousEnabled = val;
            }
            if (tmp.endsWith(REGISTER_ENABLED_ATT)) {
                this.registerEnabled = val;
            }
            if (tmp.endsWith(TLS_REQUIRED_ATT)) {
                this.tlsRequired = val;
            }
            if (tmp.startsWith("s2s-secret")) {
                String[] s2 = tmp.split("=");
                this.s2sSecret = s2[1];
            }
            if (tmp.startsWith("comps") && !(comps_str = (c = tmp.split("="))[1]).isEmpty()) {
                this.comps = comps_str.split(";");
            }
            if (tmp.startsWith(DOMAIN_FILTER_POLICY_ATT)) {
                String[] df = tmp.split("=");
                try {
                    this.domainFilter = DomainFilterPolicy.valueof(df[1]);
                    if (this.domainFilter == null) {
                        this.domainFilter = DomainFilterPolicy.valueof(System.getProperty(DOMAIN_FILTER_POLICY_PROP_KEY, DOMAIN_FILTER_POLICY_PROP_DEF.toString()));
                    }
                }
                catch (Exception e) {
                    this.domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
                }
            }
            if (tmp.startsWith(MAX_USERS_NUMBER_ATT)) {
                mu = tmp.split("=");
                try {
                    this.maxUsersNumber = Long.parseLong(mu[1]);
                }
                catch (NumberFormatException ex) {
                    this.maxUsersNumber = 0L;
                    log.log(Level.WARNING, "Incorrect max users number for vhost settings, number parsing error: {0}", tmp);
                }
            }
            if (tmp.startsWith(PRESENCE_FORWARD_ADDRESS_ATT)) {
                mu = tmp.split("=");
                try {
                    this.presenceForward = JID.jidInstance(mu[1]);
                }
                catch (TigaseStringprepException ex) {
                    this.presenceForward = null;
                    log.log(Level.WARNING, "Incorrect presence forwarding address, address parsing error: {0}", tmp);
                }
            }
            if (!tmp.startsWith(MESSAGE_FORWARD_ADDRESS_ATT)) continue;
            mu = tmp.split("=");
            try {
                this.messageForward = JID.jidInstance(mu[1]);
            }
            catch (TigaseStringprepException ex) {
                this.messageForward = null;
                log.log(Level.WARNING, "Incorrect presence forwarding address, address parsing error: {0}", tmp);
            }
        }
    }

    @Override
    public Element toElement() {
        Element elem = super.toElement();
        String comps_str = "";
        if (this.comps != null && this.comps.length > 0) {
            for (String comp : this.comps) {
                if (!comps_str.isEmpty()) {
                    comps_str = comps_str + ",";
                }
                comps_str = comps_str + comp;
            }
        }
        String other_params = this.otherDomainParams != null ? this.otherDomainParams : "";
        elem.addChild(new Element("comps", comps_str));
        elem.addChild(new Element(OTHER_PARAMS_ELEM, other_params));
        elem.addAttribute(HOSTNAME_ATT, this.vhost.getDomain());
        elem.addAttribute(ENABLED_ATT, "" + this.enabled);
        elem.addAttribute(ANONYMOUS_ENABLED_ATT, "" + this.anonymousEnabled);
        elem.addAttribute(REGISTER_ENABLED_ATT, "" + this.registerEnabled);
        elem.addAttribute(TLS_REQUIRED_ATT, "" + this.tlsRequired);
        if (this.s2sSecret != null) {
            elem.addAttribute("s2s-secret", this.s2sSecret);
        }
        if (this.domainFilter != null) {
            elem.addAttribute(DOMAIN_FILTER_POLICY_ATT, this.domainFilter.toString());
        }
        elem.addAttribute(MAX_USERS_NUMBER_ATT, "" + this.maxUsersNumber);
        if (this.presenceForward != null) {
            elem.addAttribute(PRESENCE_FORWARD_ADDRESS_ATT, this.presenceForward.toString());
        }
        if (this.messageForward != null) {
            elem.addAttribute(MESSAGE_FORWARD_ADDRESS_ATT, this.messageForward.toString());
        }
        return elem;
    }

    @Override
    public String toPropertyString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.vhost.toString());
        if (!this.anonymousEnabled) {
            sb.append(":-").append(ANONYMOUS_ENABLED_ATT);
        }
        if (!this.registerEnabled) {
            sb.append(":-").append(REGISTER_ENABLED_ATT);
        }
        if (!this.tlsRequired) {
            sb.append(":-").append(TLS_REQUIRED_ATT);
        }
        if (this.s2sSecret != null) {
            sb.append(':').append("s2s-secret").append('=').append(this.s2sSecret);
        }
        sb.append(':').append(DOMAIN_FILTER_POLICY_ATT).append('=').append(this.domainFilter.toString());
        if (this.maxUsersNumber > 0L) {
            sb.append(':').append(MAX_USERS_NUMBER_ATT).append('=').append(this.maxUsersNumber);
        }
        if (this.presenceForward != null) {
            sb.append(':').append(PRESENCE_FORWARD_ADDRESS_ATT).append('=').append(this.presenceForward.toString());
        }
        if (this.messageForward != null) {
            sb.append(':').append(MESSAGE_FORWARD_ADDRESS_ATT).append('=').append(this.messageForward.toString());
        }
        return sb.toString();
    }

    public String toString() {
        return "Domain: " + this.vhost + ", enabled: " + this.enabled + ", anonym: " + this.anonymousEnabled + ", register: " + this.registerEnabled + ", maxusers: " + this.maxUsersNumber + ", tls: " + this.tlsRequired + ", s2sSecret: " + this.s2sSecret + ", domainFilter: " + (Object)((Object)this.domainFilter);
    }

    public String[] getComps() {
        return this.comps;
    }

    public DomainFilterPolicy getDomainFilter() {
        if (this.domainFilter == null) {
            this.domainFilter = DomainFilterPolicy.valueof(System.getProperty(DOMAIN_FILTER_POLICY_PROP_KEY, DOMAIN_FILTER_POLICY_PROP_DEF.toString()));
        }
        return this.domainFilter;
    }

    @Override
    public String getElemName() {
        return VHOST_ELEM;
    }

    @Override
    public String getKey() {
        return this.vhost.getDomain();
    }

    public long getMaxUsersNumber() {
        return this.maxUsersNumber;
    }

    public JID getMessageForward() {
        return this.messageForward;
    }

    public JID getMessageForwardAddress() {
        return this.presenceForward;
    }

    public String getOtherDomainParams() {
        return this.otherDomainParams;
    }

    public JID getPresenceForward() {
        return this.presenceForward;
    }

    public JID getPresenceForwardAddress() {
        return this.presenceForward;
    }

    public String getS2sSecret() {
        return this.s2sSecret;
    }

    public VHostItem getUnmodifiableVHostItem() {
        if (this.unmodifiableItem == null) {
            this.unmodifiableItem = new UnmodifiableVHostItem();
        }
        return this.unmodifiableItem;
    }

    public JID getVhost() {
        return this.vhost;
    }

    public boolean isAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public boolean isTlsRequired() {
        return this.tlsRequired || XMPPServer.isHardenedModeEnabled();
    }

    public void setAnonymousEnabled(boolean value) {
        this.anonymousEnabled = value;
    }

    public void setComps(String[] comps) {
        this.comps = comps;
    }

    public void setDomainFilter(DomainFilterPolicy domainFilter) {
        this.domainFilter = domainFilter;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public void setMaxUsersNumber(long maxUsersNumber) {
        this.maxUsersNumber = maxUsersNumber;
    }

    public void setMessageForward(JID messageForward) {
        this.messageForward = messageForward;
    }

    public void setOtherDomainParams(String otherParams) {
        this.otherDomainParams = otherParams;
    }

    public void setPresenceForward(JID presenceForward) {
        this.presenceForward = presenceForward;
    }

    public void setRegisterEnabled(boolean value) {
        this.registerEnabled = value;
    }

    public void setS2sSecret(String s2sSecret) {
        this.s2sSecret = s2sSecret;
    }

    public void setTlsRequired(boolean value) {
        this.tlsRequired = value;
    }

    public void setVHost(String vhost) throws TigaseStringprepException {
        if (vhost == null) {
            vhost = "";
        }
        this.vhost = JID.jidInstance(vhost);
    }

    public void setVHost(JID vhost) {
        this.vhost = vhost;
    }

    private class UnmodifiableVHostItem
    extends VHostItem {
        private UnmodifiableVHostItem() {
        }

        @Override
        public void initFromElement(Element elem) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void initFromPropertyString(String propString) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public Element toElement() {
            return VHostItem.this.toElement();
        }

        @Override
        public String toString() {
            return VHostItem.this.toString();
        }

        @Override
        public String[] getComps() {
            return VHostItem.this.getComps();
        }

        @Override
        public DomainFilterPolicy getDomainFilter() {
            return VHostItem.this.getDomainFilter();
        }

        @Override
        public long getMaxUsersNumber() {
            return VHostItem.this.getMaxUsersNumber();
        }

        @Override
        public JID getMessageForward() {
            return VHostItem.this.messageForward;
        }

        @Override
        public String getOtherDomainParams() {
            return VHostItem.this.getOtherDomainParams();
        }

        @Override
        public JID getPresenceForward() {
            return VHostItem.this.presenceForward;
        }

        @Override
        public String getS2sSecret() {
            return VHostItem.this.getS2sSecret();
        }

        @Override
        public VHostItem getUnmodifiableVHostItem() {
            return this;
        }

        @Override
        public JID getVhost() {
            return VHostItem.this.getVhost();
        }

        @Override
        public boolean isAnonymousEnabled() {
            return VHostItem.this.isAnonymousEnabled();
        }

        @Override
        public boolean isEnabled() {
            return VHostItem.this.isEnabled();
        }

        @Override
        public boolean isRegisterEnabled() {
            return VHostItem.this.isRegisterEnabled();
        }

        @Override
        public boolean isTlsRequired() {
            return VHostItem.this.isTlsRequired();
        }

        @Override
        public void setAnonymousEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setComps(String[] comps) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setDomainFilter(DomainFilterPolicy filter) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setMaxUsersNumber(long maxUsersNumber) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setMessageForward(JID messageForward) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setOtherDomainParams(String otherParams) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setPresenceForward(JID presenceForward) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setRegisterEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setS2sSecret(String s2sSecret) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setTlsRequired(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }
    }
}

