/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.HashMap;
import tigase.server.XMPPServer;
import tigase.xml.Element;

public class ComponentInfo {
    private String name = null;
    private String title;
    private String version;
    private String cls;
    private HashMap<String, Object> cmpData;

    public ComponentInfo(String cmpTitle, String cmpVersion, String cmpCls) {
        this(null, cmpTitle, cmpVersion, cmpCls);
    }

    public ComponentInfo(String cmpName, String cmpTitle, String cmpVersion, String cmpCls) {
        this(null, cmpTitle, cmpVersion, cmpCls, new HashMap<String, Object>());
    }

    public ComponentInfo(String cmpName, String cmpTitle, String cmpVersion, String cmpCls, HashMap<String, Object> cmpData) {
        this.name = cmpName;
        this.title = cmpTitle;
        this.version = cmpVersion;
        this.cls = cmpCls;
        this.cmpData = cmpData;
    }

    public ComponentInfo(Class<?> c) {
        this(null, c);
    }

    public ComponentInfo(String cmpName, Class<?> c) {
        this.name = cmpName;
        this.title = ComponentInfo.getImplementationTitle(c);
        this.version = ComponentInfo.getImplementationVersion(c);
        this.cls = c.getName();
        this.cmpData = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public String getComponentTitle() {
        return this.title;
    }

    public String getComponentVersion() {
        return this.version;
    }

    public String getComponentClass() {
        return this.cls;
    }

    public HashMap<String, Object> getComponentData() {
        return this.cmpData;
    }

    public String toString() {
        return (this.name == null ? "" : this.name + " :: ") + "componentInfo{" + (this.title.isEmpty() ? "" : "Title=" + this.title + ", ") + (this.version.isEmpty() ? "" : "Version=" + this.version + ", ") + "Class=" + this.cls + (this.cmpData.isEmpty() ? "" : ", componentData=" + this.cmpData) + '}';
    }

    public Element toElement() {
        Element cmpInfo = new Element("cmpInfo");
        if (this.name != null) {
            cmpInfo.addChild(new Element("name", this.name));
        }
        if (!this.title.isEmpty()) {
            cmpInfo.addChild(new Element("title", this.title));
        }
        if (!this.version.isEmpty()) {
            cmpInfo.addChild(new Element("version", this.version));
        }
        if (!this.cls.isEmpty()) {
            cmpInfo.addChild(new Element("class", this.cls));
        }
        if (!this.cmpData.isEmpty()) {
            Element data = new Element("cmpData");
            for (String key : this.cmpData.keySet()) {
                data.addChild(new Element(key, this.cmpData.get(key).toString()));
            }
            cmpInfo.addChild(data);
        }
        return cmpInfo;
    }

    public static Package getImplementation(Class<?> c) {
        return c.getPackage() == null ? XMPPServer.class.getPackage() : c.getPackage();
    }

    public static String getImplementationVersion(Class<?> c) {
        Package p = ComponentInfo.getImplementation(c);
        String version = p == null ? null : p.getImplementationVersion();
        return version == null ? "" : version;
    }

    public static String getImplementationTitle(Class<?> c) {
        Package p = ComponentInfo.getImplementation(c);
        String title = p == null ? null : p.getImplementationTitle();
        return title == null ? "" : title;
    }

    public static String getImplementationInfo(Class<?> c) {
        return ComponentInfo.getImplementationTitle(c) + ", version: " + ComponentInfo.getImplementationVersion(c);
    }
}

