/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.cluster.strategy.ConnectionRecord;
import tigase.cluster.strategy.ConnectionRecordIfc;
import tigase.cluster.strategy.cmd.PacketForwardCmd;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

public class DefaultClusteringStrategyAbstract<E extends ConnectionRecordIfc>
implements ClusteringStrategyIfc<E> {
    private static final Logger log = Logger.getLogger(DefaultClusteringStrategyAbstract.class.getName());
    private static final String PACKET_FORWARD_CMD = "packet-forward-sm-cmd";
    protected ClusterControllerIfc cluster = null;
    protected SessionManagerClusteredIfc sm = null;
    protected CopyOnWriteArrayList<JID> cl_nodes_list = new CopyOnWriteArrayList();
    private Set<CommandListener> commands = new CopyOnWriteArraySet<CommandListener>();

    public final void addCommandListener(CommandListener cmd) {
        this.commands.add(cmd);
    }

    @Override
    public boolean containsJid(BareJID jid) {
        return false;
    }

    @Override
    public void handleLocalPacket(Packet packet, XMPPResourceConnection conn) {
    }

    @Override
    public void handleLocalUserLogin(BareJID userId, XMPPResourceConnection conn) {
    }

    @Override
    public void handleLocalUserLogout(BareJID userId, XMPPResourceConnection conn) {
    }

    @Override
    public void nodeConnected(JID jid) {
        boolean result = this.cl_nodes_list.addIfAbsent(jid);
        log.log(Level.FINE, "Cluster nodes: {0}, added: {1}", new Object[]{this.cl_nodes_list, result});
    }

    @Override
    public void nodeDisconnected(JID jid) {
        boolean result = this.cl_nodes_list.remove(jid);
        log.log(Level.FINE, "Cluster nodes: {0}, removed: {1}", new Object[]{this.cl_nodes_list, result});
    }

    @Override
    public boolean processPacket(Packet packet, XMPPResourceConnection conn) {
        boolean result;
        List<JID> toNodes = this.getNodesForPacketForward(this.sm.getComponentId(), null, packet);
        boolean bl = result = toNodes != null && toNodes.size() > 0;
        if (result) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Forwarding packet {0} to nodes: {1}", new Object[]{packet, toNodes});
            }
            LinkedHashMap<String, String> data = null;
            if (conn != null) {
                data = new LinkedHashMap<String, String>();
                data.put("user-session-found-key", this.sm.getComponentId().toString());
            }
            this.cluster.sendToNodes(PACKET_FORWARD_CMD, data, packet.getElement(), this.sm.getComponentId(), null, toNodes.toArray(new JID[toNodes.size()]));
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No cluster nodes found for packet forward: {0}", new Object[]{packet});
        }
        return result;
    }

    public boolean sendToNextNode(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Packet packet) {
        boolean result = false;
        List<JID> nextNodes = this.getNodesForPacketForward(fromNode, visitedNodes, packet);
        if (nextNodes != null && nextNodes.size() > 0) {
            this.cluster.sendToNodes(PACKET_FORWARD_CMD, data, packet.getElement(), fromNode, visitedNodes, nextNodes.toArray(new JID[nextNodes.size()]));
            result = true;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for packet: {0}, visitedNodes: {1}, result: {2}", new Object[]{packet, visitedNodes, result});
        }
        return result;
    }

    public String toString() {
        return this.getInfo();
    }

    @Override
    public List<JID> getAllNodes() {
        return this.cl_nodes_list;
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        return null;
    }

    @Override
    public E getConnectionRecord(JID jid) {
        return null;
    }

    @Override
    public E getConnectionRecordInstance() {
        return (E)new ConnectionRecord();
    }

    @Override
    public Set<E> getConnectionRecords(BareJID bareJID) {
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        return null;
    }

    @Override
    public String getInfo() {
        return "basic strategy";
    }

    @Override
    @Deprecated
    public Object getInternalCacheData() {
        return null;
    }

    public List<JID> getNodesForPacketForward(JID fromNode, Set<JID> visitedNodes, Packet packet) {
        if (visitedNodes != null) {
            return null;
        }
        List<JID> nodes = null;
        if (this.isSuitableForForward(packet)) {
            nodes = this.getAllNodes();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Selected nodes: {0}, for packet: {1}", new Object[]{nodes, packet});
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Packet not suitable for forwarding: {0}", new Object[]{packet});
        }
        return nodes;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add("cluster-strat", "Connected nodes", this.cl_nodes_list.size(), Level.INFO);
        for (CommandListener cmd : this.commands) {
            cmd.getStatistics(list);
        }
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return false;
    }

    @Override
    public void setClusterController(ClusterControllerIfc clComp) {
        this.cluster = clComp;
        for (CommandListener cmd : this.commands) {
            this.cluster.removeCommandListener(cmd);
            this.cluster.setCommandListener(cmd);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.addCommandListener(new PacketForwardCmd(PACKET_FORWARD_CMD, this.sm, this));
    }

    @Override
    public void setSessionManagerHandler(SessionManagerClusteredIfc sm) {
        this.sm = sm;
    }

    protected boolean isSuitableForForward(Packet packet) {
        if (packet.getType() == StanzaType.error) {
            return false;
        }
        if (packet.getPacketFrom() != null && !this.sm.getComponentId().equals(packet.getPacketFrom())) {
            return false;
        }
        if (packet.getStanzaTo() == null || this.sm.isLocalDomain(packet.getStanzaTo().toString(), false) || this.sm.getComponentId().getBareJID().equals(packet.getStanzaTo().getBareJID())) {
            return false;
        }
        if (packet.getStanzaFrom() == null || this.sm.isLocalDomain(packet.getStanzaFrom().toString(), false) || this.sm.getComponentId().getBareJID().equals(packet.getStanzaFrom().getBareJID())) {
            return false;
        }
        return this.sm.isLocalDomain(packet.getStanzaTo().getDomain(), false);
    }
}

