/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.cluster.strategy.ConnectionRecordIfc;
import tigase.cluster.strategy.DefaultClusteringStrategyAbstract;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class DefaultClusteringStrategy<E extends ConnectionRecordIfc>
extends DefaultClusteringStrategyAbstract<E> {
    private static final Logger log = Logger.getLogger(DefaultClusteringStrategy.class.getName());
    private static final String USER_CONNECTED_CMD = "user-connected-sm-cmd";
    private static final String USER_PRESENCE_CMD = "user-presence-sm-cmd";
    private static final String AUTH_TIME = "auth-time";
    public static final String CONNECTION_ID = "connectionId";
    public static final String RESOURCE = "resource";
    public static final String SM_ID = "smId";
    public static final String USER_ID = "userId";
    public static final String XMPP_SESSION_ID = "xmppSessionId";
    private static final String INITIAL_PRESENCE_KEY = "cluster-initial-presence";
    private static final String PRESENCE_TYPE_KEY = "presence-type";
    private static final String PRESENCE_TYPE_INITIAL = "initial";
    private static final String PRESENCE_TYPE_UPDATE = "update";
    private Random rand = new Random();

    public DefaultClusteringStrategy() {
        this.addCommandListener(new UserPresenceCommand(USER_PRESENCE_CMD));
        this.addCommandListener(new UserConnectedCommand(USER_CONNECTED_CMD));
    }

    @Override
    public List<JID> getNodesForPacketForward(JID fromNode, Set<JID> visitedNodes, Packet packet) {
        if (visitedNodes != null) {
            List<JID> result = this.selectNodes(fromNode, visitedNodes);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Visited nodes not null: {0}, selecting new node: {1}, for packet: {2}", new Object[]{visitedNodes, result, packet});
            }
            return result;
        }
        if (packet.getElemName() == "presence" && packet.getType() != StanzaType.error && packet.getStanzaFrom() != null && packet.getStanzaTo() == null) {
            List<JID> result = this.getAllNodes();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Presence packet found: {0}, selecting all nodes: {1}", new Object[]{packet, result});
            }
            return result;
        }
        if (this.isSuitableForForward(packet)) {
            List<JID> result = this.selectNodes(fromNode, visitedNodes);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Visited nodes null, selecting new node: {0}, for packet: {1}", new Object[]{result, packet});
            }
            return result;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Packet not suitable for forwarding: {0}", new Object[]{packet});
        }
        return null;
    }

    @Override
    public void handleLocalPacket(Packet packet, XMPPResourceConnection conn) {
        if (packet.getElemName() == "presence") {
            try {
                if (packet.getStanzaFrom() != null && !conn.isUserId(packet.getStanzaFrom().getBareJID())) {
                    return;
                }
                boolean initPresence = conn.getSessionData(INITIAL_PRESENCE_KEY) == null;
                Map<String, String> params = this.prepareConnectionParams(conn);
                if (initPresence) {
                    conn.putSessionData(INITIAL_PRESENCE_KEY, INITIAL_PRESENCE_KEY);
                    params.put(PRESENCE_TYPE_KEY, PRESENCE_TYPE_INITIAL);
                } else {
                    params.put(PRESENCE_TYPE_KEY, PRESENCE_TYPE_UPDATE);
                }
                Element presence = packet.getElement();
                List<JID> cl_nodes = this.getNodesForPacketForward(this.sm.getComponentId(), null, Packet.packetInstance(presence));
                if (cl_nodes != null && cl_nodes.size() > 0) {
                    this.cluster.sendToNodes(USER_PRESENCE_CMD, params, presence, this.sm.getComponentId(), null, cl_nodes.toArray(new JID[cl_nodes.size()]));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem with broadcast user presence for: " + conn, e);
            }
        }
        if (packet.isXMLNSStaticStr(Iq.IQ_BIND_RESOURCE_PATH, "urn:ietf:params:xml:ns:xmpp-bind")) {
            try {
                Map<String, String> params = this.prepareConnectionParams(conn);
                List<JID> cl_nodes = this.getAllNodes();
                this.cluster.sendToNodes(USER_CONNECTED_CMD, params, this.sm.getComponentId(), cl_nodes.toArray(new JID[cl_nodes.size()]));
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem with broadcast user presence for: " + conn, e);
            }
        }
        super.handleLocalPacket(packet, conn);
    }

    @Override
    public void handleLocalUserLogout(BareJID userId, XMPPResourceConnection conn) {
        try {
            if (!conn.isAuthorized()) {
                return;
            }
            Element presence = conn.getPresence();
            if (presence == null) {
                presence = new Element("presence");
                presence.setXMLNS("jabber:client");
            } else {
                presence = presence.clone();
            }
            presence.setAttribute("from", conn.getJID().toString());
            presence.setAttribute("type", StanzaType.unavailable.name());
            Map<String, String> params = this.prepareConnectionParams(conn);
            List<JID> cl_nodes = this.getAllNodes();
            if (cl_nodes != null && cl_nodes.size() > 0) {
                this.cluster.sendToNodes(USER_PRESENCE_CMD, params, presence, this.sm.getComponentId(), null, cl_nodes.toArray(new JID[cl_nodes.size()]));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with broadcast user presence for: " + conn, e);
        }
    }

    protected Map<String, String> prepareConnectionParams(XMPPResourceConnection conn) throws NotAuthorizedException, NoConnectionIdException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(USER_ID, conn.getBareJID().toString());
        params.put(RESOURCE, conn.getResource());
        params.put(CONNECTION_ID, conn.getConnectionId().toString());
        params.put(XMPP_SESSION_ID, conn.getSessionId());
        params.put(AUTH_TIME, "" + conn.getAuthTime());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for conn: {0}, result: ", new Object[]{conn, params});
        }
        return params;
    }

    protected ConnectionRecordIfc getConnectionRecord(JID node, Map<String, String> data) {
        BareJID userId = BareJID.bareJIDInstanceNS(data.get(USER_ID));
        String resource = data.get(RESOURCE);
        JID jid = JID.jidInstanceNS(userId, resource);
        String sessionId = data.get(XMPP_SESSION_ID);
        JID connectionId = JID.jidInstanceNS(data.get(CONNECTION_ID));
        Object rec = this.getConnectionRecordInstance();
        rec.setRecordFields(node, jid, sessionId, connectionId);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "ConnectionRecord created: {0}", new Object[]{rec});
        }
        return rec;
    }

    private List<JID> selectNodes(JID fromNode, Set<JID> visitedNodes) {
        List<JID> result;
        block13: {
            result = null;
            int size = this.cl_nodes_list.size();
            if (size == 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No connected cluster nodes found, returning null");
                }
                return null;
            }
            int idx = this.rand.nextInt(size);
            if (visitedNodes == null || visitedNodes.size() == 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No visited nodes yet, trying random idx: " + idx);
                }
                try {
                    result = Collections.singletonList(this.cl_nodes_list.get(idx));
                }
                catch (IndexOutOfBoundsException ioobe) {
                    try {
                        result = Collections.singletonList(this.cl_nodes_list.get(0));
                        break block13;
                    }
                    catch (IndexOutOfBoundsException ioobe2) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "IndexOutOfBoundsException twice! Should not happen very often, returning null");
                        }
                        break block13;
                    }
                }
            }
            for (JID jid : this.cl_nodes_list) {
                if (visitedNodes.contains(jid)) continue;
                result = Collections.singletonList(jid);
                break;
            }
            if (result == null && !this.sm.getComponentId().equals(fromNode)) {
                result = Collections.singletonList(fromNode);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "All nodes visited, sending it back to the first node: " + result);
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "List of result nodes: " + result);
        }
        return result;
    }

    private class UserConnectedCommand
    extends CommandListenerAbstract {
        public UserConnectedCommand(String name) {
            super(name);
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            XMPPResourceConnection conn;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            ConnectionRecordIfc rec = DefaultClusteringStrategy.this.getConnectionRecord(fromNode, data);
            XMPPSession session = DefaultClusteringStrategy.this.sm.getXMPPSessions().get(rec.getUserJid().getBareJID());
            if (session != null && (conn = session.getResourceForResource(rec.getUserJid().getResource())) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Duplicate resource connection, logingout the older connection: " + rec);
                }
                try {
                    Packet cmd = Command.CLOSE.getPacket(DefaultClusteringStrategy.this.sm.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId());
                    Element err_el = new Element("conflict");
                    err_el.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
                    cmd.getElement().getChild("command").addChild(err_el);
                    DefaultClusteringStrategy.this.sm.fastAddOutPacket(cmd);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("User connected jid: " + rec.getUserJid() + ", fromNode: " + fromNode);
            }
        }
    }

    private class UserPresenceCommand
    extends CommandListenerAbstract {
        public UserPresenceCommand(String name) {
            super(name);
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            ConnectionRecordIfc rec = DefaultClusteringStrategy.this.getConnectionRecord(fromNode, data);
            XMPPSession session = DefaultClusteringStrategy.this.sm.getXMPPSessions().get(rec.getUserJid().getBareJID());
            Element elem = packets.poll();
            if (session != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "User's {0} XMPPSession found: {1}", new Object[]{rec.getUserJid().getBareJID(), session});
                }
                for (XMPPResourceConnection conn : session.getActiveResources()) {
                    Element conn_presence = conn.getPresence();
                    if (!conn.isAuthorized() || !conn.isResourceSet() || conn_presence == null) continue;
                    try {
                        Packet presence = Packet.packetInstance(elem);
                        presence.setPacketTo(conn.getConnectionId());
                        DefaultClusteringStrategy.this.sm.fastAddOutPacket(presence);
                        if (data == null || !DefaultClusteringStrategy.PRESENCE_TYPE_INITIAL.equals(data.get(DefaultClusteringStrategy.PRESENCE_TYPE_KEY))) continue;
                        presence = Packet.packetInstance(conn_presence);
                        presence.setPacketTo(rec.getConnectionId());
                        DefaultClusteringStrategy.this.sm.fastAddOutPacket(presence);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                DefaultClusteringStrategy.this.sm.processPresenceUpdate(session, elem);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "No user session for presence update: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("User presence jid: " + rec.getUserJid() + ", fromNode: " + fromNode);
            }
        }
    }
}

