/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeFormatter {
    private static final String DATE = "(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)";
    private static final String TIME = "(\\d\\d):(\\d\\d):(\\d\\d)";
    private static final String TIME_ZONE = "(([+-]\\d\\d:\\d\\d)|Z)";
    private final DateFormat dateFormat;
    private final Pattern datePattern;
    private final DateFormat dateTimeFormatUTC;
    private final Pattern dateTimePattern;
    private final DateFormat timeFormatUTC;
    private final Pattern timePattern;
    private final TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");

    public DateTimeFormatter() {
        this.dateTimePattern = Pattern.compile("^(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(([+-]\\d\\d:\\d\\d)|Z)$");
        this.datePattern = Pattern.compile("^(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)$");
        this.timePattern = Pattern.compile("^(\\d\\d):(\\d\\d):(\\d\\d)(([+-]\\d\\d:\\d\\d)|Z)?$");
        this.dateTimeFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.dateTimeFormatUTC.setTimeZone(this.timeZoneUTC);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormat.setTimeZone(this.timeZoneUTC);
        this.timeFormatUTC = new SimpleDateFormat("HH:mm:ss'Z'");
        this.timeFormatUTC.setTimeZone(this.timeZoneUTC);
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String formatDateTime(Date date) {
        return this.dateTimeFormatUTC.format(date);
    }

    public String formatTime(Date date) {
        return this.timeFormatUTC.format(date);
    }

    public Calendar parseDateTime(String value) {
        Matcher m = this.dateTimePattern.matcher(value);
        if (m.find()) {
            int yyyy = Integer.valueOf(m.group(1));
            int MM = Integer.valueOf(m.group(2));
            int dd = Integer.valueOf(m.group(3));
            int hh = Integer.valueOf(m.group(4));
            int mm = Integer.valueOf(m.group(5));
            int ss = Integer.valueOf(m.group(6));
            String tzValue = m.group(7);
            TimeZone tz = tzValue.equals("Z") ? this.timeZoneUTC : TimeZone.getTimeZone("GMT" + tzValue);
            Calendar calendar = Calendar.getInstance(tz);
            calendar.clear();
            calendar.set(yyyy, MM - 1, dd, hh, mm, ss);
            return calendar;
        }
        m = this.datePattern.matcher(value);
        if (m.find()) {
            int yyyy = Integer.valueOf(m.group(1));
            int MM = Integer.valueOf(m.group(2));
            int dd = Integer.valueOf(m.group(3));
            Calendar calendar = Calendar.getInstance(this.timeZoneUTC);
            calendar.clear();
            calendar.set(yyyy, MM - 1, dd);
            return calendar;
        }
        m = this.timePattern.matcher(value);
        if (m.find()) {
            int hh = Integer.valueOf(m.group(1));
            int mm = Integer.valueOf(m.group(2));
            int ss = Integer.valueOf(m.group(3));
            String tzValue = m.group(4);
            TimeZone tz = tzValue == null || tzValue.equals("Z") ? this.timeZoneUTC : TimeZone.getTimeZone("GMT" + tzValue);
            Calendar calendar = Calendar.getInstance(tz);
            calendar.clear();
            calendar.set(13, ss);
            calendar.set(12, mm);
            calendar.set(11, hh);
            return calendar;
        }
        throw new IllegalArgumentException("Can't parse datetime, date or time: " + value);
    }
}

