/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.cluster.strategy.ConnectionRecord;
import tigase.server.Command;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsList;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class SessionManagerClustered
extends SessionManager
implements ClusteredComponentIfc {
    private static final Logger log = Logger.getLogger(SessionManagerClustered.class.getName());
    private static final String USER_CONNECTED_CMD = "user-connected-sm-cmd";
    private static final String USER_DISCONNECTED_CMD = "user-disconnected-sm-cmd";
    private static final String USER_PRESENCE_CMD = "user-presence-sm-cmd";
    private static final String PACKET_FORWARD_CMD = "packet-forward-sm-cmd";
    private static final String REQUEST_SYNCONLINE_CMD = "req-sync-online-sm-cmd";
    private static final String RESPOND_SYNCONLINE_CMD = "resp-sync-online-sm-cmd";
    private static final String AUTH_TIME = "auth-time";
    public static final String CLUSTER_STRATEGY_VAR = "clusterStrategy";
    private static final String PRESENCE_ELEMENT_NAME = "presence";
    public static final String CONNECTION_ID = "connectionId";
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    public static final String RESOURCE = "resource";
    public static final String SM_ID = "smId";
    public static final String STRATEGY_CLASS_PROPERTY = "--sm-cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_KEY = "sm-cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_VAL = "tigase.cluster.strategy.SMNonCachingAllNodes";
    public static final int SYNC_MAX_BATCH_SIZE = 1000;
    public static final String USER_ID = "userId";
    public static final String XMPP_SESSION_ID = "xmppSessionId";
    private static final String SESSION_FOUND_KEY = "user-session-found-key";
    private static final String INITIAL_PRESENCE_KEY = "cluster-initial-presence";
    private static final String PRESENCE_TYPE_KEY = "presence-type";
    private static final String PRESENCE_TYPE_INITIAL = "initial";
    private static final String PRESENCE_TYPE_UPDATE = "update";
    private long clusterSyncInTraffic = 0L;
    private long clusterSyncOutTraffic = 0L;
    private JID my_address = null;
    private JID my_hostname = null;
    private int nodesNo = 0;
    private ClusteringStrategyIfc strategy = null;
    private ClusterControllerIfc clusterController = null;
    private CommandListener userConnected = new UserConnectedCommand();
    private CommandListener userDisconnected = new UserDisconnectedCommand();
    private CommandListener userPresence = new UserPresenceCommand();
    private CommandListener packetForward = new PacketForwardCommand();
    private CommandListener respondSyncOnline = new RespondSyncOnlineCommand();
    private CommandListener requestSyncOnline = new RequestSyncOnlineCommand();

    @Override
    public boolean containsJid(BareJID jid) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for jid: {0}", jid);
        }
        return super.containsJid(jid) || this.strategy.containsJid(jid);
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        Object[] ids = super.getConnectionIdsForJid(jid);
        if (ids == null) {
            ids = this.strategy.getConnectionIdsForJid(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for jid: {0}, results: {1}", new Object[]{jid, Arrays.toString(ids)});
        }
        return ids;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String strategy_class = (String)params.get(STRATEGY_CLASS_PROPERTY);
        if (strategy_class == null) {
            strategy_class = STRATEGY_CLASS_PROP_VAL;
        }
        props.put(STRATEGY_CLASS_PROP_KEY, strategy_class);
        try {
            ClusteringStrategyIfc strat_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            Map<String, Object> strat_defs = strat_tmp.getDefaults(params);
            if (strat_defs != null) {
                props.putAll(strat_defs);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate clustering strategy for class: " + strategy_class, e);
        }
        String[] local_domains = DNSResolver.getDefHostNames();
        if (params.get("--virt-hosts") != null) {
            local_domains = ((String)params.get("--virt-hosts")).split(",");
        }
        props.put(MY_DOMAIN_NAME_PROP_KEY, local_domains[0]);
        if (params.get("--cluster-nodes") != null) {
            String[] cl_nodes = ((String)params.get("--cluster-nodes")).split(",");
            this.nodesNo = cl_nodes.length;
        }
        return props;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.strategy.getStatistics(list);
        list.add(this.getName(), "Cluster sync IN traffic", this.clusterSyncInTraffic, Level.FINE);
        list.add(this.getName(), "Cluster sync OUT traffic", this.clusterSyncOutTraffic, Level.FINE);
    }

    public ClusteringStrategyIfc getStrategy() {
        return this.strategy;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(CLUSTER_STRATEGY_VAR, (Object)this.strategy);
    }

    @Override
    public void handlePresenceSet(XMPPResourceConnection conn) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for conn: {0}", new Object[]{conn});
        }
        super.handlePresenceSet(conn);
        try {
            boolean initPresence = conn.getSessionData(INITIAL_PRESENCE_KEY) == null;
            Map<String, String> params = this.prepareConnectionParams(conn);
            if (initPresence) {
                conn.putSessionData(INITIAL_PRESENCE_KEY, INITIAL_PRESENCE_KEY);
                params.put(PRESENCE_TYPE_KEY, PRESENCE_TYPE_INITIAL);
            } else {
                params.put(PRESENCE_TYPE_KEY, PRESENCE_TYPE_UPDATE);
            }
            Element presence = conn.getPresence();
            List<JID> cl_nodes = this.strategy.getNodesForPacketForward(this.getComponentId(), null, Packet.packetInstance(presence));
            if (cl_nodes != null && cl_nodes.size() > 0) {
                ++this.clusterSyncOutTraffic;
                this.clusterController.sendToNodes(USER_PRESENCE_CMD, params, presence, this.getComponentId(), null, cl_nodes.toArray(new JID[cl_nodes.size()]));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with broadcast user presence for: " + conn, e);
        }
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for conn: {0}", new Object[]{conn});
        }
        super.handleResourceBind(conn);
        try {
            Map<String, String> params = this.prepareConnectionParams(conn);
            List<JID> cl_nodes = this.strategy.getNodesForUserConnect(conn.getJID());
            ++this.clusterSyncOutTraffic;
            this.clusterController.sendToNodes(USER_CONNECTED_CMD, params, this.getComponentId(), cl_nodes.toArray(new JID[cl_nodes.size()]));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with broadcast user presence for: " + conn, e);
        }
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return this.strategy.hasCompleteJidsInfo();
    }

    @Override
    public void nodeConnected(String node) {
        log.log(Level.FINE, "Nodes connected: {0}", node);
        JID jid = JID.jidInstanceNS(this.getName(), node, null);
        this.strategy.nodeConnected(jid);
        this.sendAdminNotification("Cluster node '" + node + "' connected (" + new Date() + ")", "New cluster node connected: " + node, node);
        if (this.strategy.needsSync()) {
            this.requestSync(jid);
        }
    }

    @Override
    public void nodeDisconnected(String node) {
        log.log(Level.FINE, "Nodes disconnected: {0}", node);
        JID jid = JID.jidInstanceNS(this.getName(), node, null);
        this.strategy.nodeDisconnected(jid);
        this.sendAdminNotification("Cluster node '" + node + "' disconnected (" + new Date() + ")", "Cluster node disconnected: " + node, node);
    }

    protected Map<String, String> prepareConnectionParams(XMPPResourceConnection conn) throws NotAuthorizedException, NoConnectionIdException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(USER_ID, conn.getBareJID().toString());
        params.put(RESOURCE, conn.getResource());
        params.put(CONNECTION_ID, conn.getConnectionId().toString());
        params.put(XMPP_SESSION_ID, conn.getSessionId());
        params.put(AUTH_TIME, "" + conn.getAuthTime());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for conn: {0}, result: ", new Object[]{conn, params});
        }
        return params;
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Received packet: {0}", packet);
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
        } else {
            XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
            List<JID> toNodes = this.strategy.getNodesForPacketForward(this.getComponentId(), null, packet);
            if (toNodes != null && toNodes.size() > 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Forwarding packet {0} to nodes: {1}", new Object[]{packet, toNodes});
                }
                LinkedHashMap<String, String> data = null;
                if (conn != null) {
                    data = new LinkedHashMap<String, String>();
                    data.put(SESSION_FOUND_KEY, this.getComponentId().toString());
                }
                this.clusterController.sendToNodes(PACKET_FORWARD_CMD, data, packet.getElement(), this.getComponentId(), null, toNodes.toArray(new JID[toNodes.size()]));
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "No cluster nodes found for packet forward: {0}", new Object[]{packet});
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Ressource connection found: {0}", conn);
            }
            if (conn == null) {
                if (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Ignoring/dropping packet: {0}", packet);
                    }
                } else if (toNodes == null || toNodes.size() == 0) {
                    this.processPacket(packet, (XMPPResourceConnection)null);
                }
            } else {
                this.processPacket(packet, conn);
            }
        }
    }

    protected boolean sendToNextNode(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Packet packet) {
        boolean result = false;
        List<JID> nextNodes = this.strategy.getNodesForPacketForward(fromNode, visitedNodes, packet);
        if (nextNodes != null && nextNodes.size() > 0) {
            this.clusterController.sendToNodes(PACKET_FORWARD_CMD, data, packet.getElement(), fromNode, visitedNodes, nextNodes.toArray(new JID[nextNodes.size()]));
            result = true;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for packet: {0}, visitedNodes: {1}, result: {2}", new Object[]{packet, visitedNodes, result});
        }
        return result;
    }

    @Override
    public int processingInThreads() {
        return Math.max(this.nodesNo, super.processingInThreads());
    }

    @Override
    public int processingOutThreads() {
        return Math.max(this.nodesNo, super.processingOutThreads());
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.clusterController = cl_controller;
        this.clusterController.removeCommandListener(USER_CONNECTED_CMD, this.userConnected);
        this.clusterController.removeCommandListener(USER_DISCONNECTED_CMD, this.userDisconnected);
        this.clusterController.removeCommandListener(USER_PRESENCE_CMD, this.userPresence);
        this.clusterController.removeCommandListener(PACKET_FORWARD_CMD, this.packetForward);
        this.clusterController.removeCommandListener(REQUEST_SYNCONLINE_CMD, this.requestSyncOnline);
        this.clusterController.removeCommandListener(RESPOND_SYNCONLINE_CMD, this.respondSyncOnline);
        this.clusterController.setCommandListener(USER_CONNECTED_CMD, this.userConnected);
        this.clusterController.setCommandListener(USER_DISCONNECTED_CMD, this.userDisconnected);
        this.clusterController.setCommandListener(USER_PRESENCE_CMD, this.userPresence);
        this.clusterController.setCommandListener(PACKET_FORWARD_CMD, this.packetForward);
        this.clusterController.setCommandListener(REQUEST_SYNCONLINE_CMD, this.requestSyncOnline);
        this.clusterController.setCommandListener(RESPOND_SYNCONLINE_CMD, this.respondSyncOnline);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.get(STRATEGY_CLASS_PROP_KEY) != null) {
            String strategy_class = (String)props.get(STRATEGY_CLASS_PROP_KEY);
            try {
                ClusteringStrategyIfc strategy_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
                strategy_tmp.setProperties(props);
                this.strategy = strategy_tmp;
                this.strategy.setSessionManagerHandler(this);
                log.log(Level.CONFIG, "Loaded SM strategy: " + strategy_class);
                this.addTrusted(this.getComponentId());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not clustering strategy instance for class: " + strategy_class, e);
            }
        }
        try {
            if (props.get(MY_DOMAIN_NAME_PROP_KEY) != null) {
                this.my_hostname = JID.jidInstance((String)props.get(MY_DOMAIN_NAME_PROP_KEY));
                this.my_address = JID.jidInstance(this.getName(), (String)props.get(MY_DOMAIN_NAME_PROP_KEY), null);
            }
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.WARNING, "Creating component source address failed stringprep processing: {0}@{1}", new Object[]{this.getName(), this.my_hostname});
        }
    }

    @Override
    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for conn: {0}, closeOnly: {1}", new Object[]{conn, closeOnly});
        }
        try {
            if (conn.isAuthorized() && conn.isResourceSet()) {
                Map<String, String> params = this.prepareConnectionParams(conn);
                List<JID> cl_nodes = this.strategy.getNodesForUserDisconnect(conn.getJID());
                ++this.clusterSyncOutTraffic;
                this.clusterController.sendToNodes(USER_DISCONNECTED_CMD, params, this.getComponentId(), cl_nodes.toArray(new JID[cl_nodes.size()]));
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
        try {
            super.closeSession(conn, closeOnly);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
    }

    protected ConnectionRecord getConnectionRecord(JID node, Map<String, String> data) {
        BareJID userId = BareJID.bareJIDInstanceNS(data.get(USER_ID));
        String resource = data.get(RESOURCE);
        JID jid = JID.jidInstanceNS(userId, resource);
        String sessionId = data.get(XMPP_SESSION_ID);
        JID connectionId = JID.jidInstanceNS(data.get(CONNECTION_ID));
        ConnectionRecord rec = new ConnectionRecord(node, jid, sessionId, connectionId);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "ConnectionRecord created: {0}", new Object[]{rec});
        }
        return rec;
    }

    protected void requestSync(JID node) {
        ++this.clusterSyncOutTraffic;
        this.clusterController.sendToNodes(REQUEST_SYNCONLINE_CMD, this.getComponentId(), node);
    }

    private void sendAdminNotification(String msg, String subject, String node) {
        String message = msg;
        if (node != null) {
            message = msg + "\n";
        }
        boolean cnt = false;
        message = message + node + " connected to " + this.getDefHostName();
        Packet p_msg = Message.getMessage(this.my_address, this.my_hostname, StanzaType.normal, message, subject, "xyz", this.newPacketId(null));
        this.sendToAdmins(p_msg);
    }

    private class PacketForwardCommand
    implements CommandListener {
        private PacketForwardCommand() {
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            if (packets != null && packets.size() > 0) {
                for (Element elem : packets) {
                    try {
                        Packet el_packet = Packet.packetInstance(elem);
                        XMPPResourceConnection conn = SessionManagerClustered.this.getXMPPResourceConnection(el_packet);
                        LinkedHashMap<String, String> locdata = null;
                        if (conn != null) {
                            locdata = new LinkedHashMap<String, String>();
                            if (data != null) {
                                locdata.putAll(data);
                            }
                            data.put(SessionManagerClustered.SESSION_FOUND_KEY, SessionManagerClustered.this.getComponentId().toString());
                        }
                        boolean isSent = SessionManagerClustered.this.sendToNextNode(fromNode, visitedNodes, data, Packet.packetInstance(elem));
                        if (conn != null) {
                            if (SessionManagerClustered.this.getComponentId().equals(fromNode)) continue;
                            SessionManagerClustered.this.processPacket(el_packet, conn);
                            continue;
                        }
                        if (!SessionManagerClustered.this.getComponentId().equals(fromNode) || data != null && data.get(SessionManagerClustered.SESSION_FOUND_KEY) != null) continue;
                        SessionManagerClustered.this.processPacket(el_packet, conn);
                    }
                    catch (TigaseStringprepException ex) {
                        log.warning("Addressing problem, stringprep failed for packet: " + elem);
                    }
                }
            } else {
                log.finest("Empty packets list in the forward command");
            }
        }
    }

    private class UserDisconnectedCommand
    implements CommandListener {
        private UserDisconnectedCommand() {
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            ++SessionManagerClustered.this.clusterSyncInTraffic;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            ArrayDeque<Packet> results = new ArrayDeque<Packet>(10);
            ConnectionRecord rec = SessionManagerClustered.this.getConnectionRecord(fromNode, data);
            SessionManagerClustered.this.strategy.userDisconnected(results, rec);
            SessionManagerClustered.this.addOutPackets(results);
        }
    }

    private class UserConnectedCommand
    implements CommandListener {
        private UserConnectedCommand() {
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            XMPPResourceConnection conn;
            ++SessionManagerClustered.this.clusterSyncInTraffic;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            ArrayDeque<Packet> results = new ArrayDeque<Packet>(10);
            ConnectionRecord rec = SessionManagerClustered.this.getConnectionRecord(fromNode, data);
            SessionManagerClustered.this.strategy.usersConnected(results, rec);
            SessionManagerClustered.this.addOutPackets(results);
            XMPPSession session = SessionManagerClustered.this.getSession(rec.getUserJid().getBareJID());
            if (session != null && (conn = session.getResourceForResource(rec.getUserJid().getResource())) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Duplicate resource connection, logingout the older connection: " + rec);
                }
                try {
                    Packet cmd = Command.CLOSE.getPacket(SessionManagerClustered.this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId());
                    Element err_el = new Element("conflict");
                    err_el.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
                    cmd.getElement().getChild("command").addChild(err_el);
                    SessionManagerClustered.this.fastAddOutPacket(cmd);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("User connected jid: " + rec.getUserJid() + ", fromNode: " + fromNode);
            }
        }
    }

    private class UserPresenceCommand
    implements CommandListener {
        private UserPresenceCommand() {
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            ++SessionManagerClustered.this.clusterSyncInTraffic;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            ConnectionRecord rec = SessionManagerClustered.this.getConnectionRecord(fromNode, data);
            XMPPSession session = SessionManagerClustered.this.getSession(rec.getUserJid().getBareJID());
            Element elem = packets.poll();
            SessionManagerClustered.this.strategy.presenceUpdate(elem, rec);
            if (session != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "User's {0} XMPPSession found: {1}", new Object[]{rec.getUserJid().getBareJID(), session});
                }
                for (XMPPResourceConnection conn : session.getActiveResources()) {
                    Element conn_presence = conn.getPresence();
                    if (!conn.isAuthorized() || !conn.isResourceSet() || conn_presence == null) continue;
                    try {
                        Packet presence = Packet.packetInstance(elem);
                        presence.setPacketTo(conn.getConnectionId());
                        SessionManagerClustered.this.fastAddOutPacket(presence);
                        if (data == null || !SessionManagerClustered.PRESENCE_TYPE_INITIAL.equals(data.get(SessionManagerClustered.PRESENCE_TYPE_KEY))) continue;
                        presence = Packet.packetInstance(conn_presence);
                        presence.setPacketTo(rec.getConnectionId());
                        SessionManagerClustered.this.fastAddOutPacket(presence);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "No user session for presence update: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("User presence jid: " + rec.getUserJid() + ", fromNode: " + fromNode);
            }
        }
    }

    private class RequestSyncOnlineCommand
    implements CommandListener {
        private RequestSyncOnlineCommand() {
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            ++SessionManagerClustered.this.clusterSyncInTraffic;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            LinkedList<Element> usrConns = new LinkedList<Element>();
            for (XMPPResourceConnection conn : SessionManagerClustered.this.connectionsByFrom.values()) {
                try {
                    if (!conn.isResourceSet()) continue;
                    ConnectionRecord cr = new ConnectionRecord(SessionManagerClustered.this.getComponentId(), conn.getJID(), conn.getSessionId(), conn.getConnectionId());
                    cr.setLastPresence(conn.getPresence());
                    usrConns.add(cr.toElement());
                    if (usrConns.size() <= 1000) continue;
                    SessionManagerClustered.this.clusterController.sendToNodes(SessionManagerClustered.RESPOND_SYNCONLINE_CMD, usrConns, SessionManagerClustered.this.getComponentId(), null, fromNode);
                    usrConns = new LinkedList();
                }
                catch (NotAuthorizedException ex) {
                }
                catch (NoConnectionIdException ex) {}
            }
            if (usrConns.size() > 0) {
                SessionManagerClustered.this.clusterController.sendToNodes(SessionManagerClustered.RESPOND_SYNCONLINE_CMD, usrConns, SessionManagerClustered.this.getComponentId(), null, fromNode);
            }
        }
    }

    private class RespondSyncOnlineCommand
    implements CommandListener {
        private RespondSyncOnlineCommand() {
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> elements) throws ClusterCommandException {
            ++SessionManagerClustered.this.clusterSyncInTraffic;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, elements});
            }
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            ArrayList<ConnectionRecord> usrConns = new ArrayList<ConnectionRecord>(elements.size());
            for (Element elem : elements) {
                usrConns.add(new ConnectionRecord(elem));
            }
            SessionManagerClustered.this.strategy.usersConnected(results, usrConns.toArray(new ConnectionRecord[usrConns.size()]));
        }
    }
}

